/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.datamodel.configuration;

import de.proveo.util.jpa.entity.EntityBase;
import de.proveo.wwt.datamodel.configuration.ConfigurationGroup;
import de.proveo.wwt.datamodel.domain.Domain;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.GenericGenerator;

@Entity
@NamedQueries(value={@NamedQuery(name="configurationProperty_findAll", query="SELECT c FROM ConfigurationProperty c ORDER BY c.name"), @NamedQuery(name="configurationProperty_findAllByGroupId", query="SELECT c FROM ConfigurationProperty c WHERE c.group.id = ?1 ORDER BY c.name"), @NamedQuery(name="configurationProperty_findByName", query="SELECT c FROM ConfigurationProperty c WHERE c.name = ?1"), @NamedQuery(name="configurationProperty_findByDefaultDomainAndGroupIdAndName", query="SELECT c FROM ConfigurationProperty c WHERE c.domain IS NULL AND c.group.id = :groupId AND c.name = :name"), @NamedQuery(name="configurationProperty_findByDefaultDomainAndGroupId", query="SELECT c FROM ConfigurationProperty c WHERE c.domain IS NULL AND c.group.id = ?1 ORDER BY c.name"), @NamedQuery(name="configurationProperty_findByDefaultDomain", query="SELECT c FROM ConfigurationProperty c WHERE c.domain IS NULL ORDER BY c.name"), @NamedQuery(name="configurationProperty_findByDomainIdAndGroupId", query="SELECT c FROM ConfigurationProperty c WHERE c.domain.id = :domainId AND c.group.id = :groupId ORDER BY c.name"), @NamedQuery(name="configurationProperty_findByDomainIdAndGroupIdAndName", query="SELECT c FROM ConfigurationProperty c WHERE c.domain.id = :domainId AND c.group.id = :groupId AND c.name = :name"), @NamedQuery(name="configurationProperty_deleteByPk", query="DELETE FROM ConfigurationProperty c WHERE c.id = ?1")})
@Table(name="cfg_parameter", uniqueConstraints={@UniqueConstraint(columnNames={"NAME", "PK_GROUP", "PK_DOMAIN"})})
public class ConfigurationProperty
extends EntityBase {
    private static final long serialVersionUID = -2854934052427609716L;
    @Id
    @GenericGenerator(name="incrementer", strategy="increment")
    @GeneratedValue(generator="incrementer")
    @Column(name="ID")
    private int id;
    @Column(name="NAME", nullable=false)
    private String name;
    @Lob
    @Column(name="VALUE", length=0x500000)
    private String value;
    @Column(name="PK_GROUP")
    private int groupId;
    @ManyToOne(targetEntity=ConfigurationGroup.class, fetch=FetchType.LAZY)
    @JoinColumn(name="PK_GROUP", nullable=false, updatable=false, insertable=false)
    private ConfigurationGroup group;
    @Column(name="PK_DOMAIN")
    private Integer domainId;
    @ManyToOne(targetEntity=Domain.class, fetch=FetchType.LAZY)
    @JoinColumn(name="PK_DOMAIN", updatable=false, insertable=false)
    private Domain domain;

    public Object getPrimaryKey() {
        return this.id;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public ConfigurationGroup getGroup() {
        return this.group;
    }

    public void setGroup(ConfigurationGroup group) {
        this.group = group;
    }

    public Domain getDomain() {
        return this.domain;
    }

    public void setDomain(Domain domain) {
        this.domain = domain;
    }

    public int getConfigurationGroupId() {
        return this.groupId;
    }

    public void setGroupId(int groupId) {
        this.groupId = groupId;
    }

    public Integer getDomainId() {
        return this.domainId;
    }

    public void setDomainId(Integer domainId) {
        this.domainId = domainId;
    }
}

