/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.datamodel.audit;

import de.proveo.maven.plugins.extendedObject.annotations.Equals;
import de.proveo.maven.plugins.extendedObject.annotations.ToString;
import de.proveo.util.jpa.entity.EntityBase;
import de.proveo.wwt.datamodel.account.Account;
import de.proveo.wwt.datamodel.module.Module;
import de.proveo.wwt.logic.ejb.dataOut.audit.ActionType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.QueryHint;
import javax.persistence.Table;
import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name="auditdata")
@NamedQueries(value={@NamedQuery(name="auditdata_findNonSystemAccessByInterval", query="SELECT OBJECT(a) FROM Auditdata AS a WHERE a.createTime > :begin AND a.createTime < :end AND a.actionType NOT IN (4, 5, 6) ORDER BY a.createTime ASC", hints={@QueryHint(name="org.hibernate.cacheable", value="true")}), @NamedQuery(name="auditdata_findSystemAccessByInterval", query="SELECT OBJECT(a) FROM Auditdata AS a WHERE a.createTime > :begin AND a.createTime < :end AND a.actionType IN (4, 5, 6) ORDER BY a.createTime ASC")})
public class Auditdata
extends EntityBase {
    private static final long serialVersionUID = -5302656573173437100L;
    @Equals
    @Id
    @Column(name="AUDIT_ID")
    @GenericGenerator(name="incrementer", strategy="increment")
    @GeneratedValue(generator="incrementer")
    @ToString
    private long auditId;
    @Equals
    @Lob
    @Column(name="CHANGES")
    @ToString
    private String changes;
    @Equals
    @Column(name="PK_MODIFIEDRECORD")
    @ToString
    private String pkModifiedRecord;
    @Equals
    @Column(name="CREATE_TIME")
    @ToString
    private long createTime;
    @Equals
    @Column(name="MODIFIED_ENTITY")
    @ToString
    private String modifiedEntity;
    @Equals
    @ManyToOne(targetEntity=Account.class, fetch=FetchType.EAGER)
    @JoinColumn(name="USER_ID")
    @ToString
    private Account user;
    @Equals
    @Column(name="ACTION_TYPE")
    @ToString
    private short actionType;
    @Equals
    @Column(name="MODULE_ID")
    @ToString
    private int moduleId;
    @ManyToOne(targetEntity=Module.class, fetch=FetchType.EAGER, optional=false)
    @JoinColumn(name="MODULE_ID", insertable=false, updatable=false)
    private Module module;

    public Auditdata(Auditdata auditdata) {
        this.auditId = auditdata.auditId;
        this.changes = auditdata.changes;
        this.pkModifiedRecord = auditdata.pkModifiedRecord;
        this.createTime = auditdata.createTime;
        this.modifiedEntity = auditdata.modifiedEntity;
        this.user = auditdata.user;
        this.actionType = auditdata.actionType;
        this.module = auditdata.module;
    }

    public Auditdata() {
    }

    public String getName() {
        return this.modifiedEntity;
    }

    public Object getPrimaryKey() {
        return this.auditId;
    }

    public long getAuditId() {
        return this.auditId;
    }

    public void setAuditId(long auditId) {
        this.auditId = auditId;
    }

    public String getUsername() {
        Account user = this.getUser();
        return user == null ? "superadmin" : user.getUsername();
    }

    public String getModuleName() {
        return this.module.getName();
    }

    public String getChanges() {
        return this.changes;
    }

    public void setChanges(String changes) {
        this.changes = changes;
    }

    public String getPkModifiedRecord() {
        return this.pkModifiedRecord;
    }

    public void setPkModifiedRecord(String pkModifiedRecord) {
        this.pkModifiedRecord = pkModifiedRecord;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public String getModifiedEntity() {
        return this.modifiedEntity;
    }

    public void setModifiedEntity(String modifiedEntity) {
        this.modifiedEntity = modifiedEntity;
    }

    public Account getUser() {
        return this.user;
    }

    public void setUser(Account user) {
        this.user = user;
    }

    public ActionType getActionType() {
        return ActionType.getEnum(this.actionType);
    }

    public void setActionType(ActionType actionType) {
        this.actionType = actionType.getValue().byteValue();
    }

    public int getModuleId() {
        return this.moduleId;
    }

    public void setModuleId(int applicationId) {
        this.moduleId = applicationId;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Auditdata");
        stringBuilder.append(" (");
        stringBuilder.append("auditId = ");
        stringBuilder.append(this.auditId);
        stringBuilder.append(", ");
        stringBuilder.append("changes = ");
        stringBuilder.append(this.changes == null ? "[null]" : this.changes.toString());
        stringBuilder.append(", ");
        stringBuilder.append("pkModifiedRecord = ");
        stringBuilder.append(this.pkModifiedRecord == null ? "[null]" : this.pkModifiedRecord.toString());
        stringBuilder.append(", ");
        stringBuilder.append("createTime = ");
        stringBuilder.append(this.createTime);
        stringBuilder.append(", ");
        stringBuilder.append("modifiedEntity = ");
        stringBuilder.append(this.modifiedEntity == null ? "[null]" : this.modifiedEntity.toString());
        stringBuilder.append(", ");
        stringBuilder.append("user = ");
        stringBuilder.append(this.user == null ? "[null]" : this.user.toString());
        stringBuilder.append(", ");
        stringBuilder.append("actionType = ");
        stringBuilder.append(this.actionType);
        stringBuilder.append(", ");
        stringBuilder.append("moduleId = ");
        stringBuilder.append(this.moduleId);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        Auditdata auditdata = (Auditdata)((Object)object);
        if (this.auditId != auditdata.auditId) {
            return false;
        }
        if (this.changes == null ? auditdata.changes != null : !this.changes.equals(auditdata.changes)) {
            return false;
        }
        if (this.pkModifiedRecord == null ? auditdata.pkModifiedRecord != null : !this.pkModifiedRecord.equals(auditdata.pkModifiedRecord)) {
            return false;
        }
        if (this.createTime != auditdata.createTime) {
            return false;
        }
        if (this.modifiedEntity == null ? auditdata.modifiedEntity != null : !this.modifiedEntity.equals(auditdata.modifiedEntity)) {
            return false;
        }
        if (this.user == null ? auditdata.user != null : !this.user.equals(auditdata.user)) {
            return false;
        }
        if (this.actionType != auditdata.actionType) {
            return false;
        }
        return this.moduleId == auditdata.moduleId;
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = n * n2 + (int)(this.auditId ^ this.auditId >>> 32);
        n2 = n * n2 + (this.changes == null ? 0 : this.changes.hashCode());
        n2 = n * n2 + (this.pkModifiedRecord == null ? 0 : this.pkModifiedRecord.hashCode());
        n2 = n * n2 + (int)(this.createTime ^ this.createTime >>> 32);
        n2 = n * n2 + (this.modifiedEntity == null ? 0 : this.modifiedEntity.hashCode());
        n2 = n * n2 + (this.user == null ? 0 : this.user.hashCode());
        n2 = n * n2 + this.actionType;
        n2 = n * n2 + this.moduleId;
        return n2;
    }
}

