/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.datamodel.account;

import de.proveo.maven.plugins.extendedObject.annotations.Equals;
import de.proveo.maven.plugins.extendedObject.annotations.ToString;
import de.proveo.wwt.datamodel.AuditEntityBase;
import de.proveo.wwt.datamodel.audit.Auditdata;
import de.proveo.wwt.datamodel.file.FileDirectory;
import de.proveo.wwt.datamodel.file.FileStorage;
import de.proveo.wwt.datamodel.groupIdent.GroupIdent;
import de.proveo.wwt.datamodel.infoman.setup.update.InfomanUpdate;
import de.proveo.wwt.datamodel.role.IRoleOwner;
import de.proveo.wwt.datamodel.role.Role;
import de.proveo.wwt.datamodel.scheduledReports.ScheduledReport;
import de.proveo.wwt.datamodel.unit.permission.IUnitPermissionOwner;
import de.proveo.wwt.datamodel.unit.permission.UnitPermission;
import de.proveo.wwt.logic.ejb.dataOut.audit.AuditRelevant;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.QueryHint;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name="account")
@NamedQueries(value={@NamedQuery(name="findAccountAll", query="SELECT a FROM Account a WHERE a.deleted = false ORDER BY a.username ASC", hints={@QueryHint(name="org.hibernate.cacheable", value="true")}), @NamedQuery(name="findAccountByUsername", query="SELECT a FROM Account a WHERE a.deleted = false AND a.username = ?1", hints={@QueryHint(name="org.hibernate.cacheable", value="true")}), @NamedQuery(name="userCount", query="SELECT COUNT(*) FROM Account a", hints={@QueryHint(name="org.hibernate.cacheable", value="true")})})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class Account
extends AuditEntityBase
implements Serializable,
IUnitPermissionOwner,
IRoleOwner {
    private static final long serialVersionUID = 7474541899801043154L;
    @AuditRelevant
    @Id
    @GenericGenerator(name="incrementer", strategy="increment")
    @GeneratedValue(generator="incrementer")
    @Column(name="ID")
    @Equals
    @ToString
    private long id;
    @AuditRelevant
    @Column(name="PASSWORD_RESET", nullable=false)
    @Equals
    @ToString
    private boolean passwordReset;
    @Column(name="LAST_PASSWORDS")
    @Equals
    @ToString
    private String lastPasswords;
    @AuditRelevant
    @Column(name="BLOCK_OUT", nullable=false)
    @Equals
    @ToString
    private boolean blockOut;
    @AuditRelevant
    @Column(name="EMAIL")
    @Equals
    @ToString
    private String email;
    @Column(name="FAILED_LOGINS")
    @Equals
    @ToString
    private int failedLogins;
    @AuditRelevant
    @Column(name="FIRSTNAME")
    @Equals
    @ToString
    private String firstname;
    @AuditRelevant
    @Column(name="USERNAME")
    @Equals
    @ToString
    private String username;
    @AuditRelevant
    @Column(name="LASTNAME")
    @Equals
    @ToString
    private String lastname;
    @Column(name="LOGINS")
    @Equals
    @ToString
    private int logins;
    @AuditRelevant
    @Column(name="PERSONAL_NUMBER")
    @Equals
    @ToString
    private String personalNumber;
    @Column(name="LAST_FAILED_LOGIN")
    @Equals
    @ToString
    private Long lastFailedLogin;
    @Column(name="LAST_PWD_CHANGE")
    @Equals
    @ToString
    private Long lastPwdChange;
    @Column(name="OVERALL_FAILED_LOGINS")
    @Equals
    @ToString
    private long overallFailedLogins;
    @AuditRelevant
    @Column(name="DELETED")
    @Equals
    @ToString
    private boolean deleted;
    @AuditRelevant(hideValue=true)
    @Column(name="PASSWORD")
    @Equals
    @ToString
    private String password;
    @Column(name="SUPERADMIN")
    @Equals
    @ToString
    private Boolean superadmin;
    @AuditRelevant
    @OneToMany(targetEntity=UnitPermission.class, mappedBy="account", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="ACCOUNT_ID")
    @Equals
    private List<UnitPermission> unitPermissions = new ArrayList<UnitPermission>();
    @AuditRelevant
    @ManyToMany(targetEntity=Role.class, fetch=FetchType.LAZY)
    @JoinTable(name="account_x_role", joinColumns={@JoinColumn(name="ID_ACCOUNT")}, inverseJoinColumns={@JoinColumn(name="ID_ROLE")})
    @Equals
    private List<Role> roles = new ArrayList<Role>();
    @AuditRelevant
    @ManyToMany(targetEntity=GroupIdent.class, fetch=FetchType.LAZY)
    @JoinTable(name="account_x_groupident", joinColumns={@JoinColumn(name="ID_ACCOUNT")}, inverseJoinColumns={@JoinColumn(name="ID_GROUPIDENT")})
    @Equals
    private List<GroupIdent> groups = new ArrayList<GroupIdent>();
    @ManyToMany(targetEntity=ScheduledReport.class, fetch=FetchType.LAZY)
    @JoinTable(name="scheduledreport_x_account", joinColumns={@JoinColumn(name="ID_ACCOUNT")}, inverseJoinColumns={@JoinColumn(name="ID_SCHEDULED_REPORT")})
    @Equals
    private List<ScheduledReport> scheduledReports = new ArrayList<ScheduledReport>();
    @OneToMany(targetEntity=InfomanUpdate.class, mappedBy="account", fetch=FetchType.LAZY)
    @Equals
    private List<InfomanUpdate> infomanUpdates = new ArrayList<InfomanUpdate>();
    @OneToMany(targetEntity=FileDirectory.class, mappedBy="user", fetch=FetchType.LAZY)
    @Equals
    private List<FileDirectory> fileDirectories = new ArrayList<FileDirectory>();
    @OneToMany(targetEntity=FileStorage.class, mappedBy="user", fetch=FetchType.LAZY)
    @Equals
    private List<FileStorage> files = new ArrayList<FileStorage>();
    @OneToMany(targetEntity=Auditdata.class, mappedBy="user", fetch=FetchType.LAZY)
    @Equals
    private List<Auditdata> auditdata = new ArrayList<Auditdata>();

    public Account() {
    }

    public Account(Account otherValue) {
        this.id = otherValue.id;
        this.email = otherValue.email;
        this.deleted = otherValue.deleted;
        this.firstname = otherValue.firstname;
        this.lastname = otherValue.lastname;
        this.password = otherValue.password;
        this.username = otherValue.username;
        this.personalNumber = otherValue.personalNumber;
        this.blockOut = otherValue.blockOut;
        this.failedLogins = otherValue.failedLogins;
        this.logins = otherValue.logins;
        this.lastFailedLogin = otherValue.lastFailedLogin;
        this.overallFailedLogins = otherValue.overallFailedLogins;
        this.lastPasswords = otherValue.lastPasswords;
    }

    public String getName() {
        return this.username;
    }

    public long getId() {
        return this.id;
    }

    @Override
    public Object getPrimaryKey() {
        return this.getId();
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getLastPasswords() {
        return this.lastPasswords;
    }

    public void setLastPasswords(String lastPasswords) {
        this.lastPasswords = lastPasswords;
    }

    public boolean getBlockOut() {
        return this.blockOut;
    }

    public void setBlockOut(boolean blockOut) {
        this.blockOut = blockOut;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public int getFailedLogins() {
        return this.failedLogins;
    }

    public void setFailedLogins(int failedLogins) {
        this.failedLogins = failedLogins;
    }

    public String getFirstname() {
        return this.firstname;
    }

    public void setFirstname(String firstname) {
        this.firstname = firstname;
    }

    public Boolean getDeleted() {
        return this.deleted;
    }

    public void setDeleted(Boolean deleted) {
        if (!this.deleted && deleted.booleanValue()) {
            this.setAuditBehaviour(AuditEntityBase.AuditBehaviour.REMOVE);
        } else if (this.deleted && !deleted.booleanValue()) {
            this.setAuditBehaviour(AuditEntityBase.AuditBehaviour.DEFAULT);
        }
        this.deleted = deleted;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getLastname() {
        return this.lastname;
    }

    public void setLastname(String lastname) {
        this.lastname = lastname;
    }

    public int getLogins() {
        return this.logins;
    }

    public void setLogins(int logins) {
        this.logins = logins;
    }

    public String getPersonalNumber() {
        return this.personalNumber;
    }

    public void setPersonalNumber(String personalNumber) {
        this.personalNumber = personalNumber;
    }

    public Long getLastFailedLogin() {
        return this.lastFailedLogin;
    }

    public void setLastFailedLogin(Long lastFailedLogin) {
        this.lastFailedLogin = lastFailedLogin;
    }

    public Long getLastPwdChange() {
        return this.lastPwdChange;
    }

    public void setLastPwdChange(Long lastPwdChange) {
        this.lastPwdChange = lastPwdChange;
    }

    public long getOverallFailedLogins() {
        return this.overallFailedLogins;
    }

    public void setOverallFailedLogins(long overallFailedLogins) {
        this.overallFailedLogins = overallFailedLogins;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Boolean isSuperadmin() {
        return this.superadmin;
    }

    public void setSuperadmin(Boolean superadmin) {
        this.superadmin = superadmin;
    }

    @Override
    public List<UnitPermission> getUnitPermissions() {
        return this.unitPermissions;
    }

    @Override
    public void setUnitPermissions(List<UnitPermission> unitPermissions) {
        this.unitPermissions = unitPermissions;
    }

    @Override
    public void setPermissionOwner(UnitPermission unitPermission) {
        unitPermission.setAccountId(this.getId());
    }

    @Override
    public boolean isPermissionOwner(UnitPermission unitPermission) {
        Long id = unitPermission.getAccountId();
        return id != null && id.equals(this.getPrimaryKey());
    }

    @Override
    public List<Role> getRoles() {
        return this.roles;
    }

    @Override
    public void setRoles(List<Role> roles) {
        this.roles = roles;
    }

    public List<InfomanUpdate> getInfomanUpdates() {
        return this.infomanUpdates;
    }

    public void setInfomanUpdates(List<InfomanUpdate> infomanUpdates) {
        this.infomanUpdates = infomanUpdates;
    }

    public List<GroupIdent> getGroups() {
        return this.groups;
    }

    public void setGroups(List<GroupIdent> groups) {
        this.groups = groups;
    }

    public List<ScheduledReport> getScheduledReports() {
        return this.scheduledReports;
    }

    public void setScheduledReports(List<ScheduledReport> scheduledReports) {
        this.scheduledReports = scheduledReports;
    }

    public boolean idHasBeenSet() {
        return this.id != 0L;
    }

    public boolean isPasswordReset() {
        return this.passwordReset;
    }

    public void setPasswordReset(boolean passwordReset) {
        this.passwordReset = passwordReset;
    }

    public List<Auditdata> getAuditdata() {
        return this.auditdata;
    }

    public void setAuditdata(List<Auditdata> auditdata) {
        this.auditdata = auditdata;
    }

    public List<FileDirectory> getFileDirectories() {
        return this.fileDirectories;
    }

    public void setFileDirectories(List<FileDirectory> fileDirectories) {
        this.fileDirectories = fileDirectories;
    }

    public List<FileStorage> getFiles() {
        return this.files;
    }

    public void setFiles(List<FileStorage> files) {
        this.files = files;
    }

    public void addGroupIdent(GroupIdent groupIdent) {
        if (groupIdent != null && !this.groups.contains(groupIdent)) {
            this.groups.add(groupIdent);
            groupIdent.addAccount(this);
        }
    }

    @Override
    public void addRole(Role role) {
        if (role != null && !this.roles.contains(role)) {
            this.roles.add(role);
            role.addAccount(this);
        }
    }

    @Override
    public void addRoles(List<Role> roles) {
        for (Role role : roles) {
            this.addRole(role);
        }
    }

    @Override
    public void replaceRoles(List<Role> newRoles) {
        if (this.roles == null) {
            this.roles = new ArrayList<Role>(newRoles.size());
        } else {
            this.roles.clear();
        }
        this.addRoles(newRoles);
    }

    public void addScheduledReport(ScheduledReport scheduledReport) {
        if (scheduledReport != null && !this.scheduledReports.contains((Object)scheduledReport)) {
            this.scheduledReports.add(scheduledReport);
            scheduledReport.addAccount(this);
        }
    }

    public void addUnitPermission(UnitPermission unitPermission) {
        if (unitPermission != null && !this.unitPermissions.contains(unitPermission)) {
            this.unitPermissions.add(unitPermission);
            unitPermission.setAccountId(this.getId());
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Account");
        stringBuilder.append(" (");
        stringBuilder.append("id = ");
        stringBuilder.append(this.id);
        stringBuilder.append(", ");
        stringBuilder.append("passwordReset = ");
        stringBuilder.append(this.passwordReset);
        stringBuilder.append(", ");
        stringBuilder.append("lastPasswords = ");
        stringBuilder.append(this.lastPasswords == null ? "[null]" : this.lastPasswords.toString());
        stringBuilder.append(", ");
        stringBuilder.append("blockOut = ");
        stringBuilder.append(this.blockOut);
        stringBuilder.append(", ");
        stringBuilder.append("email = ");
        stringBuilder.append(this.email == null ? "[null]" : this.email.toString());
        stringBuilder.append(", ");
        stringBuilder.append("failedLogins = ");
        stringBuilder.append(this.failedLogins);
        stringBuilder.append(", ");
        stringBuilder.append("firstname = ");
        stringBuilder.append(this.firstname == null ? "[null]" : this.firstname.toString());
        stringBuilder.append(", ");
        stringBuilder.append("username = ");
        stringBuilder.append(this.username == null ? "[null]" : this.username.toString());
        stringBuilder.append(", ");
        stringBuilder.append("lastname = ");
        stringBuilder.append(this.lastname == null ? "[null]" : this.lastname.toString());
        stringBuilder.append(", ");
        stringBuilder.append("logins = ");
        stringBuilder.append(this.logins);
        stringBuilder.append(", ");
        stringBuilder.append("personalNumber = ");
        stringBuilder.append(this.personalNumber == null ? "[null]" : this.personalNumber.toString());
        stringBuilder.append(", ");
        stringBuilder.append("lastFailedLogin = ");
        stringBuilder.append(this.lastFailedLogin == null ? "[null]" : this.lastFailedLogin.toString());
        stringBuilder.append(", ");
        stringBuilder.append("lastPwdChange = ");
        stringBuilder.append(this.lastPwdChange == null ? "[null]" : this.lastPwdChange.toString());
        stringBuilder.append(", ");
        stringBuilder.append("overallFailedLogins = ");
        stringBuilder.append(this.overallFailedLogins);
        stringBuilder.append(", ");
        stringBuilder.append("deleted = ");
        stringBuilder.append(this.deleted);
        stringBuilder.append(", ");
        stringBuilder.append("password = ");
        stringBuilder.append(this.password == null ? "[null]" : this.password.toString());
        stringBuilder.append(", ");
        stringBuilder.append("superadmin = ");
        stringBuilder.append(this.superadmin == null ? "[null]" : this.superadmin.toString());
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Account account = (Account)object;
        if (this.id != account.id) {
            return false;
        }
        if (this.passwordReset != account.passwordReset) {
            return false;
        }
        if (this.lastPasswords == null ? account.lastPasswords != null : !this.lastPasswords.equals(account.lastPasswords)) {
            return false;
        }
        if (this.blockOut != account.blockOut) {
            return false;
        }
        if (this.email == null ? account.email != null : !this.email.equals(account.email)) {
            return false;
        }
        if (this.failedLogins != account.failedLogins) {
            return false;
        }
        if (this.firstname == null ? account.firstname != null : !this.firstname.equals(account.firstname)) {
            return false;
        }
        if (this.username == null ? account.username != null : !this.username.equals(account.username)) {
            return false;
        }
        if (this.lastname == null ? account.lastname != null : !this.lastname.equals(account.lastname)) {
            return false;
        }
        if (this.logins != account.logins) {
            return false;
        }
        if (this.personalNumber == null ? account.personalNumber != null : !this.personalNumber.equals(account.personalNumber)) {
            return false;
        }
        if (this.lastFailedLogin == null ? account.lastFailedLogin != null : !this.lastFailedLogin.equals(account.lastFailedLogin)) {
            return false;
        }
        if (this.lastPwdChange == null ? account.lastPwdChange != null : !this.lastPwdChange.equals(account.lastPwdChange)) {
            return false;
        }
        if (this.overallFailedLogins != account.overallFailedLogins) {
            return false;
        }
        if (this.deleted != account.deleted) {
            return false;
        }
        if (this.password == null ? account.password != null : !this.password.equals(account.password)) {
            return false;
        }
        if (this.superadmin == null ? account.superadmin != null : !this.superadmin.equals(account.superadmin)) {
            return false;
        }
        if (this.unitPermissions == null ? account.unitPermissions != null : !this.unitPermissions.equals(account.unitPermissions)) {
            return false;
        }
        if (this.roles == null ? account.roles != null : !this.roles.equals(account.roles)) {
            return false;
        }
        if (this.groups == null ? account.groups != null : !this.groups.equals(account.groups)) {
            return false;
        }
        if (this.scheduledReports == null ? account.scheduledReports != null : !this.scheduledReports.equals(account.scheduledReports)) {
            return false;
        }
        if (this.infomanUpdates == null ? account.infomanUpdates != null : !this.infomanUpdates.equals(account.infomanUpdates)) {
            return false;
        }
        if (this.fileDirectories == null ? account.fileDirectories != null : !this.fileDirectories.equals(account.fileDirectories)) {
            return false;
        }
        if (this.files == null ? account.files != null : !this.files.equals(account.files)) {
            return false;
        }
        return !(this.auditdata == null ? account.auditdata != null : !this.auditdata.equals(account.auditdata));
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = n * n2 + (int)(this.id ^ this.id >>> 32);
        n2 = n * n2 + (this.passwordReset ? 0 : 1);
        n2 = n * n2 + (this.lastPasswords == null ? 0 : this.lastPasswords.hashCode());
        n2 = n * n2 + (this.blockOut ? 0 : 1);
        n2 = n * n2 + (this.email == null ? 0 : this.email.hashCode());
        n2 = n * n2 + this.failedLogins;
        n2 = n * n2 + (this.firstname == null ? 0 : this.firstname.hashCode());
        n2 = n * n2 + (this.username == null ? 0 : this.username.hashCode());
        n2 = n * n2 + (this.lastname == null ? 0 : this.lastname.hashCode());
        n2 = n * n2 + this.logins;
        n2 = n * n2 + (this.personalNumber == null ? 0 : this.personalNumber.hashCode());
        n2 = n * n2 + (this.lastFailedLogin == null ? 0 : this.lastFailedLogin.hashCode());
        n2 = n * n2 + (this.lastPwdChange == null ? 0 : this.lastPwdChange.hashCode());
        n2 = n * n2 + (int)(this.overallFailedLogins ^ this.overallFailedLogins >>> 32);
        n2 = n * n2 + (this.deleted ? 0 : 1);
        n2 = n * n2 + (this.password == null ? 0 : this.password.hashCode());
        n2 = n * n2 + (this.superadmin == null ? 0 : this.superadmin.hashCode());
        n2 = n * n2 + (this.unitPermissions == null ? 0 : this.unitPermissions.hashCode());
        n2 = n * n2 + (this.roles == null ? 0 : this.roles.hashCode());
        n2 = n * n2 + (this.groups == null ? 0 : this.groups.hashCode());
        n2 = n * n2 + (this.scheduledReports == null ? 0 : this.scheduledReports.hashCode());
        n2 = n * n2 + (this.infomanUpdates == null ? 0 : this.infomanUpdates.hashCode());
        n2 = n * n2 + (this.fileDirectories == null ? 0 : this.fileDirectories.hashCode());
        n2 = n * n2 + (this.files == null ? 0 : this.files.hashCode());
        n2 = n * n2 + (this.auditdata == null ? 0 : this.auditdata.hashCode());
        return n2;
    }
}

