/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.datamodel;

import de.proveo.util.jpa.JpaUtil;
import de.proveo.util.jpa.entity.EntityBase;
import de.proveo.wwt.datamodel.module.ModuleType;
import de.proveo.wwt.logic.ejb.dataOut.audit.AuditFacadeLocal;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.MappedSuperclass;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@MappedSuperclass
public abstract class AuditEntityBase
extends EntityBase {
    private static final Log log = LogFactory.getLog(AuditEntityBase.class);
    private static final long serialVersionUID = 2703492872175670614L;
    private transient AuditBehaviour auditBehaviour = AuditBehaviour.DEFAULT;
    private transient boolean loggingEnabled;
    private transient ModuleType module = ModuleType.WEB;

    protected AuditEntityBase() {
        this(true);
    }

    protected AuditEntityBase(boolean loggingEnabled) {
        this.loggingEnabled = loggingEnabled;
    }

    public boolean isLoggingEnabled() {
        return this.loggingEnabled;
    }

    public void setLoggingEnabled(boolean loggingEnabled) {
        this.loggingEnabled = loggingEnabled;
    }

    private AuditFacadeLocal getAuditFacade() {
        try {
            InitialContext context = new InitialContext();
            return (AuditFacadeLocal)context.lookup("rts/AuditFacade/local");
        }
        catch (NamingException e) {
            log.error((Object)"Runs into", (Throwable)e);
            return null;
        }
    }

    protected void setAuditBehaviour(AuditBehaviour auditBehaviour) {
        this.auditBehaviour = auditBehaviour;
    }

    protected void handleAudit() {
        switch (this.auditBehaviour) {
            case PERSIST: {
                this.logInsert();
                break;
            }
            case UPDATE: {
                this.logUpdate();
                break;
            }
            case REMOVE: {
                this.logDelete();
            }
        }
        this.auditBehaviour = AuditBehaviour.DEFAULT;
    }

    @PrePersist
    private void prePersist() {
        if (this.loggingEnabled) {
            if (this.auditBehaviour == AuditBehaviour.DEFAULT) {
                this.logInsert();
            } else {
                this.handleAudit();
            }
        }
    }

    @PreUpdate
    private void preUpdate() {
        if (this.loggingEnabled) {
            if (this.auditBehaviour == AuditBehaviour.DEFAULT) {
                this.logUpdate();
            } else {
                this.handleAudit();
            }
        }
    }

    @PreRemove
    private void preRemove() {
        if (this.loggingEnabled) {
            if (this.auditBehaviour == AuditBehaviour.DEFAULT) {
                this.logDelete();
            } else {
                this.handleAudit();
            }
        }
    }

    private void logInsert() {
        this.getAuditFacade().logInsert(this.module, this);
    }

    private void logUpdate() {
        EntityManager entityManager = JpaUtil.createAuditEntityManager();
        Object existingEntity = entityManager.find(((Object)((Object)this)).getClass(), this.getPrimaryKey());
        this.getAuditFacade().logUpdate(this.module, (AuditEntityBase)((Object)existingEntity), this);
        entityManager.close();
    }

    private void logDelete() {
        this.getAuditFacade().logDelete(this.module, this);
    }

    public ModuleType getModule() {
        return this.module;
    }

    public void setModule(ModuleType module) {
        this.module = module;
    }

    public static enum AuditBehaviour {
        DEFAULT,
        PERSIST,
        UPDATE,
        REMOVE;

    }
}

