/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.archiveextractor;

import de.proveo.idm.archiveextractor.util.ArchiveEntryLocator;
import de.proveo.idm.archiveextractor.util.Decompressor;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class ArchiveFileExtractor {
    public static final String ARCHIVE_SEPARATOR = "//";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] extract(String archivePath) throws Exception {
        byte[] payload = null;
        String[] paths = archivePath.split(ARCHIVE_SEPARATOR);
        if (paths.length == 0) {
            throw new IllegalArgumentException("Not a valid format: " + archivePath);
        }
        File archiveFile = new File(paths[0]);
        if (!archiveFile.isFile()) {
            throw new FileNotFoundException("Archive not found " + archiveFile.getPath());
        }
        payload = ArchiveFileExtractor.init(archiveFile);
        String compressionType = null;
        String archiveType = null;
        Iterator<String> pathsIterator = null;
        List<String> pathList = Arrays.asList(paths);
        pathsIterator = pathList.iterator();
        while (pathsIterator.hasNext()) {
            String newArchiveType;
            String path = pathsIterator.next();
            compressionType = ArchiveFileExtractor.getCompressionType(path);
            if (!compressionType.isEmpty()) {
                try {
                    payload = ArchiveFileExtractor.decompress(payload, compressionType);
                    archiveType = ArchiveFileExtractor.getArchiveType(path.substring(0, path.lastIndexOf(".")));
                    path = pathsIterator.next();
                }
                finally {
                    compressionType = null;
                }
            }
            if (archiveType == null || archiveType.isEmpty()) {
                archiveType = ArchiveFileExtractor.getArchiveType(path);
                path = pathsIterator.next();
            }
            payload = ArchiveEntryLocator.locateEntry(payload, path, archiveType);
            if (!pathsIterator.hasNext()) continue;
            compressionType = ArchiveFileExtractor.getCompressionType(path);
            if (!compressionType.isEmpty()) {
                try {
                    payload = ArchiveFileExtractor.decompress(payload, compressionType);
                    archiveType = ArchiveFileExtractor.getArchiveType(path.substring(0, path.lastIndexOf(".")));
                }
                finally {
                    compressionType = null;
                }
            }
            if ((newArchiveType = ArchiveFileExtractor.getArchiveType(path)).isEmpty()) continue;
            archiveType = newArchiveType;
        }
        return payload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] decompress(byte[] payload, String type) throws Exception {
        ByteArrayInputStream bIn = null;
        try {
            bIn = new ByteArrayInputStream(payload);
            byte[] byArray = Decompressor.decompress(bIn, type);
            return byArray;
        }
        finally {
            if (bIn != null) {
                bIn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] init(File file) throws Exception {
        FileInputStream fIs = null;
        BufferedInputStream bIn = null;
        ByteArrayOutputStream bOut = null;
        try {
            fIs = new FileInputStream(file);
            bIn = new BufferedInputStream(fIs);
            bOut = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)bIn, (OutputStream)bOut);
            byte[] byArray = bOut.toByteArray();
            return byArray;
        }
        finally {
            bOut.close();
            bIn.close();
            fIs.close();
        }
    }

    private static String getCompressionType(String file) {
        String name = file.toLowerCase();
        if (name.endsWith("gzip") || name.endsWith("gz")) {
            return "gz";
        }
        if (name.endsWith("bzip2")) {
            return "bzip2";
        }
        return "";
    }

    private static String getArchiveType(String file) {
        String name = file.toLowerCase();
        if (name.endsWith("jar")) {
            return "zip";
        }
        if (name.endsWith("zip")) {
            return "zip";
        }
        if (name.endsWith("tar")) {
            return "tar";
        }
        return "";
    }
}

