/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.search.impl;

import java.io.File;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.spi.search.SearchFilterDefinition;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class SharabilityFilter
extends SearchFilterDefinition {
    private static final SharabilityFilter INSTANCE = new SharabilityFilter();

    private SharabilityFilter() {
    }

    @Override
    public boolean searchFile(FileObject file) throws IllegalArgumentException {
        if (file.isFolder()) {
            throw new IllegalArgumentException("file (not folder) expected");
        }
        File f = FileUtil.toFile((FileObject)file);
        if (f == null && !file.canWrite()) {
            return true;
        }
        return SharabilityQuery.getSharability((FileObject)file) != SharabilityQuery.Sharability.NOT_SHARABLE;
    }

    @Override
    public SearchFilterDefinition.FolderResult traverseFolder(FileObject folder) throws IllegalArgumentException {
        if (!folder.isFolder()) {
            throw new IllegalArgumentException("folder expected");
        }
        File f = FileUtil.toFile((FileObject)folder);
        if (f == null && !folder.canWrite()) {
            return SearchFilterDefinition.FolderResult.TRAVERSE;
        }
        SharabilityQuery.Sharability sharability = SharabilityQuery.getSharability((FileObject)folder);
        switch (sharability) {
            case NOT_SHARABLE: {
                return SearchFilterDefinition.FolderResult.DO_NOT_TRAVERSE;
            }
            case SHARABLE: {
                return SearchFilterDefinition.FolderResult.TRAVERSE_ALL_SUBFOLDERS;
            }
        }
        return SearchFilterDefinition.FolderResult.TRAVERSE;
    }

    public static SearchFilterDefinition getInstance() {
        return INSTANCE;
    }
}

