/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.xml.request.measurements;

import de.proveo.util.dependencyInjector.Dependency;
import de.proveo.wwt.datamodel.measurement.MeasurementDefinition;
import de.proveo.wwt.datamodel.measurement.MeasurementRange;
import de.proveo.wwt.datamodel.measurement.MeasurementType;
import de.proveo.wwt.logic.ejb.general.measurement.MeasurementFacadeLocal;
import de.proveo.wwt.logic.xml.request.XmlRequestHandlerBase;
import de.proveo.wwt.logic.xml.request.XmlRequestSchema;
import de.proveo.xml.fleet_management.measurement_1.MeasurementDefn;
import de.proveo.xml.fleet_management.measurement_1.MeasurementDefns;
import de.proveo.xml.fleet_management.measurement_1.MeasurementRangeDefn;
import de.proveo.xml.fleet_management.measurement_1.MeasurementTypes;
import de.proveo.xml.fleet_management.measurement_1.MeasurementUnit;
import de.proveo.xml.fleet_management.measurement_1.Measurements;
import de.proveo.xml.fleet_management.meta_1.MetadataList;
import de.proveo.xml.fleet_management.meta_1.MetadataValue;
import java.util.List;
import java.util.Map;

@XmlRequestSchema(value={"http://proveo.de/xml/fleet-management/measurement-1.0"})
public class Measurements_1_0_RequestHandler
extends XmlRequestHandlerBase<Measurements> {
    @Dependency
    private MeasurementFacadeLocal measurementFacade;
    private boolean generateStatistics;

    @Override
    public Measurements handleRequest(String schemaNamespace, Map<String, String> parameters) {
        this.parseParameters(parameters);
        if (this.generateStatistics) {
            this.startTimer();
        }
        Measurements xmlMeasurements = new Measurements();
        this.copyMeasurements(xmlMeasurements);
        if (this.generateStatistics) {
            MetadataValue duration = new MetadataValue();
            duration.setKey(this.EXECUTION_TIME_KEY);
            duration.setValue(this.stopTimer());
            xmlMeasurements.setMeta(new MetadataList());
            xmlMeasurements.getMeta().getValue().add(duration);
        }
        return xmlMeasurements;
    }

    private void copyMeasurements(Measurements xmlMeasurements) {
        MeasurementTypes xmlMeasurementTypes = new MeasurementTypes();
        List<MeasurementType> measurementTypes = this.measurementFacade.getMeasurementTypes();
        for (MeasurementType measurementType : measurementTypes) {
            de.proveo.xml.fleet_management.measurement_1.MeasurementType xmlMeasurementType = new de.proveo.xml.fleet_management.measurement_1.MeasurementType();
            xmlMeasurementType.setId(measurementType.getId());
            xmlMeasurementType.setName(measurementType.getName());
            xmlMeasurementType.setDescription(measurementType.getDescription());
            xmlMeasurementType.setEnabled(measurementType.isEnabled());
            xmlMeasurementType.setMeasurementKindId(measurementType.getMeasurementKind().getValue().intValue());
            List<MeasurementDefinition> measurementDefinitions = this.measurementFacade.getMeasurementDefinitionByMeasurementType(measurementType.getId());
            MeasurementDefns xmlMeasurementDefns = new MeasurementDefns();
            for (MeasurementDefinition measurementDefinition : measurementDefinitions) {
                MeasurementDefn xmlMeasurementDefn = new MeasurementDefn();
                xmlMeasurementDefn.setId(measurementDefinition.getId());
                xmlMeasurementDefn.setName(measurementDefinition.getName());
                xmlMeasurementDefn.setDescription(measurementDefinition.getDescription());
                xmlMeasurementDefn.setCacheOnly(measurementDefinition.isCacheOnly());
                xmlMeasurementDefn.setCustomFormatPattern(measurementDefinition.getCustomFormatPattern());
                xmlMeasurementDefn.setMinValue(measurementDefinition.getMinValue());
                xmlMeasurementDefn.setMaxValue(measurementDefinition.getMaxValue());
                MeasurementUnit xmlMeasurementUnit = new MeasurementUnit();
                de.proveo.wwt.datamodel.measurement.MeasurementUnit measurementUnit = measurementDefinition.getMeasurementUnit();
                xmlMeasurementUnit.setId(measurementUnit.getId());
                xmlMeasurementUnit.setName(measurementUnit.getName());
                xmlMeasurementUnit.setDescription(measurementUnit.getDescription());
                xmlMeasurementUnit.setFormatPattern(measurementUnit.getFormatPattern());
                xmlMeasurementUnit.setMeasurementTypeId(measurementUnit.getMeasurementTypeId());
                xmlMeasurementDefn.setMeasurementUnit(xmlMeasurementUnit);
                List<MeasurementRange> measurementRanges = measurementDefinition.getMeasurementRanges();
                for (MeasurementRange measurementRange : measurementRanges) {
                    MeasurementRangeDefn xmlMeasurementRangeDefn = new MeasurementRangeDefn();
                    xmlMeasurementRangeDefn.setId(measurementRange.getId());
                    xmlMeasurementRangeDefn.setName(measurementRange.getName());
                    xmlMeasurementRangeDefn.setRangeBegin(measurementRange.getRangeBegin());
                    xmlMeasurementRangeDefn.setRangeEnd(measurementRange.getRangeEnd());
                    xmlMeasurementDefn.getMeasurementRangeDefn().add(xmlMeasurementRangeDefn);
                }
                xmlMeasurementDefns.getMeasurementDefn().add(xmlMeasurementDefn);
            }
            xmlMeasurementType.setMeasurementDefns(xmlMeasurementDefns);
            xmlMeasurementTypes.getMeasurementType().add(xmlMeasurementType);
        }
        xmlMeasurements.setMeasurementTypes(xmlMeasurementTypes);
    }

    private void parseParameters(Map<String, String> parameters) {
        String value;
        this.setDefaultParameters();
        if (parameters != null && (value = parameters.get("generateStatistics")) != null) {
            this.generateStatistics = Boolean.parseBoolean(value);
        }
    }

    private void setDefaultParameters() {
        this.generateStatistics = false;
    }
}

