/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.summarizedData.dto;

import de.proveo.wwt.logic.web.common.dto.StateReportDTO;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class StateDurationsDTO
extends StateReportDTO {
    private Integer stateModelId;
    private HashMap<Integer, Long> stateDurations = new HashMap();
    private HashMap<Integer, Double> statePercentages = null;

    public StateDurationsDTO(Integer stateModelId, long beginTime) {
        super(0L, beginTime, 0L, 0L, 0L, beginTime, 0L);
        this.stateModelId = stateModelId;
    }

    public void setDuration(int statusId, long duration) {
        this.stateDurations.put(statusId, duration);
    }

    public HashMap<Integer, Double> getStatePercentages() {
        if (this.statePercentages == null) {
            this.statePercentages = new HashMap();
            for (Map.Entry<Integer, Long> e : this.stateDurations.entrySet()) {
                long duration = e.getValue();
                double percentage = (double)duration * 100.0 / (double)this.getTotalDuration();
                this.statePercentages.put(e.getKey(), percentage);
            }
        }
        return this.statePercentages;
    }

    public long getDuration(int statusId) {
        if (this.stateDurations.containsKey(statusId)) {
            return this.stateDurations.get(statusId);
        }
        return 0L;
    }

    public Set<Integer> getStatusIds() {
        return this.stateDurations.keySet();
    }

    public Integer getStateModelId() {
        return this.stateModelId;
    }

    public void setStateModelId(Integer stateModelId) {
        this.stateModelId = stateModelId;
    }

    public HashMap<Integer, Long> getStateDurations() {
        return this.stateDurations;
    }

    public long getTotalDuration() {
        long totalDuration = 0L;
        for (Map.Entry<Integer, Long> e : this.stateDurations.entrySet()) {
            totalDuration += e.getValue().longValue();
        }
        return totalDuration;
    }

    public StateDurationsDTO copy() {
        StateDurationsDTO copy = new StateDurationsDTO(this.stateModelId, this.beginTime);
        copy.attachables = this.attachables;
        return copy;
    }
}

