/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.data.processors.stateCounter.peak;

import de.proveo.wwt.logic.web.common.dataSelection.ReportSelectionDTO;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.data.processors.stateCounter.StateCountSnapshot;
import de.proveo.wwt.logic.web.data.processors.stateCounter.StateCountSnapshotReason;
import de.proveo.wwt.logic.web.data.processors.stateCounter.peak.PeakStatusEvaluatorBase;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.SortedSet;
import java.util.TreeSet;

public class StackedStatusPeakEvaluator
extends PeakStatusEvaluatorBase {
    private HashSet<Integer> masterStates;
    protected HashMap<Integer, Integer> snapshotMaxima;
    private boolean isFirstSnapshot;

    public StackedStatusPeakEvaluator(ReportSelectionDTO selectionDTO, int interval, String peakStates) {
        super(selectionDTO, interval);
        this.evaluatePeakStates(peakStates);
    }

    @Override
    public void preProcess() {
        super.preProcess();
        this.isFirstSnapshot = true;
        this.snapshotMaxima = new HashMap(this.intervalCount);
        for (int i = 0; i != this.intervalCount; ++i) {
            this.snapshotMaxima.put(i, 0);
        }
    }

    private void evaluatePeakStates(String peakStates) {
        String[] stateSectionStrings = peakStates.split(";");
        String[] stateStrings = stateSectionStrings[0].split(",");
        this.masterStates = new HashSet();
        for (int i = 0; i != stateStrings.length; ++i) {
            this.masterStates.add(Integer.parseInt(stateStrings[i]));
        }
    }

    @Override
    public void processSnapshot(Collection<StateCountSnapshot> snapshots, StateCountSnapshotReason reason) {
        int stateCount = 0;
        Integer intervalIndex = -1;
        for (StateCountSnapshot snapshot : snapshots) {
            intervalIndex = this.getIntervalIndex(snapshot.time);
            if (intervalIndex == -1 || intervalIndex >= this.intervalCount) {
                return;
            }
            if (!this.masterStates.contains(snapshot.stateId)) continue;
            stateCount += snapshot.count;
        }
        Integer maximum = this.snapshotMaxima.get(intervalIndex);
        if (stateCount > maximum || reason == StateCountSnapshotReason.INTERVAL_BOUNDARY && maximum == 0 || this.isFirstSnapshot) {
            for (StateCountSnapshot snapshot : snapshots) {
                StateCountSnapshot bufferedSnapshot = ((StateCountSnapshot[])this.snapshotMap.get(snapshot.stateId))[intervalIndex];
                bufferedSnapshot.count = snapshot.count;
                bufferedSnapshot.time = snapshot.time;
                bufferedSnapshot.unitDTOs = new TreeSet<UnitDTO>((SortedSet<UnitDTO>)snapshot.unitDTOs);
            }
            this.snapshotMaxima.put(intervalIndex, stateCount);
        }
        if (this.isFirstSnapshot) {
            this.isFirstSnapshot = false;
        }
    }
}

