/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.data.performanceCounter;

import de.proveo.wwt.logic.app.util.Stopwatch;
import de.proveo.wwt.logic.ejb.general.performanceCounter.PerformanceCounterDistributionResult;
import de.proveo.wwt.logic.ejb.general.tableMappings.readers.PerformanceCounterAnnotationReader;
import de.proveo.wwt.logic.web.data.fastlanereader.base.FastLaneReader;
import de.proveo.wwt.logic.web.data.performanceCounter.PerformanceCounterFastLaneBase;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GenericDistributionFastLane<E extends Enum<E>>
extends PerformanceCounterFastLaneBase<E> {
    private static final Log log = LogFactory.getLog(GenericDistributionFastLane.class);
    protected static final String DELAY_COLUMN = "delay";
    protected static final String EVENT_COUNT_COLUMN = "event_count";
    protected static final String DISTRIBUTION_SQL = "SELECT FLOOR(%s / %d) AS %s, CEIL(%s) AS %s, COUNT(*) AS %s FROM %s WHERE %s >= %d AND %s < %d GROUP BY %s, %s ORDER BY %s, %s";

    protected GenericDistributionFastLane(Class<E> typeClass) {
        super(typeClass);
    }

    public static <T extends Enum<T>> GenericDistributionFastLane<T> getInstance(Class<T> typeClass) {
        GenericDistributionFastLane instance = null;
        try {
            Class<?> pfcClass = PerformanceCounterAnnotationReader.getTypeClass(typeClass);
            Class[] parameters = new Class[]{Class.class};
            Constructor<?> constructor = pfcClass.getDeclaredConstructor(parameters);
            constructor.setAccessible(true);
            instance = (GenericDistributionFastLane)constructor.newInstance(typeClass);
        }
        catch (Exception e) {
            log.error((Object)"Runs into", (Throwable)e);
        }
        return instance;
    }

    public PerformanceCounterDistributionResult<E> getDistribution(long beginTime, long endTime, int loadFactor, Enum<E>[] columnIds) {
        long intervalMillis = GenericDistributionFastLane.intervalMillisFromLoadFactor(beginTime, endTime, loadFactor);
        return this.getDistribution(beginTime, endTime, intervalMillis, columnIds);
    }

    public PerformanceCounterDistributionResult<E> getDistribution(long beginTime, long endTime, long intervalMillis, Enum<E>[] columnIds) {
        if (!this.compatible()) {
            log.warn((Object)"Performance counter not available for currently used DBMS");
            return null;
        }
        if (beginTime > endTime) {
            log.error((Object)"getDistribution(): begin time must not be greater than end time");
            return null;
        }
        if (beginTime < 946681200000L) {
            log.error((Object)("getDistribution(): minimum value for begin time is " + String.valueOf(946681200000L)));
            return null;
        }
        if (columnIds == null || columnIds.length == 0) {
            columnIds = this.getAllTableMappings();
        }
        return this.executeDistribuionQuery(beginTime, endTime, intervalMillis, columnIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PerformanceCounterDistributionResult<E> executeDistribuionQuery(long beginTime, long endTime, long intervalMillis, Enum<E>[] columnIds) {
        PerformanceCounterDistributionResult result = null;
        String[] sql = this.buildDistributionSql(beginTime, endTime, intervalMillis, columnIds);
        Connection connection = null;
        Statement statement = null;
        Stopwatch stopwatch = new Stopwatch(FastLaneReader.class, "executeStatisticsQuery");
        stopwatch.start("Overall");
        try {
            connection = this.getConnection();
            HashMap dataMap = new HashMap();
            for (int i = 0; i != sql.length; ++i) {
                statement = this.createReadOnlyForwardOnlyStatement(connection);
                log.debug((Object)sql[i]);
                ResultSet resultSet = statement.executeQuery(sql[i]);
                log.debug((Object)"finished");
                int timestampColumnIdx = resultSet.findColumn("timestamp");
                int delayIdx = resultSet.findColumn(DELAY_COLUMN);
                int eventCountIdx = resultSet.findColumn(EVENT_COUNT_COLUMN);
                HashMap timestampMap = new HashMap();
                ArrayList<PerformanceCounterDistributionResult.DistributionEntry> distributionList = null;
                long currentDbTimestamp = 0L;
                long oldDbTimestamp = Long.MAX_VALUE;
                while (resultSet.next()) {
                    currentDbTimestamp = (long)resultSet.getInt(timestampColumnIdx) * intervalMillis;
                    if (currentDbTimestamp != oldDbTimestamp) {
                        if (distributionList != null) {
                            timestampMap.put(currentDbTimestamp, distributionList);
                        }
                        distributionList = new ArrayList<PerformanceCounterDistributionResult.DistributionEntry>();
                        oldDbTimestamp = currentDbTimestamp;
                        continue;
                    }
                    PerformanceCounterDistributionResult.DistributionEntry entry = new PerformanceCounterDistributionResult.DistributionEntry(resultSet.getLong(delayIdx), resultSet.getLong(eventCountIdx));
                    distributionList.add(entry);
                }
                if (distributionList != null && currentDbTimestamp != 0L) {
                    timestampMap.put(currentDbTimestamp, distributionList);
                }
                resultSet.close();
                statement.close();
                dataMap.put(columnIds[i], timestampMap);
                result = new PerformanceCounterDistributionResult(intervalMillis, dataMap);
            }
        }
        catch (SQLException e) {
            log.error((Object)"Runs into", (Throwable)e);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
        }
        stopwatch.stop("Overall", true);
        return result;
    }

    protected String[] buildDistributionSql(long beginTime, long endTime, long intervalMillis, Enum<E>[] columnIds) {
        String[] sql = new String[columnIds.length];
        for (int i = 0; i != columnIds.length; ++i) {
            Enum<E> currentColumn = columnIds[i];
            String tableName = PerformanceCounterAnnotationReader.getTable(currentColumn);
            String column = PerformanceCounterAnnotationReader.getColumn(currentColumn);
            String aggregationSql = PerformanceCounterAnnotationReader.getAggregationSql(currentColumn);
            StringBuilder sb = new StringBuilder("SELECT FLOOR(");
            sb.append(column);
            sb.append(" / ");
            sb.append(intervalMillis);
            sb.append(") AS ");
            sb.append("timestamp");
            sb.append(", CEIL(");
            sb.append(aggregationSql);
            sb.append(") AS ");
            sb.append(DELAY_COLUMN);
            sb.append(", COUNT(*) AS ");
            sb.append(EVENT_COUNT_COLUMN);
            sb.append(" FROM ");
            sb.append(tableName);
            sb.append(" WHERE ");
            sb.append(column);
            sb.append(" >= ");
            sb.append(beginTime);
            sb.append(" AND ");
            sb.append(column);
            sb.append(" < ");
            sb.append(endTime);
            sb.append(" GROUP BY ");
            sb.append("timestamp");
            sb.append(", ");
            sb.append(DELAY_COLUMN);
            sb.append(" HAVING ");
            sb.append(DELAY_COLUMN);
            sb.append(" > 0 ORDER BY ");
            sb.append("timestamp");
            sb.append(", ");
            sb.append(DELAY_COLUMN);
            sql[i] = sb.toString();
        }
        return sql;
    }
}

