/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.data.fastlanereader.report;

import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.SelectQuery;
import com.healthmarketscience.sqlbuilder.dbspec.Column;
import de.proveo.wwt.datamodel.statesum.StateSummary;
import de.proveo.wwt.logic.app.util.Stopwatch;
import de.proveo.wwt.logic.web.common.dataSelection.ReportSelectionDTO;
import de.proveo.wwt.logic.web.common.dto.DTOFactory;
import de.proveo.wwt.logic.web.common.dto.DTOListBase;
import de.proveo.wwt.logic.web.common.dto.DTOListFactory;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.data.enumerations.FastLaneReaderOrder;
import de.proveo.wwt.logic.web.data.fastlanereader.base.FastLaneReader;
import de.proveo.wwt.logic.web.data.fastlanereader.report.ReportFastLaneReader;
import de.proveo.wwt.logic.web.data.query.definitions.StateSummaryDefinitions;
import de.proveo.wwt.logic.web.historyData.dto.StateDTO;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;

public class StateSummaryFastLaneReader
extends ReportFastLaneReader<StateDTO, StateSummaryDefinitions> {
    protected Integer stateModelId;
    protected Integer periodType;

    public StateSummaryFastLaneReader() {
        super(new StateSummaryDefinitions());
    }

    public void getHistory(DTOListBase<StateDTO> list, ReportSelectionDTO selectionDTO, Integer stateModelId, int periodType) {
        this.init(stateModelId, periodType, list, selectionDTO, null);
        String sql = this.generateSql(false);
        this.getData(sql, false);
    }

    public Collection<StateSummary> getStateSummary(Long unitId, Integer stateModelId, long beginTime, long endTime, int periodType, boolean useGroupHistory) {
        ReportSelectionDTO selectionDTO = this.buildUnitReportSelectionDTO(unitId, beginTime, endTime, useGroupHistory, true);
        DTOListBase<StateDTO> list = DTOListFactory.buildDTOListBase(selectionDTO);
        this.init(stateModelId, periodType, list, selectionDTO, null);
        String sql = this.generateSql(false);
        return this.getStateSummary(sql);
    }

    public Collection<StateSummary> getStateSummary(ReportSelectionDTO selectionDTO, Integer stateModelId, int periodType) {
        DTOListBase<StateDTO> list = DTOListFactory.buildDTOListBase(selectionDTO);
        this.init(stateModelId, periodType, list, selectionDTO, null);
        String sql = this.generateSql(false);
        return this.getStateSummary(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<StateSummary> getStateSummary(String sql) {
        ArrayList<StateSummary> collSummaries = new ArrayList<StateSummary>();
        log.debug((Object)"getStateSummary called");
        Stopwatch stopwatch = new Stopwatch(FastLaneReader.class, "getStateSummary");
        stopwatch.start("Overall");
        Connection connection = null;
        Statement statement = null;
        try {
            stopwatch.start("Database access");
            connection = this.getConnection();
            statement = this.createReadOnlyForwardOnlyStatement(connection);
            log.debug((Object)("executed SQL: " + sql));
            ResultSet resultSet = statement.executeQuery(sql);
            stopwatch.stop("Database access", true);
            stopwatch.start("Build DTO");
            int idx_beginTime = resultSet.findColumn(StateSummaryDefinitions.col_Summary_BeginTime.getName());
            int idx_stateId = resultSet.findColumn(StateSummaryDefinitions.col_Summary_StateId.getName());
            int idx_stateModelId = resultSet.findColumn(StateSummaryDefinitions.col_Summary_StateModelId.getName());
            int idx_duration = resultSet.findColumn(StateSummaryDefinitions.col_Summary_Duration.getName());
            int idx_periodType = resultSet.findColumn(StateSummaryDefinitions.col_Summary_PeriodType.getName());
            int idx_unitId = resultSet.findColumn(StateSummaryDefinitions.col_Summary_UnitId.getName());
            while (resultSet.next()) {
                StateSummary stateSummary = new StateSummary();
                stateSummary.getPk().setBeginTime(resultSet.getLong(idx_beginTime));
                stateSummary.getPk().setStateId(resultSet.getInt(idx_stateId));
                stateSummary.getPk().setStateModelId(resultSet.getInt(idx_stateModelId));
                stateSummary.setDuration(resultSet.getLong(idx_duration));
                stateSummary.getPk().setPeriodType(resultSet.getInt(idx_periodType));
                stateSummary.getPk().setUnitId(resultSet.getLong(idx_unitId));
                collSummaries.add(stateSummary);
            }
            stopwatch.stop("Build DTO", true, collSummaries.size());
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
        }
        stopwatch.stop("Overall", true);
        return collSummaries;
    }

    @Override
    protected void prepareHistoryColumns() {
        this.historyQuery = new SelectQuery(true);
        this.historyQuery.addColumns(new Column[]{StateSummaryDefinitions.col_Summary_UnitId, StateSummaryDefinitions.col_Summary_StateId, StateSummaryDefinitions.col_Summary_StateModelId, StateSummaryDefinitions.col_Summary_BeginTime, StateSummaryDefinitions.col_Summary_PeriodType, StateSummaryDefinitions.col_Summary_Duration});
    }

    @Override
    protected void addCustomConditions() {
        if (this.stateModelId != null) {
            this.historyQuery.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.EQUAL_TO, (Object)StateSummaryDefinitions.col_Summary_StateModelId, (Object)this.stateModelId));
        }
        this.historyQuery.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.EQUAL_TO, (Object)StateSummaryDefinitions.col_Summary_PeriodType, (Object)this.periodType));
    }

    @Override
    protected void addExtendedDataColumns() {
    }

    @Override
    protected void addTimeConditions() {
        if (this.selectionDTO.getInterval() != null) {
            this.historyQuery.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.LESS_THAN, (Object)StateSummaryDefinitions.col_Summary_BeginTime, (Object)this.selectionDTO.getEndTime()));
            this.historyQuery.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.GREATER_THAN_OR_EQUAL_TO, (Object)StateSummaryDefinitions.col_Summary_BeginTime, (Object)this.selectionDTO.getBeginTime()));
        }
    }

    @Override
    protected int getCache(ResultSet resultSet) throws SQLException {
        return 0;
    }

    @Override
    protected StateSummaryDefinitions getDefinitions() {
        return (StateSummaryDefinitions)this.definitions;
    }

    @Override
    protected int getHistory(ResultSet resultSet) throws SQLException {
        int dataSize = 0;
        long id = 0L;
        String remark = null;
        int idx_beginTime = resultSet.findColumn(StateSummaryDefinitions.col_Summary_BeginTime.getName());
        int idx_stateId = resultSet.findColumn(StateSummaryDefinitions.col_Summary_StateId.getName());
        int idx_stateModelId = resultSet.findColumn(StateSummaryDefinitions.col_Summary_StateModelId.getName());
        int idx_duration = resultSet.findColumn(StateSummaryDefinitions.col_Summary_Duration.getName());
        int idx_periodType = resultSet.findColumn(StateSummaryDefinitions.col_Summary_PeriodType.getName());
        int idx_unitId = resultSet.findColumn(StateSummaryDefinitions.col_Summary_UnitId.getName());
        while (resultSet.next()) {
            long unitId = resultSet.getLong(idx_unitId);
            int stateId = resultSet.getInt(idx_stateId);
            int stateModelId = resultSet.getInt(idx_stateModelId);
            int periodType = resultSet.getInt(idx_periodType);
            long beginTime = resultSet.getLong(idx_beginTime);
            long duration = resultSet.getLong(idx_duration);
            long beginReceiveTime = 0L;
            long endReceiveTime = 0L;
            long endTime = beginTime + duration;
            long actualBeginTime = beginTime;
            long actualEndTime = endTime;
            UnitDTO unitDTO = this.getUnitDTOMap().get(unitId);
            StateDTO dto = DTOFactory.buildStateDTO(id, beginTime, endTime, beginReceiveTime, endReceiveTime, actualBeginTime, actualEndTime, stateId, stateModelId, 0, remark, null, null, false, false, unitDTO);
            this.dataList.add(dto);
            ++dataSize;
        }
        return dataSize;
    }

    protected void init(Integer stateModelId, Integer periodType, DTOListBase<StateDTO> dataList, ReportSelectionDTO selectionDTO, FastLaneReaderOrder order) {
        super.init(dataList, selectionDTO, order);
        this.periodType = periodType;
        this.stateModelId = stateModelId;
    }

    @Override
    protected String generateSql(boolean cache) {
        this.initQuerys();
        this.historyQuery.addOrderings(new Column[]{StateSummaryDefinitions.col_Summary_BeginTime, StateSummaryDefinitions.col_Summary_UnitId});
        return ((SelectQuery)this.historyQuery.validate()).toString();
    }
}

