/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.data.fastlanereader.report;

import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.ComboCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.NumberValueObject;
import com.healthmarketscience.sqlbuilder.SelectQuery;
import com.healthmarketscience.sqlbuilder.dbspec.Column;
import com.healthmarketscience.sqlbuilder.dbspec.Table;
import de.proveo.wwt.logic.web.common.dataSelection.filter.ITimeFilter;
import de.proveo.wwt.logic.web.common.dto.StateReportDTO;
import de.proveo.wwt.logic.web.data.fastlanereader.report.ExtendedReportFastLaneReader;
import de.proveo.wwt.logic.web.data.query.interfaces.IStateReportTableDefinitions;
import java.util.ArrayList;
import org.joda.time.Interval;

public abstract class StateReportFastLaneReader<T extends StateReportDTO, D extends IStateReportTableDefinitions>
extends ExtendedReportFastLaneReader<T, D> {
    protected StateReportFastLaneReader(D definitions) {
        super(definitions);
    }

    @Override
    protected D getDefinitions() {
        return (D)((IStateReportTableDefinitions)this.definitions);
    }

    @Override
    protected void addTimeConditions() {
        if (this.selectionDTO.getInterval() != null) {
            if (this.getDefinitions().getHelperDayStampColumn() != null) {
                this.historyQuery.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.LESS_THAN_OR_EQUAL_TO, (Object)this.getDefinitions().getHelperDayStampColumn(), (Object)(this.selectionDTO.getEndTime() / 86400000L)));
                this.historyQuery.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.GREATER_THAN_OR_EQUAL_TO, (Object)this.getDefinitions().getHelperDayStampColumn(), (Object)(this.selectionDTO.getBeginTime() / 86400000L)));
            }
            this.historyQuery.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.LESS_THAN, (Object)this.getDefinitions().getHistoryBeginTimeColumn(), (Object)this.selectionDTO.getEndTime()));
            this.historyQuery.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.GREATER_THAN, (Object)this.getDefinitions().getHistoryEndTimeColumn(), (Object)this.selectionDTO.getBeginTime()));
            this.cacheQuery.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.LESS_THAN, (Object)this.getDefinitions().getCacheBeginTimeColumn(), (Object)this.selectionDTO.getEndTime()));
            for (ITimeFilter filter : this.selectionDTO.getTimeFilters()) {
                Interval[] intervals;
                ComboCondition comboHistory = new ComboCondition(ComboCondition.Op.OR);
                ComboCondition comboCache = new ComboCondition(ComboCondition.Op.OR);
                for (Interval interval : intervals = filter.getIntervals(this.selectionDTO.getBeginTime(), this.selectionDTO.getEndTime())) {
                    ComboCondition timeConditionHistory = new ComboCondition(ComboCondition.Op.AND);
                    ComboCondition timeConditionCache = new ComboCondition(ComboCondition.Op.AND);
                    if (this.getDefinitions().getHelperDayStampColumn() != null) {
                        timeConditionHistory.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.LESS_THAN_OR_EQUAL_TO, (Object)this.getDefinitions().getHelperDayStampColumn(), (Object)(interval.getEndMillis() / 86400000L)));
                        timeConditionHistory.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.GREATER_THAN_OR_EQUAL_TO, (Object)this.getDefinitions().getHelperDayStampColumn(), (Object)(interval.getStartMillis() / 86400000L)));
                    }
                    timeConditionHistory.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.LESS_THAN, (Object)this.getDefinitions().getHistoryBeginTimeColumn(), (Object)interval.getEndMillis()));
                    timeConditionHistory.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.GREATER_THAN, (Object)this.getDefinitions().getHistoryEndTimeColumn(), (Object)interval.getStartMillis()));
                    timeConditionCache.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.LESS_THAN, (Object)this.getDefinitions().getCacheBeginTimeColumn(), (Object)interval.getEndMillis()));
                    comboHistory.addCondition((Condition)timeConditionHistory);
                    comboCache.addCondition((Condition)timeConditionCache);
                }
                this.historyQuery.addCondition((Condition)comboHistory);
                this.cacheQuery.addCondition((Condition)comboCache);
            }
        }
    }

    @Override
    protected void prepareHistoryColumns() {
        super.prepareHistoryColumns();
        this.historyQuery.addAliasedColumn((Object)StateReportFastLaneReader.getMaxSql(this.selectionDTO.getBeginTime(), this.getDefinitions().getHistoryBeginTimeColumn()), "bt");
        this.historyQuery.addAliasedColumn((Object)StateReportFastLaneReader.getMinSql(this.selectionDTO.getEndTime(), this.getDefinitions().getHistoryEndTimeColumn()), "et");
        this.historyQuery.addColumns(new Column[]{this.getDefinitions().getHistoryBeginTimeColumn(), this.getDefinitions().getHistoryEndTimeColumn()});
        this.historyQuery.addColumns(new Column[]{this.getDefinitions().getHistoryBeginReceiveTimeColumn(), this.getDefinitions().getHistoryEndReceiveTimeColumn()});
        if (this.getDefinitions().getHelperTable() != null && this.getDefinitions().getHelperTable() != this.getDefinitions().getHistoryTable()) {
            this.historyQuery.addJoin(SelectQuery.JoinType.INNER, (Table)this.getDefinitions().getHelperTable(), (Table)this.getDefinitions().getHistoryTable(), (Column)this.getDefinitions().getHelperHistoryIdColumn(), (Column)this.getDefinitions().getHistoryIdColumn());
        }
        this.historyQuery.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.GREATER_THAN, (Object)this.getDefinitions().getHistoryEndTimeColumn(), (Object)0));
    }

    @Override
    protected void prepareCacheColumns() {
        super.prepareCacheColumns();
        this.cacheQuery.addAliasedColumn(this.selectionDTO.getInterval() != null ? StateReportFastLaneReader.getMaxSql(this.selectionDTO.getBeginTime(), this.getDefinitions().getCacheBeginTimeColumn()) : this.getDefinitions().getCacheBeginTimeColumn(), "bt");
        this.cacheQuery.addAliasedColumn((Object)this.selectionDTO.getEndTime(), "et");
        this.cacheQuery.addCustomColumns(new Object[]{this.getDefinitions().getCacheBeginTimeColumn(), new NumberValueObject((Number)-1)});
        this.cacheQuery.addCustomColumns(new Object[]{this.getDefinitions().getCacheBeginReceiveTimeColumn(), new NumberValueObject((Number)-1)});
    }

    @Override
    protected void getData(String sql, boolean cache) {
        super.getData(sql, cache);
        this.correctData();
    }

    protected void correctData() {
        for (ITimeFilter filter : this.selectionDTO.getTimeFilters()) {
            this.correctData(filter);
        }
    }

    protected void correctData(ITimeFilter filter) {
        ArrayList copy = new ArrayList();
        copy.addAll(this.dataList);
        this.dataList.clear();
        for (StateReportDTO dto : copy) {
            Interval[] intervals;
            for (Interval interval : intervals = filter.getIntervals(dto.getBeginTime(), dto.getEndTime())) {
                Object newDTO = dto.copy();
                ((StateReportDTO)newDTO).correctTimes(interval.getStartMillis(), interval.getEndMillis());
                this.dataList.add(newDTO);
            }
        }
    }
}

