/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.data.fastlanereader.report;

import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.SelectQuery;
import com.healthmarketscience.sqlbuilder.dbspec.Column;
import de.proveo.wwt.datamodel.measurement.MeasurementDefinition;
import de.proveo.wwt.datamodel.measurement.MeasurementIntervalDefn;
import de.proveo.wwt.datamodel.measurement.MeasurementType;
import de.proveo.wwt.datamodel.measurement.MeasurementUnit;
import de.proveo.wwt.logic.web.common.dataSelection.ReportSelectionDTO;
import de.proveo.wwt.logic.web.common.dto.DTOFactory;
import de.proveo.wwt.logic.web.common.dto.DTOListBase;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.data.enumerations.ExtendedDTOData;
import de.proveo.wwt.logic.web.data.enumerations.FastLaneReaderOrder;
import de.proveo.wwt.logic.web.data.fastlanereader.report.MeasurementBaseFastlaneReader;
import de.proveo.wwt.logic.web.data.fastlanereader.report.StateReportFastLaneReader;
import de.proveo.wwt.logic.web.data.query.definitions.MeasurementIntervalDefinitions;
import de.proveo.wwt.logic.web.historyData.dto.MeasurementIntervalDTO;
import java.sql.ResultSet;
import java.sql.SQLException;

public class MeasurementIntervalFastLaneReader
extends StateReportFastLaneReader<MeasurementIntervalDTO, MeasurementIntervalDefinitions> {
    protected MeasurementBaseFastlaneReader baseReader = new MeasurementBaseFastlaneReader();
    protected Integer measurementFilterId;

    public MeasurementIntervalFastLaneReader() {
        super(new MeasurementIntervalDefinitions());
    }

    public void getHistory(DTOListBase<MeasurementIntervalDTO> list, Integer measurementFilterId, ReportSelectionDTO selectionDTO, ExtendedDTOData ... extendedData) {
        this.init(measurementFilterId, list, selectionDTO, FastLaneReaderOrder.ByUnitId, extendedData);
        String sql = this.generateSql(false);
        this.getData(sql, false);
    }

    @Override
    protected void addCustomConditions() {
        if (this.measurementFilterId != null) {
            MeasurementIntervalDefinitions cfr_ignored_0 = (MeasurementIntervalDefinitions)this.getDefinitions();
            this.historyQuery.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.EQUAL_TO, (Object)MeasurementIntervalDefinitions.col_History_MeasurementIntervalDefinitionId, (Object)this.measurementFilterId));
        }
    }

    @Override
    protected int getCache(ResultSet resultSet) throws SQLException {
        return 0;
    }

    @Override
    protected int getHistory(ResultSet resultSet) throws SQLException {
        int dataSize = 0;
        int idx_id = resultSet.findColumn(((MeasurementIntervalDefinitions)this.getDefinitions()).getHelperHistoryIdColumn().getName());
        int idx_unitId = resultSet.findColumn(((MeasurementIntervalDefinitions)this.getDefinitions()).getHelperUnitIdColumn().getName());
        int idx_beginTime = resultSet.findColumn("bt");
        int idx_endTime = resultSet.findColumn("et");
        int idx_beginReceiveTime = resultSet.findColumn(((MeasurementIntervalDefinitions)this.getDefinitions()).getHistoryBeginReceiveTimeColumn().getName());
        int idx_endReceiveTime = resultSet.findColumn(((MeasurementIntervalDefinitions)this.getDefinitions()).getHistoryEndReceiveTimeColumn().getName());
        int idx_actualBeginTime = resultSet.findColumn(((MeasurementIntervalDefinitions)this.getDefinitions()).getHistoryBeginTimeColumn().getName());
        int idx_actualEndTime = resultSet.findColumn(((MeasurementIntervalDefinitions)this.getDefinitions()).getHistoryEndTimeColumn().getName());
        MeasurementIntervalDefinitions cfr_ignored_0 = (MeasurementIntervalDefinitions)this.getDefinitions();
        int idx_mid = resultSet.findColumn(MeasurementIntervalDefinitions.col_History_MeasurementIntervalDefinitionId.getName());
        MeasurementIntervalDefinitions cfr_ignored_1 = (MeasurementIntervalDefinitions)this.getDefinitions();
        int idx_mFrom = resultSet.findColumn(MeasurementIntervalDefinitions.col_History_ValueFrom.getName());
        MeasurementIntervalDefinitions cfr_ignored_2 = (MeasurementIntervalDefinitions)this.getDefinitions();
        int idx_mTo = resultSet.findColumn(MeasurementIntervalDefinitions.col_History_ValueTo.getName());
        while (resultSet.next()) {
            long id = resultSet.getLong(idx_id);
            long unitId = resultSet.getLong(idx_unitId);
            int measurementIntervalDefnId = resultSet.getInt(idx_mid);
            float measurementFrom = resultSet.getFloat(idx_mFrom);
            float measurementTo = resultSet.getFloat(idx_mTo);
            long beginReceiveTime = resultSet.getLong(idx_beginReceiveTime);
            long endReceiveTime = resultSet.getLong(idx_endReceiveTime);
            long beginTime = resultSet.getLong(idx_beginTime);
            long endTime = resultSet.getLong(idx_endTime);
            long actualBeginTime = resultSet.getLong(idx_actualBeginTime);
            long actualEndTime = resultSet.getLong(idx_actualEndTime);
            UnitDTO unitDTO = this.getUnitDTOMap().get(unitId);
            measurementIntervalDefnId = resultSet.getInt(idx_mid);
            MeasurementIntervalDefn mid = this.baseReader.getMeasurementIntervalDefinitionsMap().get(measurementIntervalDefnId);
            MeasurementDefinition md = mid == null ? null : this.baseReader.getMeasurementDefinitionsMap().get(mid.getMeasurementDefnId());
            MeasurementUnit mu = md == null ? null : this.baseReader.getMeasurementUnitsMap().get(md.getMeasurementUnitId());
            MeasurementType mt = mu == null ? null : this.baseReader.getMeasurementTypesMap().get(mu.getMeasurementTypeId());
            MeasurementIntervalDTO dto = DTOFactory.buildMeasurementIntervalDTO(id, beginTime, endTime, measurementFrom, measurementTo, mid, md, mt, mu, unitDTO);
            this.addExtendedData(false, resultSet, dto, new ExtendedDTOData[0]);
            this.dataList.add(dto);
            ++dataSize;
        }
        return dataSize;
    }

    @Override
    protected void prepareHistoryColumns() {
        super.prepareHistoryColumns();
        Column[] columnArray = new Column[3];
        MeasurementIntervalDefinitions cfr_ignored_0 = (MeasurementIntervalDefinitions)this.getDefinitions();
        columnArray[0] = MeasurementIntervalDefinitions.col_History_MeasurementIntervalDefinitionId;
        MeasurementIntervalDefinitions cfr_ignored_1 = (MeasurementIntervalDefinitions)this.getDefinitions();
        columnArray[1] = MeasurementIntervalDefinitions.col_History_ValueFrom;
        MeasurementIntervalDefinitions cfr_ignored_2 = (MeasurementIntervalDefinitions)this.getDefinitions();
        columnArray[2] = MeasurementIntervalDefinitions.col_History_ValueTo;
        this.historyQuery.addColumns(columnArray);
    }

    protected void init(Integer measurementFilterId, DTOListBase<MeasurementIntervalDTO> dataList, ReportSelectionDTO selectionDTO, FastLaneReaderOrder order, ExtendedDTOData ... extendedData) {
        super.init(dataList, selectionDTO, order, extendedData);
        this.measurementFilterId = measurementFilterId;
    }

    @Override
    protected String generateSql(boolean cache) {
        this.initQuerys();
        this.historyQuery.addOrderings(new Column[]{MeasurementIntervalDefinitions.col_History_UnitId, MeasurementIntervalDefinitions.col_History_BeginTime});
        return ((SelectQuery)this.historyQuery.validate()).toString();
    }
}

