/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.data.fastlanereader.replay;

import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.ComboCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.InCondition;
import com.healthmarketscience.sqlbuilder.OrderObject;
import com.healthmarketscience.sqlbuilder.SelectQuery;
import com.healthmarketscience.sqlbuilder.dbspec.Column;
import de.proveo.wwt.logic.app.util.Stopwatch;
import de.proveo.wwt.logic.web.data.fastlanereader.base.ReplayFastLaneBase;
import de.proveo.wwt.logic.web.data.query.definitions.MeasurementDefinitions;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MeasurementReplayFastLaneReader
extends ReplayFastLaneBase {
    private static final Log log = LogFactory.getLog(MeasurementReplayFastLaneReader.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeMap<Long, HashMap> getReplayDataHistory(HashSet<Long> unitPermissions, TreeMap<Long, HashMap> completeReplayDataMap, long since, long until) {
        String method = "getReplayDataHistory: ";
        log.debug((Object)"getReplayDataHistory: called");
        Stopwatch stopwatch = new Stopwatch(MeasurementReplayFastLaneReader.class, "getReplayDataHistory: ");
        stopwatch.start("Overall");
        TreeMap<Long, HashMap> retMap = new TreeMap<Long, HashMap>();
        if (unitPermissions == null || unitPermissions.isEmpty()) {
            log.warn((Object)"getReplayDataHistory: No permissions, break.");
            stopwatch.stop("Overall", true);
            return retMap;
        }
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getConnection();
            if (connection != null) {
                String sql = this.getSqlForReplayHistory(since, until);
                stopwatch.start("Database access");
                statement = this.createReadOnlyForwardOnlyStatement(connection);
                resultSet = statement.executeQuery(sql);
                int dataSize = 0;
                stopwatch.stop("Database access", true);
                log.debug((Object)"getReplayDataHistory: building Maps...");
                stopwatch.start("Build DTO");
                while (resultSet.next()) {
                    long unitId = resultSet.getLong("UNIT_ID");
                    if (!unitPermissions.contains(unitId)) continue;
                    long createTime = resultSet.getLong("CREATE_TIME");
                    while (completeReplayDataMap.containsKey(createTime)) {
                        ++createTime;
                    }
                    HashMap valueMap = this.generateValueMapForReplay(unitId, createTime, resultSet.getInt("MEASUREMENT_DEFN_ID"), resultSet.getFloat("VALUE"));
                    if (valueMap == null) continue;
                    valueMap.put("ServerTime", createTime);
                    completeReplayDataMap.put(createTime, valueMap);
                    retMap.put(createTime, valueMap);
                    ++dataSize;
                }
                stopwatch.stop("Build DTO", true, dataSize);
            }
        }
        catch (SQLException e) {
            log.error((Object)"getReplayDataHistory: runs into", (Throwable)e);
        }
        finally {
            this.closeQuietly(statement, resultSet, connection);
            statement = null;
            resultSet = null;
            connection = null;
        }
        stopwatch.stop("Overall", true);
        return retMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<Long, HashMap<Integer, HashMap>> getReplayDataInitial(HashSet<Long> unitPermissions, long since) {
        String method = "getReplayDataInitial(): ";
        log.debug((Object)"getReplayDataInitial(): called");
        Stopwatch stopwatch = new Stopwatch(MeasurementReplayFastLaneReader.class, "getReplayDataInitial(): ");
        stopwatch.start("Overall");
        HashMap<Long, HashMap<Integer, HashMap>> retMap = new HashMap<Long, HashMap<Integer, HashMap>>();
        if (unitPermissions == null || unitPermissions.isEmpty()) {
            log.warn((Object)"getReplayDataInitial(): No permissions, break.");
            stopwatch.stop("Overall", true);
            return retMap;
        }
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getConnection();
            if (connection != null) {
                String sql = this.getSqlForReplayInitial(since, unitPermissions);
                stopwatch.start("Database access");
                statement = this.createReadOnlyForwardOnlyStatement(connection);
                resultSet = statement.executeQuery(sql);
                int dataSize = 0;
                stopwatch.stop("Database access", true);
                log.debug((Object)"getReplayDataInitial(): building Maps...");
                stopwatch.start("Build DTO");
                while (resultSet.next()) {
                    HashMap<Object, Object> measurementMap;
                    float value;
                    int measurementDefnId;
                    long createTime;
                    long unitId = resultSet.getLong("UNIT_ID");
                    HashMap valueMap = this.generateValueMapForReplay(unitId, createTime = resultSet.getLong("CREATE_TIME"), measurementDefnId = resultSet.getInt("MEASUREMENT_DEFN_ID"), value = resultSet.getFloat("VALUE"));
                    if (valueMap == null) continue;
                    valueMap.put("ServerTime", createTime);
                    if (!retMap.containsKey(unitId)) {
                        measurementMap = new HashMap<Integer, HashMap>();
                        measurementMap.put(measurementDefnId, valueMap);
                        retMap.put(unitId, measurementMap);
                    } else {
                        HashMap tempMap;
                        long storedCreateTime;
                        measurementMap = retMap.get(unitId);
                        if (measurementMap.containsKey(measurementDefnId) && (storedCreateTime = ((Long)(tempMap = (HashMap)measurementMap.get(measurementDefnId)).get("ServerTime")).longValue()) > createTime) continue;
                        measurementMap.put(measurementDefnId, valueMap);
                        retMap.put(unitId, measurementMap);
                    }
                    ++dataSize;
                }
                stopwatch.stop("Build DTO", true, dataSize);
            }
        }
        catch (SQLException e) {
            log.error((Object)"getReplayDataInitial(): runs into", (Throwable)e);
        }
        finally {
            this.closeQuietly(statement, resultSet, connection);
            statement = null;
            resultSet = null;
            connection = null;
        }
        stopwatch.stop("Overall", true);
        return retMap;
    }

    private HashMap generateValueMapForReplay(long unitId, long createTime, int measurementDefnId, float value) throws SQLException {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        valueMap.put("EventType", "MeasurementEvent");
        valueMap.put("UnitId", unitId);
        valueMap.put("MeasurementDefnID", measurementDefnId);
        HashMap<String, Number> measurementMap = new HashMap<String, Number>();
        measurementMap.put("MeasurementValue", Float.valueOf(value));
        measurementMap.put("MeasurementBegin", createTime);
        valueMap.put("Measurement_" + measurementDefnId, measurementMap);
        return valueMap;
    }

    private String getSqlForReplayHistory(long since, long until) {
        SelectQuery query = new SelectQuery(true);
        query.addColumns(new Column[]{MeasurementDefinitions.col_History_UnitId, MeasurementDefinitions.col_History_MeasurementDefinitionId, MeasurementDefinitions.col_History_Value, MeasurementDefinitions.col_History_CreateTime});
        ComboCondition whereCondition = new ComboCondition(ComboCondition.Op.AND);
        whereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.GREATER_THAN, (Object)MeasurementDefinitions.col_History_CreateTime, (Object)since));
        whereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.LESS_THAN_OR_EQUAL_TO, (Object)MeasurementDefinitions.col_History_CreateTime, (Object)until));
        query.addCondition((Condition)whereCondition);
        query.addOrdering((Column)MeasurementDefinitions.col_History_CreateTime, OrderObject.Dir.ASCENDING);
        String sql = ((SelectQuery)query.validate()).toString();
        return sql;
    }

    private String getSqlForReplayInitial(long since, HashSet<Long> unitPermissions) {
        SelectQuery query = new SelectQuery();
        query.addColumns(new Column[]{MeasurementDefinitions.col_History_UnitId, MeasurementDefinitions.col_History_MeasurementDefinitionId, MeasurementDefinitions.col_History_Value, MeasurementDefinitions.col_History_CreateTime});
        ComboCondition whereCondition = new ComboCondition(ComboCondition.Op.AND);
        whereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.LESS_THAN_OR_EQUAL_TO, (Object)MeasurementDefinitions.col_History_CreateTime, (Object)since));
        whereCondition.addCondition((Condition)new InCondition((Object)MeasurementDefinitions.col_History_UnitId, unitPermissions));
        query.addCondition((Condition)whereCondition);
        String sql = ((SelectQuery)query.validate()).toString();
        return sql;
    }
}

