/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.data.fastlanereader.replay;

import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.ComboCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.CustomSql;
import com.healthmarketscience.sqlbuilder.OrderObject;
import com.healthmarketscience.sqlbuilder.SelectQuery;
import com.healthmarketscience.sqlbuilder.SqlObject;
import de.proveo.wwt.logic.app.util.Stopwatch;
import de.proveo.wwt.logic.web.data.fastlanereader.base.ReplayFastLaneBase;
import de.proveo.wwt.logic.web.data.query.definitions.FISDefinitions;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FisReplayFastLaneReader
extends ReplayFastLaneBase {
    private static final Log log = LogFactory.getLog(FisReplayFastLaneReader.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeMap<Long, HashMap> getReplayData(TreeMap<Long, HashMap> completeReplayDataMap, long since, long until) {
        String method = "getReplayData()";
        log.debug((Object)"getReplayData() called");
        Stopwatch stopwatch = new Stopwatch(FisReplayFastLaneReader.class, "getReplayData()");
        stopwatch.start("Overall");
        TreeMap<Long, HashMap> retMap = new TreeMap<Long, HashMap>();
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getConnection();
            if (connection != null) {
                String sql = this.generateStandStateSqlForReplay(since, until);
                log.debug((Object)("getReplayData(): Execute SQL: " + sql));
                stopwatch.start("Database access");
                statement = this.createReadOnlyForwardOnlyStatement(connection);
                resultSet = statement.executeQuery(sql);
                int dataSize = 0;
                stopwatch.stop("Database access", true);
                log.debug((Object)"getReplayData(): building Maps...");
                stopwatch.start("Build DTO");
                while (resultSet.next()) {
                    long beginTime = resultSet.getLong("BEGIN_TIME");
                    while (completeReplayDataMap.containsKey(beginTime)) {
                        ++beginTime;
                    }
                    HashMap valueMap = this.generateStandStateValueMapForReplay(beginTime, resultSet);
                    if (valueMap == null) continue;
                    valueMap.put("ServerTime", beginTime);
                    completeReplayDataMap.put(beginTime, valueMap);
                    retMap.put(beginTime, valueMap);
                    ++dataSize;
                }
                stopwatch.stop("Build DTO", true, dataSize);
            }
        }
        catch (SQLException e) {
            log.error((Object)"getReplayData(): runs into", (Throwable)e);
        }
        finally {
            this.closeQuietly(statement, resultSet, connection);
            statement = null;
            resultSet = null;
            connection = null;
        }
        stopwatch.stop("Overall", true);
        return retMap;
    }

    private HashMap generateStandStateValueMapForReplay(long beginTime, ResultSet resultSet) throws SQLException {
        String standName = resultSet.getString("STAND");
        String standId = "Stand_" + standName;
        long stateModelId = resultSet.getLong("STATE_MODEL_ID");
        long stateId = resultSet.getLong("STATE_ID");
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        valueMap.put("fstd", standId);
        HashMap<String, Object> stateMap = new HashMap<String, Object>();
        stateMap.put("stateId", stateId);
        HashMap<String, Object> inboundFlightMap = this.generateFlightMapForReplay(true, resultSet);
        HashMap<String, Object> outboundFlightMap = this.generateFlightMapForReplay(false, resultSet);
        stateMap.put("inbound", inboundFlightMap);
        stateMap.put("outbound", outboundFlightMap);
        String aircraftType = "";
        String registration = "";
        if (inboundFlightMap != null && !inboundFlightMap.isEmpty()) {
            aircraftType = inboundFlightMap.get("AircraftType").toString();
            registration = inboundFlightMap.get("reg").toString();
            if (outboundFlightMap != null && !outboundFlightMap.isEmpty()) {
                String tmpAircraftType = outboundFlightMap.get("AircraftType").toString();
                if (aircraftType.trim().length() == 0) {
                    aircraftType = tmpAircraftType;
                } else if (tmpAircraftType.trim().length() != 0 && !tmpAircraftType.equals(aircraftType)) {
                    log.error((Object)("Different aircraft type in inbound and outbound flight! Inbound = '" + aircraftType + "' Outbound = '" + tmpAircraftType + "'. Assuming that inbound is correct ..."));
                }
                String tmpRegistration = outboundFlightMap.get("reg").toString();
                if (registration.trim().length() == 0) {
                    registration = tmpRegistration;
                } else if (tmpRegistration.trim().length() != 0 && !tmpRegistration.equals(registration)) {
                    log.error((Object)("Different registration in inbound and outbound flight! Inbound = '" + registration + "' Outbound = '" + tmpRegistration + "'. Assuming that inbound is correct ..."));
                }
            }
        } else if (outboundFlightMap != null && !outboundFlightMap.isEmpty()) {
            aircraftType = outboundFlightMap.get("AircraftType").toString();
            registration = outboundFlightMap.get("reg").toString();
        }
        stateMap.put("AircraftType", aircraftType);
        stateMap.put("reg", registration);
        valueMap.put("StateModel_" + stateModelId, stateMap);
        valueMap.put("ServerTime", beginTime);
        return valueMap;
    }

    private HashMap<String, Object> generateFlightMapForReplay(boolean inbound, ResultSet resultSet) throws SQLException {
        String registration;
        String aircraftType;
        String movementType;
        String flightType;
        String prefix = "outb_";
        if (inbound) {
            prefix = "inb_";
        }
        long bestTime = resultSet.getLong(prefix + "bt");
        long estimatedTime = resultSet.getLong(prefix + "et");
        long scheduledTime = resultSet.getLong(prefix + "st");
        long onOffBlock = resultSet.getLong(prefix + "ot");
        String flightNumber = resultSet.getString(prefix + "fln");
        if (flightNumber == null) {
            flightNumber = "";
        }
        if ((flightType = resultSet.getString(prefix + "fl_nature")) == null) {
            flightType = "";
        }
        if ((movementType = resultSet.getString(prefix + "mov_type")) == null) {
            movementType = "";
        }
        if ((aircraftType = resultSet.getString(prefix + "ac_type")) == null) {
            aircraftType = "";
        }
        if ((registration = resultSet.getString(prefix + "reg")) == null) {
            registration = "";
        }
        HashMap<String, Object> flightMap = new HashMap<String, Object>();
        flightMap.put("flightNo", flightNumber);
        flightMap.put("flightType", flightType);
        flightMap.put("movementType", movementType);
        flightMap.put("estimatedTime", estimatedTime);
        flightMap.put("scheduledTime", scheduledTime);
        flightMap.put("oBlock", onOffBlock);
        if (inbound) {
            String origin = resultSet.getString(prefix + "orig");
            if (origin == null) {
                origin = "";
            }
            flightMap.put("origin", origin);
            flightMap.put("starttime", bestTime);
        } else {
            String destination = resultSet.getString(prefix + "dest");
            if (destination == null) {
                destination = "";
            }
            flightMap.put("destination", destination);
            flightMap.put("endtime", bestTime);
        }
        flightMap.put("AircraftType", aircraftType);
        flightMap.put("reg", registration);
        return flightMap;
    }

    private String generateStandStateSqlForReplay(long since, long until) {
        SelectQuery query = new SelectQuery(true);
        query.addCustomColumns(new Object[]{new CustomSql((Object)"state.inb_flight_id"), new CustomSql((Object)"state.outb_flight_id"), new CustomSql((Object)"state.stand"), new CustomSql((Object)"state.state_model_id"), new CustomSql((Object)"state.state_id"), new CustomSql((Object)"state.begin_time"), new CustomSql((Object)("inb." + FISDefinitions.col_FISFlight_Bt.getColumnNameSQL() + " AS inb_" + FISDefinitions.col_FISFlight_Bt.getColumnNameSQL())), new CustomSql((Object)("inb." + FISDefinitions.col_FISFlight_Et.getColumnNameSQL() + " AS inb_" + FISDefinitions.col_FISFlight_Et.getColumnNameSQL())), new CustomSql((Object)("inb." + FISDefinitions.col_FISFlight_St.getColumnNameSQL() + " AS inb_" + FISDefinitions.col_FISFlight_St.getColumnNameSQL())), new CustomSql((Object)("inb." + FISDefinitions.col_FISFlight_Ot.getColumnNameSQL() + " AS inb_" + FISDefinitions.col_FISFlight_Ot.getColumnNameSQL())), new CustomSql((Object)("inb." + FISDefinitions.col_FISFlight_FlightNumber.getColumnNameSQL() + " AS inb_" + FISDefinitions.col_FISFlight_FlightNumber.getColumnNameSQL())), new CustomSql((Object)("inb." + FISDefinitions.col_FISFlight_FlNature.getColumnNameSQL() + " AS inb_" + FISDefinitions.col_FISFlight_FlNature.getColumnNameSQL())), new CustomSql((Object)("inb." + FISDefinitions.col_FISFlight_MovType.getColumnNameSQL() + " AS inb_" + FISDefinitions.col_FISFlight_MovType.getColumnNameSQL())), new CustomSql((Object)("inb." + FISDefinitions.col_FISFlight_Orig.getColumnNameSQL() + " AS inb_" + FISDefinitions.col_FISFlight_Orig.getColumnNameSQL())), new CustomSql((Object)("inb." + FISDefinitions.col_FISFlight_PKey.getColumnNameSQL() + " AS inb_" + FISDefinitions.col_FISFlight_PKey.getColumnNameSQL())), new CustomSql((Object)("inb." + FISDefinitions.col_FISFlight_AcType.getColumnNameSQL() + " AS inb_" + FISDefinitions.col_FISFlight_AcType.getColumnNameSQL())), new CustomSql((Object)("inb." + FISDefinitions.col_FISFlight_Reg.getColumnNameSQL() + " AS inb_" + FISDefinitions.col_FISFlight_Reg.getColumnNameSQL())), new CustomSql((Object)("outb." + FISDefinitions.col_FISFlight_Bt.getColumnNameSQL() + " AS outb_" + FISDefinitions.col_FISFlight_Bt.getColumnNameSQL())), new CustomSql((Object)("outb." + FISDefinitions.col_FISFlight_Et.getColumnNameSQL() + " AS outb_" + FISDefinitions.col_FISFlight_Et.getColumnNameSQL())), new CustomSql((Object)("outb." + FISDefinitions.col_FISFlight_St.getColumnNameSQL() + " AS outb_" + FISDefinitions.col_FISFlight_St.getColumnNameSQL())), new CustomSql((Object)("outb." + FISDefinitions.col_FISFlight_Ot.getColumnNameSQL() + " AS outb_" + FISDefinitions.col_FISFlight_Ot.getColumnNameSQL())), new CustomSql((Object)("outb." + FISDefinitions.col_FISFlight_FlightNumber.getColumnNameSQL() + " AS outb_" + FISDefinitions.col_FISFlight_FlightNumber.getColumnNameSQL())), new CustomSql((Object)("outb." + FISDefinitions.col_FISFlight_FlNature.getColumnNameSQL() + " AS outb_" + FISDefinitions.col_FISFlight_FlNature.getColumnNameSQL())), new CustomSql((Object)("outb." + FISDefinitions.col_FISFlight_MovType.getColumnNameSQL() + " AS outb_" + FISDefinitions.col_FISFlight_MovType.getColumnNameSQL())), new CustomSql((Object)("outb." + FISDefinitions.col_FISFlight_Dest.getColumnNameSQL() + " AS outb_" + FISDefinitions.col_FISFlight_Dest.getColumnNameSQL())), new CustomSql((Object)("outb." + FISDefinitions.col_FISFlight_PKey.getColumnNameSQL() + " AS outb_" + FISDefinitions.col_FISFlight_PKey.getColumnNameSQL())), new CustomSql((Object)("outb." + FISDefinitions.col_FISFlight_AcType.getColumnNameSQL() + " AS outb_" + FISDefinitions.col_FISFlight_AcType.getColumnNameSQL())), new CustomSql((Object)("outb." + FISDefinitions.col_FISFlight_Reg.getColumnNameSQL() + " AS outb_" + FISDefinitions.col_FISFlight_Reg.getColumnNameSQL()))});
        query.addCustomFromTable((Object)new CustomSql((Object)"stand_state_history state"));
        query.addCustomJoin(SelectQuery.JoinType.LEFT_OUTER, (Object)FISDefinitions.tbl_StandStateHistory.getTableNameSQL(), (Object)(FISDefinitions.tbl_FISFlight.getTableNameSQL() + " AS inb"), (Condition)new BinaryCondition(BinaryCondition.Op.EQUAL_TO, (SqlObject)new CustomSql((Object)("state." + FISDefinitions.col_StandStateHistory_inbFlightId.getColumnNameSQL())), (SqlObject)new CustomSql((Object)("inb." + FISDefinitions.col_FISFlight_Id.getColumnNameSQL()))));
        query.addCustomJoin(SelectQuery.JoinType.LEFT_OUTER, (Object)FISDefinitions.tbl_StandStateHistory.getTableNameSQL(), (Object)(FISDefinitions.tbl_FISFlight.getTableNameSQL() + " AS outb"), (Condition)new BinaryCondition(BinaryCondition.Op.EQUAL_TO, (SqlObject)new CustomSql((Object)("state." + FISDefinitions.col_StandStateHistory_outbFlightId.getColumnNameSQL())), (SqlObject)new CustomSql((Object)("outb." + FISDefinitions.col_FISFlight_Id.getColumnNameSQL()))));
        ComboCondition whereCondition = new ComboCondition(ComboCondition.Op.OR);
        ComboCondition whereCondition1 = new ComboCondition(ComboCondition.Op.AND);
        whereCondition1.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.LESS_THAN, (Object)new CustomSql((Object)("state." + FISDefinitions.col_StandStateHistory_BeginTime.getColumnNameSQL())), (Object)until));
        whereCondition1.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.GREATER_THAN, (Object)new CustomSql((Object)("state." + FISDefinitions.col_StandStateHistory_EndTime.getColumnNameSQL())), (Object)since));
        ComboCondition whereCondition2 = new ComboCondition(ComboCondition.Op.AND);
        whereCondition2.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.EQUAL_TO, (Object)new CustomSql((Object)("state." + FISDefinitions.col_StandStateHistory_EndTime.getColumnNameSQL())), (Object)0));
        whereCondition2.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.LESS_THAN, (Object)new CustomSql((Object)("state." + FISDefinitions.col_StandStateHistory_BeginTime.getColumnNameSQL())), (Object)until));
        whereCondition.addConditions(new Condition[]{whereCondition1, whereCondition2});
        query.addCondition((Condition)whereCondition);
        query.addCustomOrdering((Object)new CustomSql((Object)("state." + FISDefinitions.col_StandStateHistory_BeginTime.getColumnNameSQL())), OrderObject.Dir.ASCENDING);
        String sql = ((SelectQuery)query.validate()).toString();
        return sql;
    }
}

