/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.data.fastlanereader;

import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.SelectQuery;
import com.healthmarketscience.sqlbuilder.dbspec.Column;
import com.healthmarketscience.sqlbuilder.dbspec.Table;
import de.proveo.wwt.datamodel.image.ImageType;
import de.proveo.wwt.datamodel.unit.identity.UnitIdentity;
import de.proveo.wwt.datamodel.unit.model.UnitModel;
import de.proveo.wwt.datamodel.unit.typeIdentity.UnitTypeIdentity;
import de.proveo.wwt.logic.app.util.Stopwatch;
import de.proveo.wwt.logic.web.data.enumerations.UnitFastLaneReaderOrder;
import de.proveo.wwt.logic.web.data.fastlanereader.base.FastLaneReader;
import de.proveo.wwt.logic.web.data.query.definitions.UnitDefinitions;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UnitFastLaneReader
extends FastLaneReader {
    private static final Log log = LogFactory.getLog(UnitFastLaneReader.class);

    public List<UnitIdentity> getUnitIdentities(boolean includeDeleted) {
        UnitDeletedState deletedState = UnitDeletedState.NOT_DELETED;
        if (includeDeleted) {
            deletedState = UnitDeletedState.ALL;
        }
        SelectQuery query = this.buildUnitModelSql(UnitType.UNIT, deletedState, UnitFastLaneReaderOrder.ByNothing);
        String sql = ((SelectQuery)query.validate()).toString();
        List<UnitModel> unitModels = this.executeUnitModelSql(sql);
        ArrayList<UnitIdentity> unitIdentities = new ArrayList<UnitIdentity>();
        for (UnitModel unitModel : unitModels) {
            unitIdentities.add(unitModel.getUnitIdentity());
        }
        return unitIdentities;
    }

    public List<UnitModel> getUnitModels(UnitType unitType, UnitDeletedState deletedState, UnitFastLaneReaderOrder order) {
        String sql = ((SelectQuery)this.buildUnitModelSql(unitType, deletedState, order).validate()).toString();
        return this.executeUnitModelSql(sql);
    }

    private SelectQuery buildUnitModelSql(UnitType unitType, UnitDeletedState deletedState, UnitFastLaneReaderOrder order) {
        SelectQuery query = new SelectQuery(false);
        query.addAllTableColumns((Table)UnitDefinitions.tbl_UnitModel).addAllTableColumns((Table)UnitDefinitions.tbl_UnitIdentity).addFromTable((Table)UnitDefinitions.tbl_UnitModel).addJoin(SelectQuery.JoinType.INNER, (Table)UnitDefinitions.tbl_UnitModel, (Table)UnitDefinitions.tbl_UnitIdentity, (Column)UnitDefinitions.col_UnitModel_UnitId, (Column)UnitDefinitions.col_UnitIdentity_UnitId);
        switch (unitType) {
            case GROUP: {
                query.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.EQUAL_TO, (Object)UnitDefinitions.col_UnitModel_IsBasic, (Object)0));
                break;
            }
            case UNIT: {
                query.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.EQUAL_TO, (Object)UnitDefinitions.col_UnitModel_IsBasic, (Object)1));
                break;
            }
        }
        switch (deletedState) {
            case NOT_DELETED: {
                query.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.EQUAL_TO, (Object)UnitDefinitions.col_UnitModel_Deleted, (Object)0));
                break;
            }
            case DELETED: {
                query.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.EQUAL_TO, (Object)UnitDefinitions.col_UnitModel_Deleted, (Object)1));
                break;
            }
        }
        switch (order) {
            case ByName: {
                query.addOrderings(new Column[]{UnitDefinitions.col_UnitIdentity_Name});
            }
        }
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<UnitModel> executeUnitModelSql(String sql) {
        log.debug((Object)"executeUnitModelSql()");
        Stopwatch stopwatch = new Stopwatch(UnitFastLaneReader.class, "UnitFastLaneReader");
        stopwatch.start("Overall");
        Connection connection = null;
        Statement statement = null;
        ArrayList<UnitModel> unitModels = new ArrayList<UnitModel>();
        try {
            stopwatch.start("Database access");
            connection = this.getConnection();
            statement = this.createReadOnlyForwardOnlyStatement(connection);
            log.debug((Object)("executed SQL: " + sql));
            ResultSet resultSet = statement.executeQuery(sql);
            stopwatch.stop("Database access", true);
            stopwatch.start("Build DTO");
            Map<Long, UnitTypeIdentity> typeIdentityMap = this.getUnitTypeidentityMap();
            int idx_unitModel_unitId = resultSet.findColumn(UnitDefinitions.col_UnitModel_UnitId.getName());
            int idx_unitModel_UnitUserRefresh = resultSet.findColumn(UnitDefinitions.col_UnitModel_UnitUserRefresh.getName());
            int idx_unitModel_UnitUserSyncStartTime = resultSet.findColumn(UnitDefinitions.col_UnitModel_UnitUserSyncStartTime.getName());
            int idx_unitModel_UnitUserSyncEndTime = resultSet.findColumn(UnitDefinitions.col_UnitModel_UnitUserSyncEndTime.getName());
            int idx_unitModel_UnitUserSyncDone = resultSet.findColumn(UnitDefinitions.col_UnitModel_UnitUserSyncDone.getName());
            int idx_unitModel_UnitUserSyncSuccessful = resultSet.findColumn(UnitDefinitions.col_UnitModel_UnitUserSyncSuccessful.getName());
            int idx_unitModel_UnitUserSyncError = resultSet.findColumn(UnitDefinitions.col_UnitModel_UnitUserSyncError.getName());
            int idx_unitModel_OperativeTimeOffset = resultSet.findColumn(UnitDefinitions.col_UnitModel_OperativeTimeOffset.getName());
            int idx_unitModel_IsBasic = resultSet.findColumn(UnitDefinitions.col_UnitModel_IsBasic.getName());
            int idx_unitModel_SendData = resultSet.findColumn(UnitDefinitions.col_UnitModel_SendData.getName());
            int idx_unitModel_CustomerUnitId = resultSet.findColumn(UnitDefinitions.col_UnitModel_CustomerUnitId.getName());
            int idx_unitModel_IpAddress = resultSet.findColumn(UnitDefinitions.col_UnitModel_IpAddress.getName());
            int idx_unitModel_NextMaintenance = resultSet.findColumn(UnitDefinitions.col_UnitModel_NextMaintenance.getName());
            int idx_unitModel_AirportmapVisible = resultSet.findColumn(UnitDefinitions.col_UnitModel_AirportmapVisible.getName());
            int idx_unitModel_Callback = resultSet.findColumn(UnitDefinitions.col_UnitModel_Callback.getName());
            int idx_unitModel_SerialNumber = resultSet.findColumn(UnitDefinitions.col_UnitModel_SerialNumber.getName());
            int idx_unitModel_SimNumber = resultSet.findColumn(UnitDefinitions.col_UnitModel_SimNumber.getName());
            int idx_unitModel_TelephoneNumber = resultSet.findColumn(UnitDefinitions.col_UnitModel_TelephoneNumber.getName());
            int idx_unitModel_RegistrationNumber = resultSet.findColumn(UnitDefinitions.col_UnitModel_RegistrationNumber.getName());
            int idx_unitModel_BodyNumber = resultSet.findColumn(UnitDefinitions.col_UnitModel_BodyNumber.getName());
            int idx_unitModel_UnitUserRefreshTmp = resultSet.findColumn(UnitDefinitions.col_UnitModel_UnitUserRefreshTmp.getName());
            int idx_unitModel_Brand = resultSet.findColumn(UnitDefinitions.col_UnitModel_Brand.getName());
            int idx_unitModel_ModelType = resultSet.findColumn(UnitDefinitions.col_UnitModel_ModelType.getName());
            int idx_unitModel_Deleted = resultSet.findColumn(UnitDefinitions.col_UnitModel_Deleted.getName());
            int idx_unitModel_DeletedTime = resultSet.findColumn(UnitDefinitions.col_UnitModel_DeletedTime.getName());
            int idx_unitModel_DeletedByUsername = resultSet.findColumn(UnitDefinitions.col_UnitModel_DeletedByUsername.getName());
            int idx_unitModel_UnitTypeId = resultSet.findColumn(UnitDefinitions.col_UnitModel_UnitTypeId.getName());
            int idx_unitModel_UnitSclRefresh = resultSet.findColumn(UnitDefinitions.col_UnitModel_UnitSclRefresh.getName());
            int idx_unitModel_UnitSclSyncStartTime = resultSet.findColumn(UnitDefinitions.col_UnitModel_UnitSclSyncStartTime.getName());
            int idx_unitModel_UnitSclSyncEndTime = resultSet.findColumn(UnitDefinitions.col_UnitModel_UnitSclSyncEndTime.getName());
            int idx_unitModel_UnitSclSyncDone = resultSet.findColumn(UnitDefinitions.col_UnitModel_UnitSclSyncDone.getName());
            int idx_unitModel_UnitSclSyncError = resultSet.findColumn(UnitDefinitions.col_UnitModel_UnitSclSyncError.getName());
            int idx_unitModel_UnitSclValidTime = resultSet.findColumn(UnitDefinitions.col_UnitModel_UnitSclValidTime.getName());
            int idx_unitModel_UnitSclRefreshType = resultSet.findColumn(UnitDefinitions.col_UnitModel_UnitSclRefreshType.getName());
            int idx_unitModel_IMEI = resultSet.findColumn(UnitDefinitions.col_UnitModel_IMEI.getName());
            int idx_unitModel_DeviceType = resultSet.findColumn(UnitDefinitions.col_UnitModel_DeviceType.getName());
            int idx_unitIdentity_unitId = resultSet.findColumn(UnitDefinitions.col_UnitIdentity_UnitId.getName());
            int idx_unitIdentity_name = resultSet.findColumn(UnitDefinitions.col_UnitIdentity_Name.getName());
            int idx_unitIdentity_unitKind = resultSet.findColumn(UnitDefinitions.col_UnitIdentity_UnitKind.getName());
            int idx_unitIdentity_pos = resultSet.findColumn(UnitDefinitions.col_UnitIdentity_Pos.getName());
            int idx_unitIdentity_imageName = resultSet.findColumn(UnitDefinitions.col_UnitIdentity_ImageName.getName());
            int dataSize = 0;
            while (resultSet.next()) {
                UnitIdentity unitIdentity = new UnitIdentity();
                unitIdentity.setUnitId(resultSet.getLong(idx_unitIdentity_unitId));
                unitIdentity.setName(resultSet.getString(idx_unitIdentity_name));
                unitIdentity.setUnitKind(resultSet.getString(idx_unitIdentity_unitKind));
                unitIdentity.setPos(resultSet.getInt(idx_unitIdentity_pos));
                unitIdentity.setImageName(resultSet.getString(idx_unitIdentity_imageName));
                UnitModel unitModel = new UnitModel();
                unitModel.setUnitId(resultSet.getLong(idx_unitModel_unitId));
                unitModel.setUnitUserRefresh(resultSet.getBoolean(idx_unitModel_UnitUserRefresh));
                unitModel.setUnitUserSyncStartTime(resultSet.getLong(idx_unitModel_UnitUserSyncStartTime));
                unitModel.setUnitUserSyncEndTime(resultSet.getLong(idx_unitModel_UnitUserSyncEndTime));
                unitModel.setUnitUserSyncDone(resultSet.getBoolean(idx_unitModel_UnitUserSyncDone));
                unitModel.setUnitUserSyncSuccessful(resultSet.getBoolean(idx_unitModel_UnitUserSyncSuccessful));
                unitModel.setUnitUserSyncError(resultSet.getString(idx_unitModel_UnitUserSyncError));
                unitModel.setOperativeTimeOffset(resultSet.getLong(idx_unitModel_OperativeTimeOffset));
                unitModel.setBasic(resultSet.getBoolean(idx_unitModel_IsBasic));
                unitModel.setSendData(resultSet.getBoolean(idx_unitModel_SendData));
                unitModel.setCustomerUnitId(resultSet.getString(idx_unitModel_CustomerUnitId));
                unitModel.setIpAddress(resultSet.getString(idx_unitModel_IpAddress));
                unitModel.setNextMaintenance(resultSet.getInt(idx_unitModel_NextMaintenance));
                unitModel.setAirportmapVisible(resultSet.getBoolean(idx_unitModel_AirportmapVisible));
                unitModel.setCallback(resultSet.getBoolean(idx_unitModel_Callback));
                unitModel.setSerialNumber(resultSet.getString(idx_unitModel_SerialNumber));
                unitModel.setSimNumber(resultSet.getString(idx_unitModel_SimNumber));
                unitModel.setTelephoneNumber(resultSet.getString(idx_unitModel_TelephoneNumber));
                unitModel.setRegistrationNumber(resultSet.getString(idx_unitModel_RegistrationNumber));
                unitModel.setBodyNumber(resultSet.getString(idx_unitModel_BodyNumber));
                unitModel.setUnitUserRefreshTmp(resultSet.getBoolean(idx_unitModel_UnitUserRefreshTmp));
                unitModel.setBrand(resultSet.getString(idx_unitModel_Brand));
                unitModel.setModelType(resultSet.getString(idx_unitModel_ModelType));
                unitModel.setDeleted(resultSet.getBoolean(idx_unitModel_Deleted));
                unitModel.setDeletedTime(resultSet.getLong(idx_unitModel_DeletedTime));
                unitModel.setDeletedByUsername(resultSet.getString(idx_unitModel_DeletedByUsername));
                unitModel.setUnitSclRefresh(resultSet.getBoolean(idx_unitModel_UnitSclRefresh));
                unitModel.setUnitSclSyncStartTime(resultSet.getLong(idx_unitModel_UnitSclSyncStartTime));
                unitModel.setUnitSclSynchEndTime(resultSet.getLong(idx_unitModel_UnitSclSyncEndTime));
                unitModel.setUnitSclSyncDone(resultSet.getBoolean(idx_unitModel_UnitSclSyncDone));
                unitModel.setUnitSclSyncError(resultSet.getString(idx_unitModel_UnitSclSyncError));
                unitModel.setUnitSclValidTime(resultSet.getLong(idx_unitModel_UnitSclValidTime));
                unitModel.setUnitSclRefreshType(resultSet.getString(idx_unitModel_UnitSclRefreshType));
                unitModel.setUnitTypeIdentity(typeIdentityMap.get(resultSet.getLong(idx_unitModel_UnitTypeId)));
                unitModel.setIMEI(resultSet.getString(idx_unitModel_IMEI));
                unitModel.setDeviceType(resultSet.getString(idx_unitModel_DeviceType));
                unitModel.setUnitIdentity(unitIdentity);
                unitIdentity.setUnitModel(unitModel);
                unitModels.add(unitModel);
                ++dataSize;
            }
            stopwatch.stop("Build DTO", true, dataSize);
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
        }
        stopwatch.stop("Overall", true);
        return unitModels;
    }

    public List<UnitTypeIdentity> getUnitTypeidentities() {
        String sql = this.buildTypeIdentitySql();
        return this.executeTypeIdentitySql(sql);
    }

    public Map<Long, UnitTypeIdentity> getUnitTypeidentityMap() {
        String sql = this.buildTypeIdentitySql();
        HashMap<Long, UnitTypeIdentity> map = new HashMap<Long, UnitTypeIdentity>();
        for (UnitTypeIdentity unitTypeIdentity : this.executeTypeIdentitySql(sql)) {
            map.put(unitTypeIdentity.getId(), unitTypeIdentity);
        }
        return map;
    }

    private String buildTypeIdentitySql() {
        SelectQuery query = new SelectQuery(false);
        query.addAllTableColumns((Table)UnitDefinitions.tbl_UnitTypeIdentity).addFromTable((Table)UnitDefinitions.tbl_UnitTypeIdentity);
        return ((SelectQuery)query.validate()).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<UnitTypeIdentity> executeTypeIdentitySql(String sql) {
        log.debug((Object)"executeTypeIdentitySql()");
        Stopwatch stopwatch = new Stopwatch(UnitFastLaneReader.class, "UnitFastLaneReader");
        stopwatch.start("Overall");
        Connection connection = null;
        Statement statement = null;
        ArrayList<UnitTypeIdentity> unitTypeIdentities = new ArrayList<UnitTypeIdentity>();
        try {
            stopwatch.start("Database access");
            connection = this.getConnection();
            statement = this.createReadOnlyForwardOnlyStatement(connection);
            log.debug((Object)("executed SQL: " + sql));
            ResultSet resultSet = statement.executeQuery(sql);
            stopwatch.stop("Database access", true);
            stopwatch.start("Build DTO");
            Map<Integer, ImageType> imageTypeMap = this.getImageTypeMap();
            int idx_id = resultSet.findColumn(UnitDefinitions.col_UnitTypeIdentity_Id.getName());
            int idx_name = resultSet.findColumn(UnitDefinitions.col_UnitTypeIdentity_Name.getName());
            int idx_imageName = resultSet.findColumn(UnitDefinitions.col_UnitTypeIdentity_ImageName.getName());
            int idx_imageTypeId = resultSet.findColumn(UnitDefinitions.col_UnitTypeIdentity_ImageTypeId.getName());
            int dataSize = 0;
            while (resultSet.next()) {
                UnitTypeIdentity unitTypeIdentity = new UnitTypeIdentity();
                unitTypeIdentity.setId(resultSet.getLong(idx_id));
                unitTypeIdentity.setName(resultSet.getString(idx_name));
                unitTypeIdentity.setImageName(resultSet.getString(idx_imageName));
                int imageTypeId = resultSet.getInt(idx_imageTypeId);
                unitTypeIdentity.setImageTypeId(imageTypeId);
                unitTypeIdentity.setImageType(imageTypeMap.get(imageTypeId));
                unitTypeIdentities.add(unitTypeIdentity);
                ++dataSize;
            }
            stopwatch.stop("Build DTO", true, dataSize);
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
        }
        stopwatch.stop("Overall", true);
        return unitTypeIdentities;
    }

    public List<ImageType> getImageTypes() {
        String sql = this.buildImageTypeSql();
        return this.executeImageTypeSql(sql);
    }

    public Map<Integer, ImageType> getImageTypeMap() {
        HashMap<Integer, ImageType> imageTypeMap = new HashMap<Integer, ImageType>();
        for (ImageType imageType : this.getImageTypes()) {
            imageTypeMap.put(imageType.getId(), imageType);
        }
        return imageTypeMap;
    }

    private String buildImageTypeSql() {
        SelectQuery query = new SelectQuery(false);
        query.addAllTableColumns((Table)UnitDefinitions.tbl_ImageType).addFromTable((Table)UnitDefinitions.tbl_ImageType);
        return ((SelectQuery)query.validate()).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ImageType> executeImageTypeSql(String sql) {
        log.debug((Object)"executeImageTypeSql()");
        Stopwatch stopwatch = new Stopwatch(UnitFastLaneReader.class, "UnitFastLaneReader");
        stopwatch.start("Overall");
        Connection connection = null;
        Statement statement = null;
        ArrayList<ImageType> imageTypes = new ArrayList<ImageType>();
        try {
            stopwatch.start("Database access");
            connection = this.getConnection();
            statement = this.createReadOnlyForwardOnlyStatement(connection);
            log.debug((Object)("executed SQL: " + sql));
            ResultSet resultSet = statement.executeQuery(sql);
            stopwatch.stop("Database access", true);
            stopwatch.start("Build DTO");
            int idx_id = resultSet.findColumn(UnitDefinitions.col_ImageType_Id.getName());
            int idx_name = resultSet.findColumn(UnitDefinitions.col_ImageType_Name.getName());
            int idx_description = resultSet.findColumn(UnitDefinitions.col_ImageType_Description.getName());
            int dataSize = 0;
            while (resultSet.next()) {
                ImageType imageType = new ImageType();
                imageType.setId(resultSet.getInt(idx_id));
                imageType.setName(resultSet.getString(idx_name));
                imageType.setDescription(resultSet.getString(idx_description));
                imageTypes.add(imageType);
                ++dataSize;
            }
            stopwatch.stop("Build DTO", true, dataSize);
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
        }
        stopwatch.stop("Overall", true);
        return imageTypes;
    }

    public static enum UnitDeletedState {
        NOT_DELETED,
        DELETED,
        ALL;

    }

    public static enum UnitType {
        GROUP,
        UNIT,
        ALL;

    }
}

