/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.data.fastlanereader;

import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.SelectQuery;
import com.healthmarketscience.sqlbuilder.SetOperationQuery;
import com.healthmarketscience.sqlbuilder.UnaryCondition;
import com.healthmarketscience.sqlbuilder.UnionQuery;
import com.healthmarketscience.sqlbuilder.dbspec.Column;
import com.healthmarketscience.sqlbuilder.dbspec.Table;
import de.proveo.wwt.logic.app.util.Stopwatch;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.data.fastlanereader.base.FastLaneReader;
import de.proveo.wwt.logic.web.data.query.definitions.AccountDefinitions;
import de.proveo.wwt.logic.web.data.query.definitions.UnitDefinitions;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.UnitTreeFacadeLocal;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.dto.UnitIdNodeMatcher;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.dto.UnitNodeType;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.dto.UnitTreeNode;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.naming.InitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PermissionFastLaneReader
extends FastLaneReader {
    private static final Log log = LogFactory.getLog(PermissionFastLaneReader.class);
    private UnitTreeFacadeLocal unitTreeFacade;

    public PermissionFastLaneReader() {
        try {
            InitialContext context = new InitialContext();
            this.unitTreeFacade = (UnitTreeFacadeLocal)context.lookup("rts/UnitTreeFacade/local");
        }
        catch (Exception e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
    }

    public HashSet<Long> getAllUnitPermissions() {
        String sql = this.buildAllUnitPermissionsSql();
        return this.executeSql(sql);
    }

    public HashSet<Long> getUnitPermissions(long userId) {
        HashSet<Long> unitIds = new HashSet<Long>();
        String sql = this.buildUnitPermissionSql(userId);
        unitIds.addAll(this.executeSql(sql));
        UnitTreeNode rootNode = this.unitTreeFacade.getTreeViewData(false, false, false);
        HashSet<Long> groupIds = this.getGroupPermissions(userId);
        UnitIdNodeMatcher nodeMatcher = new UnitIdNodeMatcher();
        Iterator<Long> i$ = groupIds.iterator();
        while (i$.hasNext()) {
            Long groupId;
            nodeMatcher.unitId = groupId = i$.next();
            UnitTreeNode groupNode = (UnitTreeNode)rootNode.getNode(true, nodeMatcher);
            List<UnitTreeNode> childNodes = groupNode.getSubnodes(UnitNodeType.Unit);
            for (UnitTreeNode unitNode : childNodes) {
                unitIds.add(((UnitDTO)unitNode.getData()).getUnitId());
            }
        }
        return unitIds;
    }

    public HashSet<Long> getGroupPermissions(long userId) {
        String sql = this.buildGroupPermissionSql(userId);
        return this.executeSql(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashSet<Long> executeSql(String sql) {
        log.debug((Object)"executeSql()");
        Stopwatch stopwatch = new Stopwatch(PermissionFastLaneReader.class, "PermissionFastLaneReader");
        stopwatch.start("Overall");
        Connection connection = null;
        Statement statement = null;
        HashSet<Long> unitIds = new HashSet<Long>();
        try {
            stopwatch.start("Database access");
            connection = this.getConnection();
            statement = this.createReadOnlyForwardOnlyStatement(connection);
            log.debug((Object)("executed SQL: " + sql));
            ResultSet resultSet = statement.executeQuery(sql);
            int dataSize = 0;
            stopwatch.stop("Database access", true);
            while (resultSet.next()) {
                unitIds.add(resultSet.getLong(1));
                ++dataSize;
            }
            log.debug((Object)("Found unit permissions: " + dataSize));
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
        }
        stopwatch.stop("Overall", true);
        return unitIds;
    }

    private String buildAllUnitPermissionsSql() {
        SelectQuery query = new SelectQuery(false);
        query.addColumns(new Column[]{UnitDefinitions.col_UnitModel_UnitId}).addFromTable((Table)UnitDefinitions.tbl_UnitModel).addCondition((Condition)new BinaryCondition(BinaryCondition.Op.EQUAL_TO, (Object)UnitDefinitions.col_UnitModel_IsBasic, (Object)true));
        return ((SelectQuery)query.validate()).toString();
    }

    private String buildUnitPermissionSql(long userId) {
        SelectQuery unitsDirectQuery = new SelectQuery(true);
        unitsDirectQuery.addColumns(new Column[]{UnitDefinitions.col_UnitPermission_UnitId}).addFromTable((Table)UnitDefinitions.tbl_UnitPermission).addCondition((Condition)new BinaryCondition(BinaryCondition.Op.EQUAL_TO, (Object)UnitDefinitions.col_UnitPermission_AccountId, (Object)userId)).addCondition((Condition)new UnaryCondition(UnaryCondition.Op.IS_NOT_NULL, (Object)UnitDefinitions.col_UnitPermission_UnitId));
        SelectQuery unitsInRolesQuery = new SelectQuery(true);
        unitsInRolesQuery.addColumns(new Column[]{UnitDefinitions.col_UnitPermission_UnitId}).addFromTable((Table)AccountDefinitions.tbl_AccountXRole).addJoin(SelectQuery.JoinType.INNER, (Table)AccountDefinitions.tbl_AccountXRole, (Table)UnitDefinitions.tbl_UnitPermission, (Column)AccountDefinitions.col_AccountXRole_IdRole, (Column)UnitDefinitions.col_UnitPermission_RoleId).addCondition((Condition)new BinaryCondition(BinaryCondition.Op.EQUAL_TO, (Object)AccountDefinitions.col_AccountXRole_IdAccount, (Object)userId)).addCondition((Condition)new UnaryCondition(UnaryCondition.Op.IS_NOT_NULL, (Object)UnitDefinitions.col_UnitPermission_UnitId));
        SelectQuery unitsInGroupsQuery = new SelectQuery(true);
        unitsInGroupsQuery.addColumns(new Column[]{UnitDefinitions.col_UnitPermission_UnitId}).addFromTable((Table)AccountDefinitions.tbl_AccountXGroupident).addJoin(SelectQuery.JoinType.INNER, (Table)AccountDefinitions.tbl_AccountXGroupident, (Table)UnitDefinitions.tbl_UnitPermission, (Column)AccountDefinitions.col_AccountXGroupident_IdGroupident, (Column)UnitDefinitions.col_UnitPermission_Groupident).addCondition((Condition)new BinaryCondition(BinaryCondition.Op.EQUAL_TO, (Object)AccountDefinitions.col_AccountXGroupident_IdAccount, (Object)userId)).addCondition((Condition)new UnaryCondition(UnaryCondition.Op.IS_NOT_NULL, (Object)UnitDefinitions.col_UnitPermission_UnitId));
        SelectQuery unitsInRolesInGroupsQuery = new SelectQuery(true);
        unitsInRolesInGroupsQuery.addColumns(new Column[]{UnitDefinitions.col_UnitPermission_UnitId}).addFromTable((Table)AccountDefinitions.tbl_AccountXGroupident).addJoin(SelectQuery.JoinType.INNER, (Table)AccountDefinitions.tbl_AccountXGroupident, (Table)AccountDefinitions.tbl_GroupidentXRole, (Column)AccountDefinitions.col_AccountXGroupident_IdGroupident, (Column)AccountDefinitions.col_GroupidentXRole_IdGroupident).addJoin(SelectQuery.JoinType.INNER, (Table)AccountDefinitions.tbl_GroupidentXRole, (Table)UnitDefinitions.tbl_UnitPermission, (Column)AccountDefinitions.col_GroupidentXRole_IdRole, (Column)UnitDefinitions.col_UnitPermission_RoleId).addCondition((Condition)new BinaryCondition(BinaryCondition.Op.EQUAL_TO, (Object)AccountDefinitions.col_AccountXGroupident_IdAccount, (Object)userId)).addCondition((Condition)new UnaryCondition(UnaryCondition.Op.IS_NOT_NULL, (Object)UnitDefinitions.col_UnitPermission_UnitId));
        UnionQuery unionQuery = new UnionQuery(SetOperationQuery.Type.UNION, new SelectQuery[]{unitsDirectQuery, unitsInRolesQuery, unitsInGroupsQuery, unitsInRolesInGroupsQuery});
        return ((UnionQuery)unionQuery.validate()).toString();
    }

    private String buildGroupPermissionSql(long userId) {
        SelectQuery groupsDirectQuery = new SelectQuery(true);
        groupsDirectQuery.addColumns(new Column[]{UnitDefinitions.col_UnitPermission_GroupId}).addFromTable((Table)UnitDefinitions.tbl_UnitPermission).addCondition((Condition)new BinaryCondition(BinaryCondition.Op.EQUAL_TO, (Object)UnitDefinitions.col_UnitPermission_AccountId, (Object)userId)).addCondition((Condition)new UnaryCondition(UnaryCondition.Op.IS_NOT_NULL, (Object)UnitDefinitions.col_UnitPermission_GroupId));
        SelectQuery groupsInRolesQuery = new SelectQuery(true);
        groupsInRolesQuery.addColumns(new Column[]{UnitDefinitions.col_UnitPermission_GroupId}).addFromTable((Table)AccountDefinitions.tbl_AccountXRole).addJoin(SelectQuery.JoinType.INNER, (Table)AccountDefinitions.tbl_AccountXRole, (Table)UnitDefinitions.tbl_UnitPermission, (Column)AccountDefinitions.col_AccountXRole_IdRole, (Column)UnitDefinitions.col_UnitPermission_RoleId).addCondition((Condition)new BinaryCondition(BinaryCondition.Op.EQUAL_TO, (Object)AccountDefinitions.col_AccountXRole_IdAccount, (Object)userId)).addCondition((Condition)new UnaryCondition(UnaryCondition.Op.IS_NOT_NULL, (Object)UnitDefinitions.col_UnitPermission_GroupId));
        SelectQuery groupsInGroupsQuery = new SelectQuery(true);
        groupsInGroupsQuery.addColumns(new Column[]{UnitDefinitions.col_UnitPermission_GroupId}).addFromTable((Table)AccountDefinitions.tbl_AccountXGroupident).addJoin(SelectQuery.JoinType.INNER, (Table)AccountDefinitions.tbl_AccountXGroupident, (Table)UnitDefinitions.tbl_UnitPermission, (Column)AccountDefinitions.col_AccountXGroupident_IdGroupident, (Column)UnitDefinitions.col_UnitPermission_Groupident).addCondition((Condition)new BinaryCondition(BinaryCondition.Op.EQUAL_TO, (Object)AccountDefinitions.col_AccountXGroupident_IdAccount, (Object)userId)).addCondition((Condition)new UnaryCondition(UnaryCondition.Op.IS_NOT_NULL, (Object)UnitDefinitions.col_UnitPermission_GroupId));
        SelectQuery groupsInRolesInGroupsQuery = new SelectQuery(true);
        groupsInRolesInGroupsQuery.addColumns(new Column[]{UnitDefinitions.col_UnitPermission_GroupId}).addFromTable((Table)AccountDefinitions.tbl_AccountXGroupident).addJoin(SelectQuery.JoinType.INNER, (Table)AccountDefinitions.tbl_AccountXGroupident, (Table)AccountDefinitions.tbl_GroupidentXRole, (Column)AccountDefinitions.col_AccountXGroupident_IdGroupident, (Column)AccountDefinitions.col_GroupidentXRole_IdGroupident).addJoin(SelectQuery.JoinType.INNER, (Table)AccountDefinitions.tbl_GroupidentXRole, (Table)UnitDefinitions.tbl_UnitPermission, (Column)AccountDefinitions.col_GroupidentXRole_IdRole, (Column)UnitDefinitions.col_UnitPermission_RoleId).addCondition((Condition)new BinaryCondition(BinaryCondition.Op.EQUAL_TO, (Object)AccountDefinitions.col_AccountXGroupident_IdAccount, (Object)userId)).addCondition((Condition)new UnaryCondition(UnaryCondition.Op.IS_NOT_NULL, (Object)UnitDefinitions.col_UnitPermission_GroupId));
        UnionQuery unionQuery = new UnionQuery(SetOperationQuery.Type.UNION, new SelectQuery[]{groupsDirectQuery, groupsInRolesQuery, groupsInGroupsQuery, groupsInRolesInGroupsQuery});
        return ((UnionQuery)unionQuery.validate()).toString();
    }
}

