/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.data;

import de.proveo.wwt.datamodel.grouphistory.Grouphistory;
import de.proveo.wwt.logic.app.util.Stopwatch;
import de.proveo.wwt.logic.web.data.FastLaneWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.EntityManager;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Query;
import javax.persistence.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GroupHistoryFastLane
extends FastLaneWriter {
    private static final Log log = LogFactory.getLog(GroupHistoryFastLane.class);
    private static final String STOPWATCH_ALL = "Grouphistory merge: ALL";
    private static final String STOPWATCH_SINGLE = "Grouphistory merge: SINGLE";
    private EntityManager entityManager;

    public GroupHistoryFastLane(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public void mergeGroupHistoryEntries(long targetId, long[] entryIds) {
        Grouphistory targetEntry = (Grouphistory)this.entityManager.find(Grouphistory.class, (Object)targetId);
        List<Grouphistory> entries = new ArrayList<Grouphistory>();
        int size = entryIds.length;
        for (int i = 0; i != size; ++i) {
            entries.add((Grouphistory)this.entityManager.find(Grouphistory.class, (Object)entryIds[i]));
        }
        entries = this.prepareEntries(targetEntry, entries);
        targetEntry.setBeginTime(entries.get(0).getBeginTime());
        targetEntry.setEndTime(entries.get(size - 1).getEndTime());
        int idx = 0;
        long[] replaceIds = new long[size - 1];
        for (int i = 0; i != size; ++i) {
            if (entryIds[i] == targetId) continue;
            replaceIds[idx++] = entryIds[i];
        }
        String[] statements = this.generateUpdateSql(targetId, replaceIds);
        this.updateTables(statements);
        entries.remove(targetEntry);
        for (int i = entries.size() - 1; i >= 0; --i) {
            this.entityManager.remove((Object)entries.get(i));
        }
    }

    private void updateTables(String[] statements) {
        Stopwatch stopwatchAll = new Stopwatch(GroupHistoryFastLane.class, STOPWATCH_ALL);
        stopwatchAll.start(STOPWATCH_ALL);
        Stopwatch stopwatchSingle = new Stopwatch(GroupHistoryFastLane.class, STOPWATCH_SINGLE);
        for (String sql : statements) {
            stopwatchSingle.start(STOPWATCH_SINGLE);
            Query query = this.entityManager.createNativeQuery(sql);
            log.debug((Object)("Executing " + sql));
            int affectedRows = query.executeUpdate();
            log.debug((Object)(String.valueOf(affectedRows) + " rows updated"));
            stopwatchSingle.stop(STOPWATCH_SINGLE, true);
        }
        stopwatchAll.stop(STOPWATCH_ALL, true);
    }

    private String[] generateUpdateSql(long newId, long[] replaceIds) {
        String newIdStr = String.valueOf(newId);
        String[] replaceIdsStr = new String[replaceIds.length];
        for (int i = 0; i != replaceIds.length; ++i) {
            replaceIdsStr[i] = String.valueOf(replaceIds[i]);
        }
        List<UpdateInfo> updateInfoList = this.getTableUpdateInfo();
        ArrayList<String> statements = new ArrayList<String>();
        for (UpdateInfo updateInfo : updateInfoList) {
            StringBuilder sb = new StringBuilder("UPDATE ");
            sb.append(updateInfo.tableName);
            sb.append(" SET ");
            sb.append(updateInfo.columnName);
            sb.append(" = ");
            sb.append(newIdStr);
            sb.append(" WHERE ");
            for (int i = 0; i != replaceIdsStr.length; ++i) {
                if (i != 0) {
                    sb.append(" OR ");
                }
                sb.append(updateInfo.columnName);
                sb.append(" = ");
                sb.append(replaceIdsStr[i]);
            }
            statements.add(sb.toString());
        }
        return statements.toArray(new String[statements.size()]);
    }

    private List<UpdateInfo> getTableUpdateInfo() {
        Field[] fields = this.getDeclaredFields(Grouphistory.class);
        List<UpdateInfo> updateInfo = this.extractUpdateInfo(fields);
        return updateInfo;
    }

    private List<UpdateInfo> extractUpdateInfo(Field[] fields) {
        ArrayList<UpdateInfo> updateInfo = new ArrayList<UpdateInfo>();
        for (Field field : fields) {
            UpdateInfo currentInfo = this.extractOneToManyUpdateInfo(field);
            if (currentInfo == null) continue;
            updateInfo.add(currentInfo);
        }
        return updateInfo;
    }

    private UpdateInfo extractOneToManyUpdateInfo(Field field) {
        UpdateInfo updateInfo = null;
        OneToMany oneToMany = field.getAnnotation(OneToMany.class);
        if (oneToMany != null && this.cascadeRelevant(oneToMany.cascade())) {
            Class targetEntity = oneToMany.targetEntity();
            String mappedBy = oneToMany.mappedBy();
            String columnName = mappedBy != null ? this.findColumnByName(targetEntity, mappedBy) : this.findColumnByClass(targetEntity, Grouphistory.class);
            String tableName = this.getTableName(targetEntity);
            if (columnName != null && tableName != null) {
                updateInfo = new UpdateInfo(tableName, columnName);
            }
        }
        return updateInfo;
    }

    private String findColumnByClass(Class<?> targetClass, Class<?> fieldClass) {
        Field[] fields;
        String columnName = null;
        for (Field field : fields = this.getDeclaredFields(targetClass)) {
            if (field.getType() != fieldClass) continue;
            columnName = this.getColumnName(field);
            break;
        }
        return columnName;
    }

    private String findColumnByName(Class<?> targetClass, String fieldName) {
        Field[] fields;
        String columnName = null;
        for (Field field : fields = this.getDeclaredFields(targetClass)) {
            if (!field.getName().equals(fieldName)) continue;
            columnName = this.getColumnName(field);
            break;
        }
        return columnName;
    }

    private String getColumnName(Field field) {
        String columnName = null;
        JoinColumn joinColumn = field.getAnnotation(JoinColumn.class);
        if (joinColumn != null) {
            columnName = joinColumn.name();
        } else {
            log.error((Object)("Missing @JoinColumn at field " + field.getName() + " in class " + field.getDeclaringClass().getName()));
        }
        return columnName;
    }

    private boolean cascadeRelevant(CascadeType[] cascadeTypes) {
        for (CascadeType type : cascadeTypes) {
            if (type != CascadeType.ALL && type != CascadeType.REFRESH) continue;
            return true;
        }
        return false;
    }

    private String getTableName(Class<?> targetClass) {
        String name = null;
        Table table = targetClass.getAnnotation(Table.class);
        if (table != null) {
            name = table.name();
        } else {
            log.error((Object)("No table name found for " + targetClass.toString()));
        }
        return name;
    }

    private Field[] getDeclaredFields(Class<?> type) {
        Field[] fields = type.getDeclaredFields();
        try {
            for (int i = 0; i != fields.length; ++i) {
                fields[i] = fields[i].getDeclaringClass().getDeclaredField(fields[i].getName());
            }
        }
        catch (NoSuchFieldException e) {
            log.error((Object)"Runs into", (Throwable)e);
        }
        return fields;
    }

    private List<Grouphistory> prepareEntries(Grouphistory targetEntry, List<Grouphistory> entries) {
        if (targetEntry == null) {
            throw new IllegalArgumentException("Target entity must not be null.");
        }
        if (entries == null) {
            throw new IllegalArgumentException("List of merge entities must not be null.");
        }
        ArrayList<Grouphistory> mergeEntries = new ArrayList<Grouphistory>(entries.size());
        mergeEntries.addAll(entries);
        int maxCount = mergeEntries.size() - 1;
        if (maxCount == 0) {
            throw new IllegalArgumentException("Cannot merge one single grouphistory entry with itself. Please pass more than one entry.");
        }
        Collections.sort(mergeEntries, new GrouphistoryComparator());
        for (int i = 0; i != maxCount; ++i) {
            Grouphistory current = (Grouphistory)mergeEntries.get(i);
            Grouphistory next = (Grouphistory)mergeEntries.get(i + 1);
            if (current.getUnitId() != next.getUnitId()) {
                throw new IllegalArgumentException("Cannot merge grouphistory entries of different units.");
            }
            if (current.getEndTime() == next.getBeginTime()) continue;
            throw new IllegalArgumentException("Passed grouphistory entries are not connected to each other (by begin/end time).");
        }
        Grouphistory lastEntry = entries.get(entries.size() - 1);
        if (lastEntry.getEndTime() == 0L && !targetEntry.equals(lastEntry)) {
            throw new IllegalArgumentException("If the current grouphistory entry shall be merged it must be the target entry.");
        }
        return mergeEntries;
    }

    class UpdateInfo {
        public String tableName;
        public String columnName;

        public UpdateInfo() {
        }

        public UpdateInfo(String tableName, String columnName) {
            this.tableName = tableName;
            this.columnName = columnName;
        }
    }

    class GrouphistoryComparator
    implements Comparator<Grouphistory> {
        GrouphistoryComparator() {
        }

        @Override
        public int compare(Grouphistory o1, Grouphistory o2) {
            long diff = o1.getBeginTime() - o2.getBeginTime();
            return diff > 0L ? 1 : (diff == 0L ? 0 : -1);
        }
    }
}

