/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.currentData.dto;

import de.proveo.wwt.datamodel.area.Area;
import de.proveo.wwt.datamodel.geo.GdataCache;
import de.proveo.wwt.datamodel.keepalive.KeepAliveCache;
import de.proveo.wwt.datamodel.notify.NotifyCache;
import de.proveo.wwt.datamodel.state.StateCache;
import de.proveo.wwt.datamodel.use.UseCache;
import de.proveo.wwt.datamodel.use.user.UseUser;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.common.dto.interfaces.IAreaContainer;
import de.proveo.wwt.logic.web.common.dto.interfaces.IOperatorContainer;
import java.util.Date;
import java.util.HashMap;

public class CurrentAllDTO
extends UnitDTO
implements IOperatorContainer,
IAreaContainer {
    private GdataCache position;
    private Long positionDuration;
    private String areaName;
    private KeepAliveCache keepAliveCache;
    private long keepAliveElapsedtime;
    private UseCache useCache;
    private boolean timedOut = true;
    private Date createdDate = new Date();
    private NotifyCache lastNotificaton;
    private HashMap<Long, NotifyCache> notifications;
    private HashMap<Long, Long> notificationElapsedTime;
    private HashMap<Integer, StateCache> states = new HashMap();
    private HashMap<Integer, Long> durations = new HashMap();

    public CurrentAllDTO(UnitDTO unitDTO) {
        super(unitDTO);
        this.notifications = new HashMap();
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public long getCreateTime() {
        return this.getCreatedDate().getTime();
    }

    public void setState(StateCache state) {
        int stateModelID = state.getPk().getStateModelId();
        this.states.put(stateModelID, state);
        this.durations.put(stateModelID, this.createdDate.getTime() - state.getBeginTime());
    }

    public void setPosition(GdataCache currentGdataCache, String areaName) {
        this.positionDuration = this.createdDate.getTime() - currentGdataCache.getBeginReceiveTime();
        this.areaName = areaName;
        this.position = currentGdataCache;
    }

    public GdataCache getPosition() {
        return this.position;
    }

    public Long getPositionDuration() {
        return this.positionDuration;
    }

    public String getAreaName() {
        return this.areaName;
    }

    public boolean isTimedOut() {
        return this.timedOut;
    }

    public boolean isAlive() {
        return !this.timedOut;
    }

    public void setTimedOut(boolean timedOut) {
        this.timedOut = timedOut;
    }

    public KeepAliveCache getKeepAliveCache() {
        return this.keepAliveCache;
    }

    public void setKeepAliveCache(KeepAliveCache keepAliveCache) {
        this.keepAliveElapsedtime = this.createdDate.getTime() - keepAliveCache.getReceiveTime();
        this.keepAliveCache = keepAliveCache;
    }

    public long getKeepAliveDuration() {
        return this.keepAliveElapsedtime;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.unitIdentity != null) {
            sb.append("Name: ");
            sb.append(this.unitIdentity.getName());
            sb.append("\n");
            sb.append("UnitId: ");
            sb.append(this.unitIdentity.getUnitId());
            sb.append("\n");
        }
        return sb.toString();
    }

    public NotifyCache getLastNotificaton() {
        return this.lastNotificaton;
    }

    public void setLastNotificaton(NotifyCache lastNotificaton) {
        this.lastNotificaton = lastNotificaton;
    }

    public HashMap<Long, Long> getNotificationElapsedTime() {
        return this.notificationElapsedTime;
    }

    public HashMap<Integer, Long> getDurations() {
        return this.durations;
    }

    public HashMap<Integer, StateCache> getStates() {
        return this.states;
    }

    public HashMap<Long, NotifyCache> getNotifications() {
        return this.notifications;
    }

    public StateCache getOperationStatus() {
        return this.states.get(2050);
    }

    public Long getOperationStatusDuration() {
        return this.durations.get(2050);
    }

    public StateCache getMotorStatus() {
        return this.states.get(2010);
    }

    public Long getMotorStatusDuration() {
        return this.durations.get(2010);
    }

    public StateCache getConnectorStatus() {
        return this.states.get(2020);
    }

    public StateCache getAssignedStatus() {
        return this.states.get(2100);
    }

    public StateCache getFlag1Status() {
        return this.states.get(2910);
    }

    public StateCache getFlag2Status() {
        return this.states.get(2920);
    }

    public StateCache getFlag3Status() {
        return this.states.get(2930);
    }

    public Long getConnectorStatusDuration() {
        return this.durations.get(2020);
    }

    public StateCache getServiceStatus() {
        return this.states.get(2090);
    }

    public Long getServiceStatusDuration() {
        return this.durations.get(2090);
    }

    public StateCache getFuelStatus() {
        return this.states.get(2030);
    }

    public Long getFuelStatusDuration() {
        return this.durations.get(2030);
    }

    public Long getFlag1StatusDuration() {
        return this.durations.get(2910);
    }

    public Long getFlag2StatusDuration() {
        return this.durations.get(2920);
    }

    public Long getFlag3StatusDuration() {
        return this.durations.get(2930);
    }

    public Long getAssignedStatusDuration() {
        return this.durations.get(2100);
    }

    public StateCache getSclStatus() {
        return this.states.get(3000);
    }

    public Long getSclStatusDuration() {
        return this.durations.get(3000);
    }

    public void setUseCache(UseCache useCache) {
        this.useCache = useCache;
    }

    public UseCache getUseCache() {
        return this.useCache;
    }

    @Override
    public UseUser getUseUser() {
        return this.useCache == null ? null : this.useCache.getUseUser();
    }

    @Override
    public Area getArea() {
        return this.position == null ? null : this.position.getArea();
    }
}

