/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.common.dto;

import de.proveo.wwt.logic.web.historyData.dto.StateDTO;
import java.util.Comparator;

public class StateDTOComparator
implements Comparator<StateDTO> {
    private CompareType[] types;
    private boolean ascending = true;

    public StateDTOComparator(CompareType ... types) {
        this.types = types;
    }

    public StateDTOComparator(boolean ascending, CompareType ... types) {
        this.types = types;
        this.ascending = ascending;
    }

    @Override
    public int compare(StateDTO o1, StateDTO o2) {
        return this.comp(o1, o2) * (this.ascending ? 1 : -1);
    }

    private int comp(StateDTO o1, StateDTO o2) {
        if (o1 == null || o2 == null) {
            return o1 == null ? -1 : 1;
        }
        if (o1.getUnit() == null || o2.getUnit() == null) {
            return o1.getUnit() == null ? -1 : 1;
        }
        int result = 0;
        int index = 0;
        while (result == 0 && index != this.types.length) {
            result = this.comp(o1, o2, this.types[index++]);
        }
        return result;
    }

    private int comp(StateDTO o1, StateDTO o2, CompareType type) {
        switch (type) {
            case STATE_ID: {
                return Integer.valueOf(o1.getStateId()).compareTo(o2.getStateId());
            }
            case BEGIN_TIME: {
                return Long.valueOf(o1.getBeginTime()).compareTo(o2.getBeginTime());
            }
        }
        return 0;
    }

    public static enum CompareType {
        STATE_ID,
        BEGIN_TIME;

    }
}

