/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.common.dto;

import de.proveo.wwt.logic.web.common.dto.ReportDTOBase;
import de.proveo.wwt.logic.web.common.dto.UnitContainerComparator;
import java.util.Comparator;

public class ReportDTOBaseComparator
implements Comparator<ReportDTOBase> {
    private CompareType[] types;
    private boolean ascending = true;

    public ReportDTOBaseComparator(CompareType ... types) {
        this.types = types;
    }

    public ReportDTOBaseComparator(boolean ascending, CompareType ... types) {
        this(types);
        this.ascending = ascending;
    }

    @Override
    public int compare(ReportDTOBase o1, ReportDTOBase o2) {
        if (o1 == null || o2 == null) {
            return (o1 == null ? -1 : 1) * (this.ascending ? 1 : -1);
        }
        int result = 0;
        int index = 0;
        while (result == 0 && index != this.types.length) {
            result = this.compare(o1, o2, this.types[index++]);
        }
        return result * (this.ascending ? 1 : -1);
    }

    private int compare(ReportDTOBase o1, ReportDTOBase o2, CompareType type) {
        switch (type) {
            case UNIT_ID: {
                return new UnitContainerComparator(this.ascending, UnitContainerComparator.CompareType.UNIT_ID).compare(o1, o2);
            }
            case UNIT_NAME: {
                return new UnitContainerComparator(this.ascending, UnitContainerComparator.CompareType.UNIT_NAME).compare(o1, o2);
            }
            case UNIT_BASIC: {
                return new UnitContainerComparator(this.ascending, UnitContainerComparator.CompareType.UNIT_BASIC).compare(o1, o2);
            }
            case BEGIN_TIME: {
                return this.evaluate(o1.getBeginTime(), o2.getBeginTime());
            }
            case END_TIME: {
                return this.evaluate(o1.getEndTime(), o2.getEndTime());
            }
        }
        return 0;
    }

    private int evaluate(Long e1, Long e2) {
        return e1.compareTo(e2);
    }

    public static enum CompareType {
        UNIT_BASIC,
        UNIT_ID,
        UNIT_NAME,
        BEGIN_TIME,
        END_TIME;

    }
}

