/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.common.dto;

import de.proveo.wwt.datamodel.area.Area;
import de.proveo.wwt.datamodel.fis.FISFlight;
import de.proveo.wwt.datamodel.unit.model.UnitModel;
import de.proveo.wwt.datamodel.use.user.UseUser;
import de.proveo.wwt.logic.ejb.interfaces.fis.report.dto.FISReportDTO;
import de.proveo.wwt.logic.web.common.dto.DTOBase;
import de.proveo.wwt.logic.web.common.dto.EventReportDTO;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.common.dto.interfaces.IAreaContainer;
import de.proveo.wwt.logic.web.common.dto.interfaces.IDTOAttachable;
import de.proveo.wwt.logic.web.common.dto.interfaces.IOperatorContainer;
import de.proveo.wwt.logic.web.common.dto.interfaces.IUnitContainer;
import de.proveo.wwt.logic.web.historyData.dto.PositionDTO;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.Interval;

public abstract class ReportDTOBase
extends DTOBase
implements IUnitContainer,
IAreaContainer,
IOperatorContainer {
    protected long id;
    protected List<IDTOAttachable> attachables = new ArrayList<IDTOAttachable>();

    public ReportDTOBase(long id) {
        this.id = id;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public boolean addDTOAttachable(IDTOAttachable attachable) {
        if (attachable == null) {
            return false;
        }
        this.removeDTOAttachable(attachable.getClass());
        return this.attachables.add(attachable);
    }

    public boolean removeDTOAttachable(Class<? extends IDTOAttachable> attachable) {
        if (attachable == UnitDTO.class && this.getUnit() != null) {
            return this.attachables.remove(this.getUnit());
        }
        if (attachable == Area.class && this.getArea() != null) {
            return this.attachables.remove(this.getArea());
        }
        if (attachable == UseUser.class && this.getUseUser() != null) {
            return this.attachables.remove(this.getUseUser());
        }
        if (attachable == PositionDTO.class && this.getPosition() != null) {
            return this.attachables.remove(this.getPosition());
        }
        if (attachable == FISReportDTO.class && this.getFlights() != null) {
            return this.attachables.remove(this.getFlights());
        }
        return false;
    }

    public IDTOAttachable getAttachable(Class<? extends IDTOAttachable> attachable) {
        if (attachable == UnitDTO.class) {
            return this.getUnit();
        }
        if (attachable == Area.class) {
            return this.getArea();
        }
        if (attachable == UseUser.class) {
            return this.getUseUser();
        }
        if (attachable == PositionDTO.class) {
            return this.getPosition();
        }
        if (attachable == FISReportDTO.class) {
            return this.getFlights();
        }
        return null;
    }

    public long getBeginDelay() {
        if (this instanceof EventReportDTO) {
            return ((EventReportDTO)this).getDelay();
        }
        return 0L;
    }

    public long getBeginTime() {
        if (this instanceof EventReportDTO) {
            return ((EventReportDTO)this).getCreateTime();
        }
        return 0L;
    }

    public long getEndDelay() {
        return 0L;
    }

    public long getEndTime() {
        return 0L;
    }

    public long getDuration() {
        return 0L;
    }

    public Interval getInterval() {
        if (this instanceof EventReportDTO) {
            return new Interval(this.getBeginTime(), this.getBeginTime());
        }
        return new Interval(this.getBeginTime(), this.getEndTime());
    }

    public FISReportDTO getFlights() {
        for (IDTOAttachable attachable : this.attachables) {
            if (!(attachable instanceof FISReportDTO)) continue;
            return (FISReportDTO)attachable;
        }
        return null;
    }

    @Override
    public UnitDTO getUnit() {
        for (IDTOAttachable attachable : this.attachables) {
            if (!(attachable instanceof UnitDTO)) continue;
            return (UnitDTO)attachable;
        }
        return null;
    }

    @Override
    public UseUser getUseUser() {
        for (IDTOAttachable attachable : this.attachables) {
            if (!(attachable instanceof UseUser)) continue;
            return (UseUser)attachable;
        }
        return null;
    }

    @Override
    public Area getArea() {
        for (IDTOAttachable attachable : this.attachables) {
            if (!(attachable instanceof Area)) continue;
            return (Area)attachable;
        }
        return null;
    }

    public PositionDTO getPosition() {
        for (IDTOAttachable attachable : this.attachables) {
            if (!(attachable instanceof PositionDTO)) continue;
            return (PositionDTO)attachable;
        }
        return null;
    }

    public List<IDTOAttachable> getAttachables() {
        return this.attachables;
    }

    public FISFlight getInbound() {
        return this.getFlights() == null ? null : this.getFlights().getInbound();
    }

    public FISFlight getOutbound() {
        return this.getFlights() == null ? null : this.getFlights().getOutbound();
    }

    public Long getUnitId() {
        return this.getUnit() == null ? null : this.getUnit().getUnitId();
    }

    public UnitModel getUnitModel() {
        return this.getUnit() == null ? null : this.getUnit().getUnitModel();
    }

    public String getUnitName() {
        return this.getUnit() == null ? null : this.getUnit().getUnitName();
    }

    public String getUseUserName() {
        return this.getUseUser() == null ? null : this.getUseUser().getName();
    }

    public String getUseUserKey() {
        return this.getUseUser() == null ? null : this.getUseUser().getKeyId();
    }

    public String getAreaName() {
        return this.getArea() == null ? null : this.getArea().getName();
    }

    public String getAreaDescription() {
        return this.getArea() == null ? null : this.getArea().getDescription();
    }
}

