/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.common.dto;

import de.proveo.wwt.datamodel.account.Account;
import de.proveo.wwt.datamodel.area.Area;
import de.proveo.wwt.datamodel.infoman.setup.InfomanSetup;
import de.proveo.wwt.datamodel.infoman.setup.InfomanSetupHistory;
import de.proveo.wwt.datamodel.infoman.setup.update.InfomanUpdate;
import de.proveo.wwt.datamodel.infoman.software.InfomanSoftware;
import de.proveo.wwt.datamodel.keepalive.KeepAliveCache;
import de.proveo.wwt.datamodel.measurement.MeasurementDefinition;
import de.proveo.wwt.datamodel.measurement.MeasurementIntervalDefn;
import de.proveo.wwt.datamodel.measurement.MeasurementType;
import de.proveo.wwt.datamodel.measurement.MeasurementUnit;
import de.proveo.wwt.datamodel.scanmanmsg.ScanmanMsgCache;
import de.proveo.wwt.datamodel.scheduledReports.ScheduledReport;
import de.proveo.wwt.datamodel.state.StateBase;
import de.proveo.wwt.datamodel.state.StateCache;
import de.proveo.wwt.datamodel.state.StateHistory;
import de.proveo.wwt.datamodel.unit.identity.UnitIdentity;
import de.proveo.wwt.datamodel.unit.model.UnitModel;
import de.proveo.wwt.datamodel.unit.typeIdentity.UnitTypeIdentity;
import de.proveo.wwt.logic.ejb.general.infoman.setup.InfomanSetupDTO;
import de.proveo.wwt.logic.ejb.general.infoman.setup.InfomanSetupHistoryDTO;
import de.proveo.wwt.logic.ejb.general.infoman.setup.ScheduledInfomanUpdateDTO;
import de.proveo.wwt.logic.ejb.general.scheduledReports.dto.NotificationReportDTO;
import de.proveo.wwt.logic.ejb.general.scheduledReports.dto.OutputFormat;
import de.proveo.wwt.logic.ejb.general.scheduledReports.dto.PageFormat;
import de.proveo.wwt.logic.ejb.general.scheduledReports.dto.PeakModelReportDTO;
import de.proveo.wwt.logic.ejb.general.scheduledReports.dto.PositionReportDTO;
import de.proveo.wwt.logic.ejb.general.scheduledReports.dto.ScheduledReportDTO;
import de.proveo.wwt.logic.ejb.general.scheduledReports.dto.ScheduledUnitReportDTO;
import de.proveo.wwt.logic.ejb.general.scheduledReports.dto.StatusReportDTO;
import de.proveo.wwt.logic.ejb.general.scheduledReports.dto.TimeInterval;
import de.proveo.wwt.logic.ejb.general.scheduledReports.dto.UseUserReportDTO;
import de.proveo.wwt.logic.web.admin.dto.permission.UnitPermissionDTO;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.common.dto.interfaces.IDTOAttachable;
import de.proveo.wwt.logic.web.currentData.dto.CurrentAllDTO;
import de.proveo.wwt.logic.web.currentData.dto.InfomanReportDTO;
import de.proveo.wwt.logic.web.historyData.dto.AccidentReconstructionDTO;
import de.proveo.wwt.logic.web.historyData.dto.FlightDTO;
import de.proveo.wwt.logic.web.historyData.dto.FlightRotationDTO;
import de.proveo.wwt.logic.web.historyData.dto.GseProductivityDTO;
import de.proveo.wwt.logic.web.historyData.dto.KeepAliveDTO;
import de.proveo.wwt.logic.web.historyData.dto.MeasurementDTO;
import de.proveo.wwt.logic.web.historyData.dto.MeasurementIntervalDTO;
import de.proveo.wwt.logic.web.historyData.dto.NotificationDTO;
import de.proveo.wwt.logic.web.historyData.dto.PositionDTO;
import de.proveo.wwt.logic.web.historyData.dto.ScanmanMessageDTO;
import de.proveo.wwt.logic.web.historyData.dto.StateAssignmentDTO;
import de.proveo.wwt.logic.web.historyData.dto.StateDTO;
import de.proveo.wwt.logic.web.historyData.dto.StateDTOList;
import de.proveo.wwt.logic.web.historyData.dto.UseDTO;
import de.proveo.wwt.logic.web.maintenance.dto.MaintenanceForecastDTO;
import de.proveo.wwt.logic.web.summarizedData.dto.RunTimeDurationsDTO;
import de.proveo.wwt.logic.web.summarizedData.dto.StateDurationsDTO;
import de.proveo.wwt.logic.web.summarizedData.dto.SummarizedDTO;
import de.proveo.wwt.logic.web.summarizedData.dto.statusPeak.StatusPeakDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DTOFactory {
    private static final Log log = LogFactory.getLog(DTOFactory.class);

    public static final RunTimeDurationsDTO buildRunTimeDurationsDTO(long unitOffsetMillis, long beginTime, IDTOAttachable ... attachables) {
        RunTimeDurationsDTO dto = new RunTimeDurationsDTO(unitOffsetMillis, beginTime);
        for (IDTOAttachable attachable : attachables) {
            dto.addDTOAttachable(attachable);
        }
        return dto;
    }

    public static final StateDurationsDTO buildStateDurationsDTO(int stateModelId, long beginTime, IDTOAttachable ... attachables) {
        StateDurationsDTO dto = new StateDurationsDTO(stateModelId, beginTime);
        for (IDTOAttachable attachable : attachables) {
            dto.addDTOAttachable(attachable);
        }
        return dto;
    }

    public static final SummarizedDTO buildSummarizedDTO(UnitDTO unitDTO) {
        SummarizedDTO dto = new SummarizedDTO(unitDTO);
        return dto;
    }

    public static final KeepAliveDTO buildKeepAliveDTO(long id, long createTime, long receiveTime, Boolean timedOut, IDTOAttachable ... attachables) {
        KeepAliveDTO dto = new KeepAliveDTO(id, createTime, receiveTime, timedOut);
        for (IDTOAttachable attachable : attachables) {
            dto.addDTOAttachable(attachable);
        }
        if (dto.getUnit() == null) {
            throw new RuntimeException("No Unit Added");
        }
        return dto;
    }

    public static final ScanmanMessageDTO buildScanmanMessageDTO(long id, long createTime, long receiveTime, int type, String message, IDTOAttachable ... attachables) {
        ScanmanMessageDTO dto = new ScanmanMessageDTO(id, createTime, receiveTime, type, message);
        for (IDTOAttachable attachable : attachables) {
            dto.addDTOAttachable(attachable);
        }
        if (dto.getUnit() == null) {
            throw new RuntimeException("No Unit Added");
        }
        return dto;
    }

    public static final NotificationDTO buildNotificationDTO(long id, long createTime, long receiveTime, long messageId, String remark, IDTOAttachable ... attachables) {
        NotificationDTO dto = new NotificationDTO(id, createTime, receiveTime, messageId, remark);
        for (IDTOAttachable attachable : attachables) {
            dto.addDTOAttachable(attachable);
        }
        if (dto.getUnit() == null) {
            throw new RuntimeException("No Unit Added");
        }
        return dto;
    }

    public static final PositionDTO buildPositionDTO(long id, long beginTime, long endTime, long beginReceiveTime, long endReceiveTime, long actualBeginTime, long actualEndTime, boolean trusted, String ggaRec, int latMSEC, int longMSEC, String rmcRec, String reason, String area, String areaDescr, IDTOAttachable ... attachables) {
        PositionDTO dto = new PositionDTO(id, beginTime, endTime, beginReceiveTime, endReceiveTime, actualBeginTime, actualEndTime, trusted, ggaRec, latMSEC, longMSEC, rmcRec, reason, area, areaDescr);
        for (IDTOAttachable attachable : attachables) {
            dto.addDTOAttachable(attachable);
        }
        if (dto.getUnit() == null) {
            throw new RuntimeException("No Unit Added");
        }
        return dto;
    }

    public static final StateDTO buildStateDTO(long id, long beginTime, long endTime, long beginReceiveTime, long endReceiveTime, long actualBeginTime, long actualEndTime, int stateId, int stateModelId, int stateIdAfter, String remark, Area beginArea, Area endArea, boolean beginTrusted, boolean endTrusted, IDTOAttachable ... attachables) {
        StateDTO dto = new StateDTO(id, beginTime, endTime, beginReceiveTime, endReceiveTime, actualBeginTime, actualEndTime, stateId, stateIdAfter, stateModelId, remark, beginArea, endArea, beginTrusted, endTrusted);
        for (IDTOAttachable attachable : attachables) {
            dto.addDTOAttachable(attachable);
        }
        if (dto.getUnit() == null) {
            throw new RuntimeException("No Unit Added");
        }
        return dto;
    }

    public static final MeasurementIntervalDTO buildMeasurementIntervalDTO(long id, long beginTime, long endTime, float measurementFrom, float measurementTo, MeasurementIntervalDefn mid, MeasurementDefinition md, MeasurementType mt, MeasurementUnit mu, IDTOAttachable ... attachables) {
        MeasurementIntervalDTO dto = new MeasurementIntervalDTO(id, beginTime, endTime, measurementFrom, measurementTo, mid, md, mt, mu);
        for (IDTOAttachable attachable : attachables) {
            dto.addDTOAttachable(attachable);
        }
        if (dto.getUnit() == null) {
            throw new RuntimeException("No Unit Added");
        }
        return dto;
    }

    public static final StateDTO buildPeakDetailDTO(long beginTime, long endTime, int stateId, int stateModelId, IDTOAttachable ... attachables) {
        return DTOFactory.buildStateDTO(0L, beginTime, endTime, 0L, 0L, beginTime, endTime, stateId, stateModelId, 0, null, null, null, false, false, attachables);
    }

    public static final UseDTO buildUseDTO(long id, long beginTime, long endTime, long beginReceiveTime, long endReceiveTime, long actualBeginTime, long actualEndTime, Area beginArea, Area endArea, IDTOAttachable ... attachables) {
        UseDTO dto = new UseDTO(id, beginTime, endTime, beginReceiveTime, endReceiveTime, actualBeginTime, actualEndTime, beginArea, endArea);
        for (IDTOAttachable attachable : attachables) {
            dto.addDTOAttachable(attachable);
        }
        if (dto.getUnit() == null) {
            throw new RuntimeException("No Unit Added");
        }
        return dto;
    }

    public static final MeasurementDTO buildMeasurementDTO(long id, long createTime, long receiveTime, Float value, MeasurementDefinition measurementDefinition, MeasurementType measurementType, MeasurementUnit measurementUnit, IDTOAttachable ... attachables) {
        MeasurementDTO dto = new MeasurementDTO(id, createTime, receiveTime, value, measurementDefinition, measurementType, measurementUnit);
        for (IDTOAttachable attachable : attachables) {
            dto.addDTOAttachable(attachable);
        }
        if (dto.getUnit() == null) {
            throw new RuntimeException("No Unit Added");
        }
        return dto;
    }

    public static final AccidentReconstructionDTO buildAccidentReconstructionDTO(UnitModel unitModel, NotificationDTO notificationDTO, StateDTO stateDTO, PositionDTO positionDTO, long totalRuntimeHours) {
        AccidentReconstructionDTO dto = new AccidentReconstructionDTO(notificationDTO, stateDTO, positionDTO, totalRuntimeHours);
        dto.addDTOAttachable(DTOFactory.buildUnitDTO(unitModel));
        if (dto.getUnit() == null) {
            throw new RuntimeException("No Unit Added");
        }
        return dto;
    }

    public static final InfomanSetupHistoryDTO buildInfomanSetupHistoryDTO(UnitModel unitModel, InfomanSetupHistory history) {
        InfomanSetupHistoryDTO dto = new InfomanSetupHistoryDTO(history);
        dto.addDTOAttachable(DTOFactory.buildUnitDTO(unitModel));
        if (dto.getUnit() == null) {
            throw new RuntimeException("No Unit Added");
        }
        return dto;
    }

    public static final MaintenanceForecastDTO buildMaintenanceForecastDTO(UnitModel unitModel, long totalRuntime, long availableRuntime, boolean overdue, float averageRuntime, int daysToMaintenance, long dateForMaintenance) {
        MaintenanceForecastDTO dto = new MaintenanceForecastDTO(DTOFactory.buildUnitDTO(unitModel), totalRuntime, availableRuntime, overdue, averageRuntime, daysToMaintenance, dateForMaintenance);
        return dto;
    }

    public static final InfomanSetupDTO buildInfomanSetupDTO(UnitModel unitModel, InfomanSetup infomanSetup) {
        InfomanSetupDTO dto = new InfomanSetupDTO(DTOFactory.buildUnitDTO(unitModel), infomanSetup);
        return dto;
    }

    public static final CurrentAllDTO buildCurrentAllDTO(UnitModel unitModel) {
        CurrentAllDTO dto = new CurrentAllDTO(DTOFactory.buildUnitDTO(unitModel));
        return dto;
    }

    public static final ScheduledInfomanUpdateDTO buildScheduledInfomanUpdateDTO(UnitModel unitModel, InfomanUpdate infomanUpdate, InfomanSoftware infomanSoftware) {
        ScheduledInfomanUpdateDTO dto = new ScheduledInfomanUpdateDTO(DTOFactory.buildUnitDTO(unitModel), infomanUpdate, infomanSoftware);
        return dto;
    }

    public static final InfomanReportDTO buildInfomanReportDTO(UnitModel unitModel, KeepAliveCache keepAliveCache, Collection<ScanmanMsgCache> scanmanMsgs) {
        InfomanReportDTO dto = new InfomanReportDTO(DTOFactory.buildUnitDTO(unitModel), keepAliveCache, scanmanMsgs);
        return dto;
    }

    public static final UnitPermissionDTO buildUnitPermissionDTO(UnitDTO unitDTO) {
        UnitPermissionDTO dto = new UnitPermissionDTO(unitDTO);
        return dto;
    }

    public static final UnitPermissionDTO buildUnitPermissionDTO(UnitModel unitModel) {
        UnitPermissionDTO dto = new UnitPermissionDTO(DTOFactory.buildUnitDTO(unitModel));
        return dto;
    }

    public static final StatusPeakDTO buildStatusPeakDTO(int stateModelId, int stateId, long duration, long beginTime, long endTime, long count, List<UnitDTO> units) {
        StatusPeakDTO dto = new StatusPeakDTO(stateModelId, stateId, duration, beginTime, endTime, count, units);
        return dto;
    }

    public static final ScheduledReportDTO buildScheduledReportDTO(ScheduledReport report) {
        ScheduledUnitReportDTO dto = null;
        ScheduledReport value = report;
        String design = value.getReportDesign();
        String reportType = value.getReportType();
        String emails = value.getEmails();
        Locale locale = new Locale(value.getLocale());
        OutputFormat outPutFormat = OutputFormat.valueOf(value.getOutputFormat());
        PageFormat pageFormat = null;
        if (value.getPageFormat() != null) {
            pageFormat = PageFormat.valueOf(value.getPageFormat());
        }
        String reportName = value.getReportName();
        long createTime = value.getCreateTime();
        TimeInterval timeInterval = TimeInterval.valueOf(value.getTimeInterval());
        HashMap<String, String> reportParamsMap = new HashMap<String, String>();
        String reportParameters = value.getReportParameters();
        String[] params = reportParameters.split(";");
        for (int i = 0; i < params.length; ++i) {
            String[] values = params[i].split("=");
            String paramName = values[0];
            String paramValue = values[1];
            reportParamsMap.put(paramName, paramValue);
        }
        ArrayList<Account> accountList = new ArrayList<Account>();
        List<Account> accounts = report.getAccounts();
        for (Account acc : accounts) {
            accountList.add(acc);
        }
        if (reportType.equalsIgnoreCase("status")) {
            dto = new StatusReportDTO(reportType, reportName, design, reportParamsMap, outPutFormat, pageFormat, locale, timeInterval, accountList, emails, createTime);
        } else if (reportType.equalsIgnoreCase("summarizedStatus")) {
            dto = new StatusReportDTO(reportType, reportName, design, reportParamsMap, outPutFormat, pageFormat, locale, timeInterval, accountList, emails, createTime);
        } else if (reportType.equalsIgnoreCase("notification")) {
            dto = new NotificationReportDTO(reportType, reportName, design, reportParamsMap, outPutFormat, pageFormat, locale, timeInterval, accountList, emails, createTime);
        } else if (reportType.equalsIgnoreCase("useUser")) {
            dto = new UseUserReportDTO(reportType, reportName, design, reportParamsMap, outPutFormat, pageFormat, locale, timeInterval, accountList, emails, createTime);
        } else if (reportType.equalsIgnoreCase("position")) {
            dto = new PositionReportDTO(reportType, reportName, design, reportParamsMap, outPutFormat, pageFormat, locale, timeInterval, accountList, emails, createTime);
        } else if (reportType.equalsIgnoreCase("peakModel")) {
            dto = new PeakModelReportDTO(reportType, reportName, design, reportParamsMap, outPutFormat, pageFormat, locale, timeInterval, accountList, emails, createTime);
        }
        if (dto == null) {
            log.error((Object)("no report type available for: " + reportType));
        }
        dto.setId(report.getId());
        return dto;
    }

    public static final UnitDTO buildUnitDTO() {
        return new UnitDTO(null, null, null);
    }

    public static final UnitDTO buildUnitDTO(UnitModel unitModel, UnitIdentity unitIdentity, UnitTypeIdentity unitTypeIdentity) {
        return new UnitDTO(unitModel, unitIdentity, unitTypeIdentity);
    }

    public static final UnitDTO buildUnitDTO(UnitModel model) {
        if (model == null) {
            return null;
        }
        return new UnitDTO(model, model.getUnitIdentity(), model.getUnitTypeIdentity());
    }

    public static final UnitDTO buildUnitDTO(UnitIdentity unitIdentity) {
        UnitModel unitModel = unitIdentity.getUnitModel();
        UnitTypeIdentity unitTypeIdentity = null;
        if (unitModel.getBasic()) {
            unitTypeIdentity = unitModel.getUnitTypeIdentity();
        }
        return new UnitDTO(unitModel, unitIdentity, unitTypeIdentity);
    }

    public static final GseProductivityDTO buildGseProductivityDTO(UnitModel unitModel, FlightRotationDTO rotation, ArrayList<StateDTOList> arrStateDTOList, Long duration2012, Long duration2013) {
        return new GseProductivityDTO(DTOFactory.buildUnitDTO(unitModel), rotation, arrStateDTOList, duration2012, duration2013);
    }

    public static final FlightDTO buildFlightDTO(Object flight, int gseArrivalSetupStartTime, int gseArrivalSetupEndTimePax, int gseArrivalSetupEndTimeCgo, int gseDepartureSetupStartTime, int gseDepartureSetupEndTime) {
        FlightDTO flightDTO = null;
        return flightDTO;
    }

    public static final FlightDTO buildFlightDTO(int gseArrivalSetupStartTime, int gseArrivalSetupEndTimePax, int gseArrivalSetupEndTimeCgo, int gseDepartureSetupStartTime, int gseDepartureSetupEndTime) {
        return new FlightDTO();
    }

    public static final FlightRotationDTO buildFlightRotationDTO(ArrayList<FlightDTO> rotation) {
        return new FlightRotationDTO(rotation);
    }

    public static final StateAssignmentDTO buildStateAssignmentDTO(FlightRotationDTO rotation, StateBase stateAssignment) {
        if (stateAssignment instanceof StateCache) {
            StateCache cache = (StateCache)stateAssignment;
            return new StateAssignmentDTO(rotation, DTOFactory.buildStateDTO(cache.getHistoryId(), cache.getBeginTime(), 0L, cache.getBeginReceiveTime(), 0L, cache.getBeginTime(), 0L, cache.getStateId(), cache.getStateModelId(), 0, cache.getRemark(), cache.getArea(), null, cache.getAreaTrusted(), false, DTOFactory.buildUnitDTO(cache.getUnitModel())));
        }
        if (stateAssignment instanceof StateHistory) {
            StateHistory history = (StateHistory)stateAssignment;
            return new StateAssignmentDTO(rotation, DTOFactory.buildStateDTO(history.getId(), history.getBeginTime(), history.getEndTime(), history.getBeginReceiveTime(), history.getEndReceiveTime(), history.getBeginTime(), history.getEndTime(), history.getStateId(), history.getStateModelId(), 0, history.getRemark(), history.getArea(), null, history.getAreaTrusted(), false, DTOFactory.buildUnitDTO(history.getUnitModel())));
        }
        return null;
    }
}

