/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.common.dataSelection.filter;

import de.proveo.wwt.datamodel.shift.Shift;
import de.proveo.wwt.datamodel.shift.ShiftDefn;
import de.proveo.wwt.logic.web.common.dataSelection.filter.ITimeFilter;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateMidnight;
import org.joda.time.Interval;

public class ShiftTimeFilter
implements ITimeFilter {
    private List<ShiftDefn> shiftDefns = new ArrayList<ShiftDefn>();

    public ShiftTimeFilter(List<ShiftDefn> list) {
        this.shiftDefns = list;
    }

    @Override
    public Interval[] getIntervals(long beginTime, long endTime) {
        ArrayList<Interval> intervalArray = new ArrayList<Interval>();
        for (ShiftDefn shiftDefn : this.shiftDefns) {
            ArrayList shiftLists = new ArrayList(shiftDefn.getShifts());
            shiftLists = (ArrayList)shiftLists.clone();
            DateMidnight dt = new DateMidnight(beginTime);
            int i = 0;
            while (dt.getMillis() < endTime) {
                while (i < shiftLists.size()) {
                    Shift shift = (Shift)shiftLists.get(i);
                    int dayOfweek = dt.getDayOfWeek();
                    long shiftBeginTime = dt.getMillis() + shift.getBeginTime();
                    long shiftEndTime = shiftBeginTime + (long)shift.getDuration();
                    if (dayOfweek == shift.getDayOfWeek() && shiftEndTime > beginTime && shiftBeginTime < endTime) {
                        Interval interval = new Interval(Math.max(shiftBeginTime, beginTime), Math.min(shiftEndTime, endTime));
                        intervalArray.add(interval);
                    }
                    ++i;
                }
                dt = dt.plusDays(1);
                i = 0;
            }
        }
        Interval[] intervals = new Interval[intervalArray.size()];
        return intervalArray.toArray(intervals);
    }
}

