/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.common.dataSelection.filter;

import de.proveo.wwt.logic.web.common.dataSelection.filter.IDataFilter;
import de.proveo.wwt.logic.web.common.dataSelection.filter.StateFilter;
import de.proveo.wwt.logic.web.common.dataSelection.filter.StateModelFilter;
import de.proveo.wwt.logic.web.common.dto.ReportDTOBase;
import de.proveo.wwt.logic.web.currentData.dto.CurrentAllDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class AbstractDataFilter<T extends ReportDTOBase>
implements IDataFilter {
    public static boolean checkCurrentAllDTO(CurrentAllDTO dto, IDataFilter filter) {
        if (filter instanceof StateFilter) {
            for (Map.Entry<Integer, List<Integer>> entry : ((StateFilter)filter).getMap().entrySet()) {
                Integer smId = entry.getKey();
                if (dto.getStates().get(smId) != null && entry.getValue().contains(dto.getStates().get(smId).getStateId())) continue;
                return false;
            }
        }
        if (filter instanceof StateModelFilter) {
            ArrayList<Integer> dtoStates = new ArrayList<Integer>();
            dtoStates.addAll(dto.getStates().keySet());
            return dtoStates.containsAll(filter.getObjects());
        }
        return true;
    }

    public static boolean checkCurrentAllDTO(CurrentAllDTO dto, List<IDataFilter> filters) {
        if (filters == null) {
            return true;
        }
        for (IDataFilter filter : filters) {
            if (AbstractDataFilter.checkCurrentAllDTO(dto, filter)) continue;
            return false;
        }
        return true;
    }
}

