/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.common.dataSelection;

import de.proveo.wwt.datamodel.use.group.UseGroup;
import de.proveo.wwt.datamodel.use.user.UseUser;
import de.proveo.wwt.logic.web.common.dataSelection.ReportSelectionDTO;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.Interval;

public class OperatorReportSelectionDTO
extends ReportSelectionDTO {
    private List<UseUser> operators = new ArrayList<UseUser>();
    private List<UseGroup> operatorGroups = new ArrayList<UseGroup>();

    public OperatorReportSelectionDTO(Interval interval, List<UseUser> operators, List<UseGroup> operatorGroups) {
        super(interval);
        if (operatorGroups != null) {
            this.operatorGroups = operatorGroups;
        }
        if (operators != null) {
            this.operators = operators;
        }
    }

    @Override
    public boolean isBasic() {
        return this.operators.size() == 1 && this.operatorGroups.isEmpty();
    }

    @Override
    public boolean isAllSelected() {
        return !this.isBasic() && this.getCount() == 1 && this.operatorGroups.get(0).getId() == 0L;
    }

    @Override
    public int getCount() {
        return this.operatorGroups.size() + this.operators.size();
    }

    public List<UseUser> getOperators() {
        return this.operators;
    }

    public List<UseGroup> getOperatorGroups() {
        return this.operatorGroups;
    }

    public Long[] getOperatorIds() {
        Long[] ids = new Long[this.operators.size()];
        for (int i = 0; i < this.operators.size(); ++i) {
            UseUser dto = this.operators.get(i);
            ids[i] = dto.getId();
        }
        return ids;
    }

    public Long[] getOperatorGroupIds() {
        if (this.operatorGroups.size() == 1 && this.operatorGroups.get(0).getId() == 0L) {
            return new Long[0];
        }
        Long[] ids = new Long[this.operatorGroups.size()];
        for (int i = 0; i < this.operatorGroups.size(); ++i) {
            UseGroup dto = this.operatorGroups.get(i);
            ids[i] = dto.getId();
        }
        return ids;
    }

    @Override
    public ReportSelectionDTO copy() {
        return new OperatorReportSelectionDTO(this.interval, this.operators, this.operatorGroups);
    }

    @Override
    public String getName() {
        StringBuilder result = new StringBuilder();
        if (this.getCount() == 0) {
            return "all";
        }
        if (this.getCount() > 1) {
            return "multi";
        }
        if (this.isBasic()) {
            result.append(this.operators.get(0).getName());
        } else {
            result.append(this.operatorGroups.get(0).getName());
        }
        return result.toString();
    }
}

