/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces.telemetryData.util;

import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.wwt.datamodel.geo.GdataCache;
import de.proveo.wwt.datamodel.notify.NotifyHistory;
import de.proveo.wwt.datamodel.state.StateCache;
import de.proveo.wwt.datamodel.state.StateHistory;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.UnitHelper;
import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessageHelper {
    private static final Log log = LogFactory.getLog(MessageHelper.class);

    public static SerializableEventWrapper getSerializableEventWrapper(Message msg) {
        try {
            Serializable _object = ((ObjectMessage)msg).getObject();
            SerializableEventWrapper wrapper = (SerializableEventWrapper)_object;
            return wrapper;
        }
        catch (JMSException e) {
            log.error((Object)"runs into", (Throwable)e);
            return null;
        }
    }

    public static long getMessageId(Message msg) {
        SerializableEventWrapper wrapper = MessageHelper.getSerializableEventWrapper(msg);
        Object history = wrapper.get_historyValue();
        Object cache = wrapper.get_cacheValue();
        if (wrapper.get_typeOfEvent().equals("GeoStructHistoryAndCache") && cache != null && cache instanceof GdataCache) {
            return ((GdataCache)cache).getHistoryId();
        }
        if (wrapper.get_typeOfEvent().equals("StateEventHistoryAndCache") && history != null && history instanceof StateHistory) {
            return ((StateHistory)history).getId();
        }
        if (wrapper.get_typeOfEvent().equals("InfomanNotifyMessages") && history != null && history instanceof NotifyHistory) {
            return ((NotifyHistory)history).getId();
        }
        return 0L;
    }

    public static boolean isSendData(Message msg) {
        SerializableEventWrapper wrapper = MessageHelper.getSerializableEventWrapper(msg);
        if (wrapper.get_typeOfEvent().equals("GeoStructHistoryAndCache")) {
            GdataCache geo = (GdataCache)wrapper.get_cacheValue();
            return UnitHelper.isSendData(geo.getUnitId());
        }
        if (wrapper.get_typeOfEvent().equals("StateEventHistoryAndCache")) {
            StateCache stateCache = (StateCache)wrapper.get_cacheValue();
            return UnitHelper.isSendData(stateCache.getPk().getUnitId());
        }
        if (wrapper.get_typeOfEvent().equals("InfomanNotifyMessages")) {
            NotifyHistory stateHistory = (NotifyHistory)wrapper.get_historyValue();
            return UnitHelper.isSendData(stateHistory.getUnitId());
        }
        log.error((Object)"the message contains an invalid event type");
        return false;
    }
}

