/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces.telemetryData.tto;

import de.proveo.util.geo.GPSPosition;
import de.proveo.wwt.datamodel.fis.FISFlight;
import de.proveo.wwt.datamodel.geo.GdataHistory;
import de.proveo.wwt.datamodel.state.StateHistory;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.tto.TTO;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.Enums;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.UnitHelper;
import de.proveo.wwt.logic.web.historyData.dto.StateDTO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StateTTO
extends TTO {
    private static final Log log = LogFactory.getLog(StateTTO.class);
    protected long stateModelId;
    protected long prevStateId;
    protected long currStateId;
    protected long prevBeginTime;
    protected long currBeginTime;
    private String prevArea;
    private Double prevLatitude;
    private Double prevLongitude;
    protected Double currLatitude;
    protected Double currLongitude;
    protected String currArea;
    private String prevFLNInb;
    private String prevFLNOutb;
    private String currFLNInb;
    private String currFLNOutb;

    public StateTTO(StateHistory stateHistory) {
        this.stateModelId = stateHistory.getStateModelId();
        this.currStateId = stateHistory.getStateIdNext().intValue();
        this.prevStateId = stateHistory.getStateId();
        this.prevBeginTime = stateHistory.getBeginTime();
        this.currBeginTime = stateHistory.getEndTime();
        this.historyId = stateHistory.getId();
        this.unitId = stateHistory.getUnitId();
        if (this.unitId > 0L) {
            this.customerUnitId = UnitHelper.getCustomerUnitId(this.unitId);
            this.unitName = UnitHelper.getUnitName(this.unitId);
            this.modelType = UnitHelper.getModelType(this.unitId);
        }
        this.eventType = Enums.EventType.STATE;
    }

    public StateTTO(StateDTO stateDTO) {
        this.stateModelId = stateDTO.getStateModelId();
        this.currStateId = stateDTO.getStateIdAfter();
        this.prevStateId = stateDTO.getStateId();
        this.currBeginTime = stateDTO.getEndTime();
        this.prevBeginTime = stateDTO.getBeginTime();
        this.historyId = stateDTO.getId();
        if (stateDTO.getUnitId() != null) {
            this.unitId = stateDTO.getUnitId();
            this.customerUnitId = UnitHelper.getCustomerUnitId(this.unitId);
            this.unitName = UnitHelper.getUnitName(this.unitId);
            this.modelType = UnitHelper.getModelType(this.unitId);
        }
        this.eventType = Enums.EventType.STATE;
    }

    public void setPrevGeo(GdataHistory geo) {
        if (geo != null) {
            if (geo.getArea() != null) {
                this.prevArea = geo.getArea().getArea();
            }
            GPSPosition gps = new GPSPosition(geo.getRmcRec(), geo.getGgaRec(), geo.getTrusted());
            double latitude = (double)gps.getLatitudeMSec() / 3600000.0;
            double longitude = (double)gps.getLongitudeMSec() / 3600000.0;
            this.prevLatitude = this.round(latitude, 6);
            this.prevLongitude = this.round(longitude, 6);
        }
    }

    public void setCurrGeo(GdataHistory geo) {
        if (geo != null) {
            if (geo.getArea() != null) {
                this.currArea = geo.getArea().getArea();
            }
            GPSPosition gps = new GPSPosition(geo.getRmcRec(), geo.getGgaRec(), geo.getTrusted());
            double latitude = (double)gps.getLatitudeMSec() / 3600000.0;
            double longitude = (double)gps.getLongitudeMSec() / 3600000.0;
            this.currLatitude = this.round(latitude, 6);
            this.currLongitude = this.round(longitude, 6);
        }
    }

    public void setCurrFlights(FISFlight inbound, FISFlight outbound) {
        if (inbound != null) {
            this.currFLNInb = inbound.getFlightNumber();
        }
        if (outbound != null) {
            this.currFLNOutb = outbound.getFlightNumber();
        }
    }

    public void setPrevFlights(FISFlight inbound, FISFlight outbound) {
        if (inbound != null) {
            this.prevFLNInb = inbound.getFlightNumber();
        }
        if (outbound != null) {
            this.prevFLNOutb = outbound.getFlightNumber();
        }
    }

    public long getStateModelId() {
        return this.stateModelId;
    }

    public void setStateModelId(long stateModelId) {
        this.stateModelId = stateModelId;
    }

    public long getPrevStateId() {
        return this.prevStateId;
    }

    public void setPrevStateId(long prevStateId) {
        this.prevStateId = prevStateId;
    }

    public long getCurrStateId() {
        return this.currStateId;
    }

    public void setCurrStateId(long currStateId) {
        this.currStateId = currStateId;
    }

    public long getPrevBeginTime() {
        return this.prevBeginTime;
    }

    public void setPrevBeginTime(long prevBeginTime) {
        this.prevBeginTime = prevBeginTime;
    }

    public long getCurrBeginTime() {
        return this.currBeginTime;
    }

    public void setCurrBeginTime(long currBeginTime) {
        this.currBeginTime = currBeginTime;
    }

    public String getPrevArea() {
        return this.prevArea;
    }

    public void setPrevArea(String prevArea) {
        this.prevArea = prevArea;
    }

    public Double getPrevLatitude() {
        return this.prevLatitude;
    }

    public void setPrevLatitude(Double prevLatitude) {
        this.prevLatitude = prevLatitude;
    }

    public Double getPrevLongitude() {
        return this.prevLongitude;
    }

    public void setPrevLongitude(Double prevLongitude) {
        this.prevLongitude = prevLongitude;
    }

    public Double getCurrLatitude() {
        return this.currLatitude;
    }

    public void setCurrLatitude(Double currLatitude) {
        this.currLatitude = currLatitude;
    }

    public Double getCurrLongitude() {
        return this.currLongitude;
    }

    public void setCurrLongitude(Double currLongitude) {
        this.currLongitude = currLongitude;
    }

    public String getCurrArea() {
        return this.currArea;
    }

    public void setCurrArea(String currArea) {
        this.currArea = currArea;
    }

    public String getPrevFLNInb() {
        return this.prevFLNInb;
    }

    public void setPrevFLNInb(String prevFLNInb) {
        this.prevFLNInb = prevFLNInb;
    }

    public String getPrevFLNOutb() {
        return this.prevFLNOutb;
    }

    public void setPrevFLNOutb(String prevFLNOutb) {
        this.prevFLNOutb = prevFLNOutb;
    }

    public String getCurrFLNInb() {
        return this.currFLNInb;
    }

    public void setCurrFLNInb(String currFLNInb) {
        this.currFLNInb = currFLNInb;
    }

    public String getCurrFLNOutb() {
        return this.currFLNOutb;
    }

    public void setCurrFLNOutb(String currFLNOutb) {
        this.currFLNOutb = currFLNOutb;
    }
}

