/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces.telemetryData.handler;

import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.wwt.datamodel.fis.FISFlight;
import de.proveo.wwt.datamodel.fis.StandStateHistory;
import de.proveo.wwt.datamodel.geo.GdataHistory;
import de.proveo.wwt.datamodel.module.Module;
import de.proveo.wwt.datamodel.module.ModuleType;
import de.proveo.wwt.datamodel.state.StateHistory;
import de.proveo.wwt.logic.app.module.ModuleFacadeLocal;
import de.proveo.wwt.logic.app.resource.ResourceFacadeLocal;
import de.proveo.wwt.logic.app.util.Stopwatch;
import de.proveo.wwt.logic.ejb.geo.GdataFacadeLocal;
import de.proveo.wwt.logic.ejb.interfaces.fis.FISFacadeLocal;
import de.proveo.wwt.logic.ejb.interfaces.fis.standState.StandStateFacadeLocal;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.exceptions.MessageNotSentException;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.exceptions.TOWhileSyncException;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.exceptions.TooMuchDataException;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.exceptions.UnknownStateException;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.exceptions.UnknownStateModelException;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.handler.AbstractHandler;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.tto.StateTTO;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.Enums;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.TDIConfiguration;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.TDITimestamp;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.UnitHelper;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.BeginStockPart;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.EndStockPart;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.TelemetryDataMessage;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.TelemetryDataMessages;
import de.proveo.wwt.logic.ejb.state.StateOutFacadeLocal;
import de.proveo.wwt.logic.web.data.fastlanereader.TelemetryFastLaneReader;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.ejb.FinderException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StateHandler
extends AbstractHandler {
    private static final Log log = LogFactory.getLog(StateHandler.class);
    private TDIConfiguration config = TDIConfiguration.getInstance();
    private static StateHandler stateHandler = null;
    private boolean discardOldMessages = false;
    private boolean synchronizing = false;
    private long lastSentMessageId = -1L;
    private TelemetryFastLaneReader fastLaneTelemetry = new TelemetryFastLaneReader();
    private StateOutFacadeLocal stateOutFacade = null;
    private GdataFacadeLocal gdataFacade = null;
    private ResourceFacadeLocal resourceFacade = null;
    private StandStateFacadeLocal standStateFacadeLocal = null;
    private ModuleFacadeLocal moduleFacade = null;
    private FISFacadeLocal fisFacadeLocal = null;
    private ResourceBundle resourceBundle = null;

    private StateHandler() {
        try {
            InitialContext ctx = new InitialContext();
            this.stateOutFacade = (StateOutFacadeLocal)ctx.lookup("rts/StateOutFacade/local");
            this.gdataFacade = (GdataFacadeLocal)ctx.lookup("rts/GdataFacade/local");
            this.standStateFacadeLocal = (StandStateFacadeLocal)ctx.lookup("wwt/StandStateFacade/local");
            this.fisFacadeLocal = (FISFacadeLocal)ctx.lookup("wwt/FISFacade/local");
            this.resourceFacade = (ResourceFacadeLocal)ctx.lookup("rts/ResourceFacade/local");
            this.moduleFacade = (ModuleFacadeLocal)ctx.lookup("rts/ModuleFacade/local");
        }
        catch (NamingException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        this.readResourceBundle();
    }

    public static StateHandler getInstance() {
        if (stateHandler == null) {
            stateHandler = new StateHandler();
        }
        return stateHandler;
    }

    @Override
    public void handleEvent(SerializableEventWrapper wrapper) throws MessageNotSentException {
        log.debug((Object)"handleEvent()");
        log.debug((Object)("cache value: " + wrapper.get_cacheValue()));
        log.debug((Object)("history value: " + wrapper.get_historyValue()));
        StateHistory stateHistory = null;
        if (wrapper.get_historyValue() instanceof StateHistory) {
            stateHistory = (StateHistory)wrapper.get_historyValue();
        }
        if (this.resourceBundle == null) {
            this.readResourceBundle();
        }
        if (stateHistory != null) {
            if (stateHistory.getEndTime() != 0L) {
                boolean sendData = UnitHelper.isSendData(stateHistory.getUnitId());
                if (sendData) {
                    try {
                        StateTTO stateTTO = new StateTTO(stateHistory);
                        this.addGeo(stateTTO);
                        this.addFlights(stateTTO);
                        TelemetryDataMessage xmlMsg = new TelemetryDataMessage(stateTTO, this.resourceBundle);
                        long messageID = stateHistory.getId();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("handleEvent() - messageId: " + messageID + " unitId: " + stateHistory.getUnitId()));
                        }
                        this.sendTextMessage(xmlMsg.toString());
                    }
                    catch (UnknownStateModelException e) {
                        log.debug((Object)(e.getMessage() + " - message is not sent"));
                    }
                    catch (UnknownStateException e) {
                        log.debug((Object)(e.getMessage() + " - message is not sent"));
                    }
                    catch (Exception e) {
                        log.error((Object)"runs into", (Throwable)e);
                        throw new MessageNotSentException();
                    }
                } else if (log.isTraceEnabled()) {
                    log.trace((Object)("status event " + stateHistory.getId() + " not sent for unit: " + stateHistory.getUnitId()));
                }
            } else {
                log.debug((Object)("don't send state event " + stateHistory.getId() + " because currBeginTime is empty!"));
            }
        } else {
            log.error((Object)"stateHistoryValue is null");
        }
    }

    private void addGeo(StateTTO stateTTO) {
        GdataHistory prevGeo = null;
        GdataHistory currGeo = null;
        if (stateTTO.getHistoryId() != 0L) {
            if (this.config.getBoolean("xml.telemetryDataMessage.stateField.currCoords.active") || this.config.getBoolean("xml.telemetryDataMessage.stateField.currArea.active")) {
                long endTime = stateTTO.getCurrBeginTime();
                currGeo = this.gdataFacade.findGdataHistoryByUnitIdAndBeginTime(stateTTO.getUnitId(), endTime);
                if (currGeo == null) {
                    log.debug((Object)("could not find current geo struct for stateHistory: " + stateTTO.getHistoryId()));
                }
            }
            stateTTO.setCurrGeo(currGeo);
            if (this.config.getBoolean("xml.telemetryDataMessage.stateField.prevCoords.active") || this.config.getBoolean("xml.telemetryDataMessage.stateField.prevArea.active")) {
                long prevBegintime = stateTTO.getPrevBeginTime();
                prevGeo = this.gdataFacade.findGdataHistoryByUnitIdAndBeginTime(stateTTO.getUnitId(), prevBegintime);
                if (prevGeo == null) {
                    log.debug((Object)("could not find previous geo struct for stateHistory: " + stateTTO.getHistoryId()));
                }
            }
            stateTTO.setPrevGeo(prevGeo);
        }
    }

    private void addFlights(StateTTO stateTTO) {
        log.debug((Object)"addFlights()");
        if (stateTTO.getHistoryId() != 0L) {
            FISFlight pairFlight;
            String uniqueFlightNumber;
            FISFlight flight;
            List<StandStateHistory> standStates;
            if (this.config.getBoolean("xml.telemetryDataMessage.stateField.currFlights.active")) {
                if (stateTTO.getCurrArea() != null) {
                    standStates = this.standStateFacadeLocal.findStandStateHistoryForStandAndStateModelTimestamp(stateTTO.getCurrArea(), 1010L, stateTTO.getCurrBeginTime());
                    log.debug((Object)("got " + standStates.size() + " standStates"));
                    for (StandStateHistory standStateHistory : standStates) {
                        if (standStateHistory.getStateId() == 1011L) {
                            flight = standStateHistory.getInbFlight();
                            if (flight != null) {
                                log.debug((Object)("got flight: " + flight.getUniqueFlightNumber()));
                                uniqueFlightNumber = flight.getUniqueFlightNumber();
                                flight = this.fisFacadeLocal.findCurrentFlightByUFN(uniqueFlightNumber);
                                pairFlight = this.fisFacadeLocal.findPairFlight(flight);
                                if (pairFlight != null) {
                                    log.debug((Object)("got pairFlight: " + pairFlight.getUniqueFlightNumber()));
                                }
                                stateTTO.setCurrFlights(flight, pairFlight);
                                continue;
                            }
                            log.debug((Object)"flight == null");
                            continue;
                        }
                        log.debug((Object)("standState not occupied for stand: " + standStateHistory.getStand()));
                    }
                } else {
                    log.debug((Object)"addCurrFlights - stateHistory.getArea() == null");
                }
            }
            if (this.config.getBoolean("xml.telemetryDataMessage.stateField.prevFlights.active") && stateTTO.getPrevArea() != null) {
                standStates = this.standStateFacadeLocal.findStandStateHistoryForStandAndStateModelTimestamp(stateTTO.getPrevArea(), 1010L, stateTTO.getPrevBeginTime());
                log.debug((Object)("got " + standStates.size() + " standStates"));
                for (StandStateHistory standStateHistory : standStates) {
                    if (standStateHistory.getStateId() != 1011L) continue;
                    flight = standStateHistory.getInbFlight();
                    log.debug((Object)("got flight: " + flight.getUniqueFlightNumber()));
                    if (flight == null) continue;
                    uniqueFlightNumber = flight.getUniqueFlightNumber();
                    pairFlight = this.fisFacadeLocal.findPairFlight(flight = this.fisFacadeLocal.findCurrentFlightByUFN(uniqueFlightNumber));
                    if (pairFlight != null) {
                        log.debug((Object)("got pairFlight: " + pairFlight.getUniqueFlightNumber()));
                    }
                    stateTTO.setPrevFlights(flight, pairFlight);
                }
            }
        }
        log.debug((Object)"addFlights() finished");
    }

    public void pushCache(long minId) throws TOWhileSyncException {
        Stopwatch stopwatch = new Stopwatch(this.getClass(), "pushCache");
        stopwatch.start("pushCache");
        if (log.isDebugEnabled()) {
            log.debug((Object)"pushCache()");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"beginStateStock");
        }
        BeginStockPart beginStockPart = new BeginStockPart(Enums.EventType.STATE);
        this.sendTextMessage(beginStockPart.toString());
        TelemetryDataMessages xmlMsgs = new TelemetryDataMessages(Enums.EventType.STATE);
        stopwatch.start("getCurrentStateCache");
        List<StateTTO> list = this.fastLaneTelemetry.getCurrentStateCache();
        stopwatch.stop("getCurrentStateCache", true);
        Iterator<StateTTO> it = list.iterator();
        this.readResourceBundle();
        stopwatch.start("build TelemetryDataMessages");
        while (it.hasNext()) {
            StateTTO stateTTO = it.next();
            if (stateTTO == null) continue;
            try {
                boolean sendData = UnitHelper.isSendData(stateTTO.getUnitId());
                if (sendData) {
                    xmlMsgs.add(new TelemetryDataMessage(stateTTO, this.resourceBundle));
                    continue;
                }
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)("status event " + stateTTO.getHistoryId() + " not sent for unit: " + stateTTO.getUnitId()));
            }
            catch (UnknownStateModelException e) {
                log.debug((Object)(e.getMessage() + " - message is not sent"));
            }
            catch (UnknownStateException e) {
                log.debug((Object)(e.getMessage() + " - message is not sent"));
            }
            catch (Exception e) {
                log.error((Object)"runs into", (Throwable)e);
                if (this.isTimeoutException(e)) {
                    throw new TOWhileSyncException("Transaction timed out while syncronize.Syncronize aborded.");
                }
                log.error((Object)"runs into", (Throwable)e);
            }
        }
        stopwatch.stop("build TelemetryDataMessages", true);
        if (!xmlMsgs.isEmpty()) {
            this.sendTextMessage(xmlMsgs.toString());
        }
        this.setSynchronizing(false);
        if (log.isDebugEnabled()) {
            log.debug((Object)"endStateStock");
        }
        EndStockPart endStockPart = new EndStockPart(Enums.EventType.STATE);
        this.sendTextMessage(endStockPart.toString());
        stopwatch.stop("pushCache", true);
    }

    public long getMaxHistoryId() throws TOWhileSyncException {
        try {
            log.debug((Object)"try getMaxHistoryId...");
            return this.stateOutFacade.getMaxStateHistoryId();
        }
        catch (Exception e) {
            if (this.isTimeoutException(e)) {
                throw new TOWhileSyncException("Transaction timed out while syncronize.Syncronize aborded.");
            }
            log.error((Object)"getMaxHistoryId runs into", (Throwable)e);
            return -1L;
        }
    }

    public StateHistory getStateHistory(long id) throws TOWhileSyncException {
        try {
            return this.stateOutFacade.getStateHistory(id);
        }
        catch (Exception e) {
            if (this.isTimeoutException(e)) {
                throw new TOWhileSyncException("Transaction timed out while syncronize.Syncronize aborded.");
            }
            log.error((Object)"getStateHistory runs into", (Throwable)e);
            return null;
        }
    }

    public TelemetryDataMessages getStockPart(long from, long until) throws TOWhileSyncException {
        long requestedUntil = until;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getStateStockPart from " + from + " until " + until));
        }
        long maxHistoryId = this.getMaxHistoryId();
        TelemetryDataMessages xmlMsgs = new TelemetryDataMessages(Enums.EventType.STATE);
        until = requestedUntil;
        int maxMessageCount = this.config.getInt("telemetryDataMessage.maxMessageCount");
        if (until > from + (long)maxMessageCount - 1L) {
            until = from + (long)maxMessageCount - 1L;
        }
        if (until > maxHistoryId) {
            until = maxHistoryId;
        }
        List<StateTTO> list = this.fastLaneTelemetry.getStateHistory(from, until);
        Iterator<StateTTO> it = list.iterator();
        this.readResourceBundle();
        while (it.hasNext()) {
            StateTTO stateTTO = it.next();
            if (stateTTO == null) continue;
            try {
                boolean sendData = UnitHelper.isSendData(stateTTO.getUnitId());
                if (sendData) {
                    xmlMsgs.add(new TelemetryDataMessage(stateTTO, this.resourceBundle));
                    continue;
                }
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)("status event " + stateTTO.getHistoryId() + " not sent for unit: " + stateTTO.getUnitId()));
            }
            catch (UnknownStateModelException e) {
                log.debug((Object)(e.getMessage() + " - message is not sent"));
            }
            catch (UnknownStateException e) {
                log.debug((Object)(e.getMessage() + " - message is not sent"));
            }
            catch (Exception e) {
                log.error((Object)"runs into", (Throwable)e);
                if (this.isTimeoutException(e)) {
                    throw new TOWhileSyncException("Transaction timed out while syncronize.Syncronize aborded.");
                }
                log.error((Object)"runs into", (Throwable)e);
            }
        }
        xmlMsgs.setFrom(from);
        xmlMsgs.setUntil(until);
        return xmlMsgs;
    }

    public TelemetryDataMessages getStatesForUnit(String unitName, TDITimestamp startTime, TDITimestamp endTime) throws TOWhileSyncException, TooMuchDataException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getStatesForUnit for unit " + unitName + " from " + startTime.getTimestamp() + " until " + endTime.getTimestamp()));
        }
        TelemetryDataMessages xmlMsgs = new TelemetryDataMessages(Enums.EventType.STATE);
        try {
            long unitId = UnitHelper.getUnitId(unitName);
            log.debug((Object)("unitId: " + unitId));
            List<StateHistory> stateHistoryList = this.stateOutFacade.findByUnitPeriod(unitId, startTime.getTimestamp(), endTime.getTimestamp());
            int size = stateHistoryList.size();
            log.debug((Object)("stateHistoryCol.size: " + size));
            int maxMessageCount = this.config.getInt("telemetryDataMessage.maxMessageCount");
            if (size > maxMessageCount) {
                throw new TooMuchDataException();
            }
            Iterator<StateHistory> it = stateHistoryList.iterator();
            this.readResourceBundle();
            while (it.hasNext()) {
                StateHistory stateHistory = it.next();
                if (stateHistory == null) continue;
                try {
                    boolean sendData = UnitHelper.isSendData(stateHistory.getUnitId());
                    if (!sendData) continue;
                    xmlMsgs.add(new TelemetryDataMessage(new StateTTO(stateHistory), this.resourceBundle));
                }
                catch (UnknownStateModelException e) {
                    log.debug((Object)(e.getMessage() + " - message is not sent"));
                }
                catch (UnknownStateException e) {
                    log.debug((Object)(e.getMessage() + " - message is not sent"));
                }
                catch (Exception e) {
                    log.error((Object)"runs into", (Throwable)e);
                    if (this.isTimeoutException(e)) {
                        throw new TOWhileSyncException("Transaction timed out while syncronize.Syncronize aborded.");
                    }
                    log.error((Object)"runs into", (Throwable)e);
                }
            }
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return xmlMsgs;
    }

    public ResourceBundle readResourceBundle() {
        Stopwatch stopwatch = new Stopwatch(this.getClass(), "readResourceBundle");
        stopwatch.start("readResourceBundle");
        String language = this.config.getString("resource.language");
        String country = this.config.getString("resource.country");
        Locale locale = new Locale(language, country);
        String moduleName = this.config.getString("resource.moduleName");
        List<Module> moduleList = this.moduleFacade.getModule(moduleName);
        int moduleValue = -1;
        if (moduleList.size() == 1) {
            Module module = moduleList.get(0);
            moduleValue = module.getId();
        } else {
            try {
                ModuleType moduleType = ModuleType.valueOf(moduleName);
                moduleValue = moduleType.getValue();
            }
            catch (IllegalArgumentException e) {
                log.debug((Object)("cannot find module " + moduleName));
            }
        }
        if (moduleValue == -1) {
            moduleValue = ModuleType.STATE_MODEL.getValue();
        }
        this.resourceBundle = this.resourceFacade.getResourceBundle(moduleValue, locale);
        stopwatch.stop("readResourceBundle", true);
        return this.resourceBundle;
    }

    @Override
    public boolean isDiscardOldMessages() {
        return this.discardOldMessages;
    }

    @Override
    public void setDiscardOldMessages(boolean discardOldMessages) {
        this.discardOldMessages = discardOldMessages;
    }

    public boolean isSynchronizing() {
        return this.synchronizing;
    }

    public void setSynchronizing(boolean synchronizing) {
        this.synchronizing = synchronizing;
    }

    @Override
    public long getLastSentMessageId() {
        return this.lastSentMessageId;
    }

    public void setLastSentMessageId(long lastSentMessageId) {
        this.lastSentMessageId = lastSentMessageId;
    }

    public static void undeploy() {
        if (stateHandler != null) {
            stateHandler.shutDownQueue();
            stateHandler = null;
        }
    }
}

