/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces.maintenance.xml;

import de.proveo.wwt.logic.ejb.interfaces.maintenance.jaxb.server.MaintServerMsg;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.jaxb.server.ObjectFactory;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.xml.ErrorCodes;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public class ServerMsgWrapper {
    private static final Log log = LogFactory.getLog(ServerMsgWrapper.class);
    private String packageName = "de.proveo.wwt.logic.ejb.interfaces.maintenance.jaxb.server";
    private JAXBContext jc;
    private Marshaller marshaller;
    protected MaintServerMsg serverMsg;
    protected ObjectFactory objectFactory = new ObjectFactory();
    private StringWriter stringWriter;

    public ServerMsgWrapper() {
        this.initJAXB();
    }

    protected void initJAXB() {
        try {
            this.jc = JAXBContext.newInstance((String)this.packageName, (ClassLoader)this.getClass().getClassLoader());
            this.marshaller = this.jc.createMarshaller();
            this.marshaller.setProperty("jaxb.formatted.output", (Object)true);
            this.stringWriter = new StringWriter();
            this.serverMsg = this.objectFactory.createMaintServerMsg();
        }
        catch (JAXBException e) {
            log.error((Object)"initJAXB runs into", (Throwable)e);
        }
    }

    public String toString() {
        if (this.serverMsg != null) {
            try {
                this.marshaller.marshal((Object)this.serverMsg, (Writer)this.stringWriter);
                return this.stringWriter.toString();
            }
            catch (JAXBException e) {
                log.error((Object)"runs into", (Throwable)e);
                return this.createErrorMessageWithJDom(ErrorCodes.XMLResponse, "could not create response");
            }
        }
        return this.createErrorMessageWithJDom(ErrorCodes.XMLResponse, "could not create response");
    }

    private String createErrorMessageWithJDom(ErrorCodes errorCode, String detail) {
        Document doc = new Document();
        Element respone = new Element("maintenanceRespone");
        Element error = new Element("error");
        respone.addContent((Content)error);
        Element code = new Element("code");
        Element message = new Element("message");
        switch (errorCode) {
            case UnitNotFound: {
                code.setText("UnitNotFound");
                message.setText("Could not find unit: " + detail);
                break;
            }
            case UnknownReason: {
                code.setText("UnknownReason");
                message.setText("Unknown reason: " + detail);
                break;
            }
            case TimeFormat: {
                code.setText("TimeFormat");
                message.setText("Incorrect time format: " + detail);
                break;
            }
            case MissingMethod: {
                code.setText("MissingMethod");
                message.setText("XML message doesn't contain a setServiceStatus or getEngineHours element");
                break;
            }
            case MissingParameter: {
                code.setText("MissingParameter");
                message.setText("Parameter is missing: " + detail);
                break;
            }
            case XMLParse: {
                code.setText("XMLParse");
                message.setText("Could not parse XML: " + detail);
                break;
            }
            case XMLResponse: {
                code.setText("XMLResponse");
                message.setText("Could not create response: " + detail);
                break;
            }
            case SynchronizationTimeout: {
                error.setText("synchronizationTimeout");
                error.setText("Timeout while synchronization: " + detail);
                break;
            }
            case Unknown: {
                code.setText("Unknown");
                message.setText("An error has occurred:  " + detail);
            }
        }
        error.addContent((Content)code);
        error.addContent((Content)message);
        XMLOutputter xmlOut = new XMLOutputter();
        return xmlOut.outputString(doc);
    }

    public void setMsgId(Long msgId) {
        if (this.serverMsg != null) {
            this.serverMsg.setId(msgId);
        }
    }

    public Long getMsgId() {
        if (this.serverMsg != null) {
            return this.serverMsg.getId();
        }
        return null;
    }
}

