/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces.maintenance.notify;

import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeLocal;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.notify.UnitDataValue;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import java.util.HashMap;
import javax.ejb.FinderException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class UnitHelper {
    private static final Log log = LogFactory.getLog(UnitHelper.class);
    public static final long VALIDITY_DURATION = 3600000L;
    private static HashMap<Long, UnitDataValue> unitDataValues = null;
    private static UnitFacadeLocal unitFacade = null;

    private UnitHelper() {
    }

    public static String getUnitName(long unitId) {
        String unitName = "";
        UnitDataValue data = UnitHelper.getUnit(unitId);
        if (data != null && data.getUnitName() != null) {
            unitName = data.getUnitName();
        }
        return unitName;
    }

    public static String getCustomerUnitId(long unitId) {
        String customerUnitId = "";
        UnitDataValue data = UnitHelper.getUnit(unitId);
        if (data != null && data.getCustomerUnitId() != null) {
            customerUnitId = data.getCustomerUnitId();
        }
        return customerUnitId;
    }

    public static long getUnitId(String unitName) throws FinderException {
        return unitFacade.getUnitDTO(unitName).getUnitId();
    }

    public static boolean isSendData(long unitId) {
        boolean sendData = false;
        UnitDataValue data = UnitHelper.getUnit(unitId);
        if (data != null) {
            sendData = data.isSendData();
        }
        return sendData;
    }

    protected static UnitDataValue getUnit(long unitId) {
        UnitDataValue unitDataValue;
        if (unitDataValues == null) {
            UnitHelper.init();
        }
        if ((unitDataValue = unitDataValues.get(unitId)) == null || System.currentTimeMillis() - unitDataValue.getTimestamp() > 3600000L) {
            UnitDTO unitData = unitFacade.getUnitDTO(unitId);
            unitDataValue = new UnitDataValue(System.currentTimeMillis(), unitData.getUnitName(), unitData.getUnitModel().getCustomerUnitId(), unitData.getUnitModel().getSendData());
            unitDataValues.put(unitId, unitDataValue);
        }
        return unitDataValue;
    }

    private static void init() {
        log.debug((Object)"init()");
        unitDataValues = new HashMap();
        try {
            InitialContext context = new InitialContext();
            unitFacade = (UnitFacadeLocal)context.lookup("rts/UnitFacade/local");
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
    }
}

