/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces.maintenance.notify;

import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.wwt.datamodel.notify.NotifyCache;
import de.proveo.wwt.datamodel.notify.NotifyHistory;
import de.proveo.wwt.logic.ejb.dataIn.notify.NotifyFacadeLocal;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.MIConfiguration;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.MITimestamp;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.exceptions.MessageNotSentException;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.exceptions.TOWhileSyncException;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.exceptions.TooMuchDataException;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.exceptions.UnknownNotifyException;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.jaxb.server.MaintServerMsg;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.jaxb.server.ObjectFactory;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.notify.MessageHelper;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.notify.UnitHelper;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.xml.BeginStockPartWrapper;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.xml.EndStockPartWrapper;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.xml.NotifyMessageWrapper;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.Range;
import de.proveo.wwt.logic.web.data.fastlanereader.TelemetryFastLaneReader;
import de.proveo.wwt.logic.web.historyData.dto.NotificationDTO;
import java.util.Iterator;
import java.util.List;
import javax.ejb.FinderException;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.transaction.TransactionRolledbackException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NotifyHandler {
    private static final Log log = LogFactory.getLog(NotifyHandler.class);
    private MIConfiguration config = MIConfiguration.getInstance();
    private static NotifyHandler notifyHandler = null;
    private boolean discardOldMessages = false;
    private boolean synchronizing = false;
    private long lastSentMessageId = -1L;
    private NotifyFacadeLocal notifyFacade;
    private TelemetryFastLaneReader fastLaneTelemetry = new TelemetryFastLaneReader();
    public static final String QUEUE_NAME = "queue/MaintenanceResponseQueue";
    private transient QueueConnectionFactory queueConnectionFactory;
    private transient QueueConnection queueConnection;
    protected transient QueueSender queueSender;
    protected transient QueueSession queueSession;

    private NotifyHandler() {
        this.initializeQueue();
        try {
            InitialContext ctx = new InitialContext();
            this.notifyFacade = (NotifyFacadeLocal)ctx.lookup("rts/NotifyFacade/local");
        }
        catch (NamingException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
    }

    public static NotifyHandler getInstance() {
        if (notifyHandler == null) {
            notifyHandler = new NotifyHandler();
        }
        return notifyHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean initializeQueue() {
        try {
            Queue queue;
            InitialContext ctx = new InitialContext();
            this.queueConnectionFactory = (QueueConnectionFactory)ctx.lookup("java:/ConnectionFactory");
            this.queueConnection = this.queueConnectionFactory.createQueueConnection();
            this.queueSession = this.queueConnection.createQueueSession(false, 1);
            try {
                queue = (Queue)ctx.lookup(QUEUE_NAME);
            }
            catch (NameNotFoundException ex) {
                log.debug((Object)"queue not found, create new");
                queue = this.queueSession.createQueue(QUEUE_NAME);
                ctx.bind(QUEUE_NAME, (Object)queue);
            }
            try {
                this.queueConnection.setExceptionListener((ExceptionListener)new ExceptionListenerImpl());
                this.queueSender = this.queueSession.createSender(queue);
                return true;
            }
            catch (Exception e) {
                log.error((Object)"runs into", (Throwable)e);
                try {
                    this.queueConnection.close();
                }
                catch (JMSException ignored) {
                }
                finally {
                    ctx.close();
                }
            }
        }
        catch (NamingException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        catch (JMSException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleEvent(SerializableEventWrapper wrapper) throws MessageNotSentException {
        log.debug((Object)"handle event");
        NotifyHistory notifyHistory = (NotifyHistory)wrapper.get_historyValue();
        if (notifyHistory != null) {
            boolean sendData = UnitHelper.isSendData(notifyHistory.getUnitId());
            try {
                NotifyMessageWrapper notifyMsgWrapper = new NotifyMessageWrapper(notifyHistory);
                long messageID = notifyHistory.getId();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("handleEvent() - messageId: " + messageID + " unitId: " + notifyHistory.getUnitId()));
                }
                if (sendData) {
                    String xml = notifyMsgWrapper.toString();
                    log.debug((Object)("pushNotify: " + xml));
                    this.sendTextMessage(xml);
                    return;
                }
                if (!log.isTraceEnabled()) return;
                log.trace((Object)("status event " + messageID + " not sent: " + notifyMsgWrapper.toString()));
                return;
            }
            catch (UnknownNotifyException e) {
                log.debug((Object)("don't send unknown notify:" + e.getNotifyMessageID()));
                return;
            }
            catch (Exception e) {
                log.error((Object)"runs into", (Throwable)e);
                throw new MessageNotSentException();
            }
        } else {
            log.error((Object)"notifyCacheValue is null");
        }
    }

    public void pushCache(long minId) throws TOWhileSyncException {
        block11: {
            try {
                List<NotifyCache> col = this.notifyFacade.getAllUnitEventsFromCacheSortedByHistoryId();
                ObjectFactory objFactory = new ObjectFactory();
                Iterator it = col.iterator();
                long maxId = 0L;
                while (it.hasNext()) {
                    boolean sendData;
                    NotifyCache notifyCacheValue = (NotifyCache)it.next();
                    Long pk = notifyCacheValue.getHistoryId();
                    if (pk == null || pk <= 0L || !(sendData = UnitHelper.isSendData(notifyCacheValue.getPk().getUnitId()))) continue;
                    if (pk < minId) {
                        minId = pk;
                    }
                    if (pk <= maxId) continue;
                    maxId = pk;
                }
                Range includedData = new Range(minId, maxId);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"beginNotifyStock");
                }
                BeginStockPartWrapper beginStockPart = new BeginStockPartWrapper();
                this.sendTextMessage(beginStockPart.toString());
                it = col.iterator();
                int maxMessageCount = this.config.getInt("notify.maxMessageCount");
                while (it.hasNext()) {
                    NotifyMessageWrapper notifyMsgWrapper = new NotifyMessageWrapper();
                    int count = 0;
                    while (count < maxMessageCount && it.hasNext()) {
                        boolean sendData;
                        NotifyHistory notifyHistoryValue;
                        NotifyCache notifyCacheValue = (NotifyCache)it.next();
                        Long id = notifyCacheValue.getHistoryId();
                        if (id == null || id <= 0L || (notifyHistoryValue = this.notifyFacade.getNotifyHistoryValue(id)) == null || !(sendData = UnitHelper.isSendData(notifyHistoryValue.getUnitId()))) continue;
                        try {
                            NotifyMessageWrapper notifyMessage = new NotifyMessageWrapper(notifyHistoryValue);
                            notifyMsgWrapper.add(notifyMessage);
                            ++count;
                            this.lastSentMessageId = id;
                        }
                        catch (UnknownNotifyException e) {
                            log.debug((Object)("don't send unknown notify:" + e.getNotifyMessageID()));
                        }
                    }
                    if (notifyMsgWrapper.isEmpty()) continue;
                    String xml = notifyMsgWrapper.toString();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("pushNotifyStockPart: " + xml));
                    }
                    this.sendTextMessage(xml);
                }
                this.setSynchronizing(false);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("endNotifyStock: " + includedData));
                }
                EndStockPartWrapper endStockPart = new EndStockPartWrapper(includedData.getFrom(), includedData.getUntil());
                this.sendTextMessage(endStockPart.toString());
            }
            catch (Exception e) {
                log.error((Object)"runs into", (Throwable)e);
                if (!this.isTimeoutException(e)) break block11;
                throw new TOWhileSyncException("Transaction timed out while synchronization. Synchronization aborted.");
            }
        }
    }

    protected boolean isTimeoutException(Throwable t) {
        Throwable cause = t.getCause();
        if (cause == null) {
            return false;
        }
        if (cause instanceof ResourceException || cause instanceof RuntimeException || cause instanceof TransactionRolledbackException) {
            log.debug((Object)("cause: " + cause.getMessage()));
            return cause.getMessage().contains("Transaction is not active") || cause.getMessage().contains("timeout");
        }
        return this.isTimeoutException(cause);
    }

    public long getMaxHistoryId() throws TOWhileSyncException {
        try {
            log.debug((Object)"try getMaxHistoryId...");
            return this.notifyFacade.findNotifyHistoryMaxHistoryId();
        }
        catch (Exception e) {
            if (this.isTimeoutException(e)) {
                throw new TOWhileSyncException("Transaction timed out while syncronize.Syncronize aborded.");
            }
            log.error((Object)"getMaxHistoryId runs into", (Throwable)e);
            return -1L;
        }
    }

    public NotifyHistory getNotifyHistory(long id) throws TOWhileSyncException {
        return this.notifyFacade.findByPrimaryKey(id);
    }

    public NotifyMessageWrapper getStockPart(long from, long until) throws TOWhileSyncException {
        long requestedUntil = until;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getNotifyStockPart from " + from + " until " + until));
        }
        long maxHistoryId = this.getMaxHistoryId();
        NotifyMessageWrapper notifyMsgWrapper = new NotifyMessageWrapper();
        until = requestedUntil;
        int maxMessageCount = this.config.getInt("notify.maxMessageCount");
        if (until > from + (long)maxMessageCount) {
            until = from + (long)maxMessageCount;
        }
        if (until > maxHistoryId) {
            until = maxHistoryId;
        }
        List<NotificationDTO> list = this.fastLaneTelemetry.getNotifyHistory(from, until);
        for (NotificationDTO notificationDTO : list) {
            if (notificationDTO == null) continue;
            try {
                boolean sendData = UnitHelper.isSendData(notificationDTO.getUnitId());
                if (!sendData) continue;
                NotifyMessageWrapper notifyMessage = new NotifyMessageWrapper(notificationDTO);
                notifyMsgWrapper.add(notifyMessage);
            }
            catch (UnknownNotifyException e) {
                log.debug((Object)("don't send unknown notify:" + e.getNotifyMessageID()));
            }
            catch (Exception e) {
                log.error((Object)"runs into", (Throwable)e);
                if (this.isTimeoutException(e)) {
                    throw new TOWhileSyncException("Transaction timed out while syncronize.Syncronize aborded.");
                }
                log.error((Object)"runs into", (Throwable)e);
            }
        }
        if (notifyMsgWrapper.isEmpty()) {
            notifyMsgWrapper.setFrom(-1L);
            notifyMsgWrapper.setUntil(-1L);
            return notifyMsgWrapper;
        }
        notifyMsgWrapper.setFrom(from);
        notifyMsgWrapper.setUntil(until);
        return notifyMsgWrapper;
    }

    public MaintServerMsg getNotifiesForUnit(String unitName, MITimestamp startTime, MITimestamp endTime) throws TOWhileSyncException, TooMuchDataException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getNotifiesForUnit for unit " + unitName + " from " + startTime.getTimestamp() + " until " + endTime.getTimestamp()));
        }
        ObjectFactory objFactory = new ObjectFactory();
        MaintServerMsg serverMsg = objFactory.createMaintServerMsg();
        try {
            long unitId = UnitHelper.getUnitId(unitName);
            log.debug((Object)("unitId: " + unitId));
            List<NotifyHistory> notifyHistoryCol = this.notifyFacade.findByUnitIdSorted(unitId, startTime.getTimestamp(), endTime.getTimestamp(), true);
            int size = notifyHistoryCol.size();
            log.debug((Object)("notifyHistoryCol.size: " + size));
            int maxMessageCount = this.config.getInt("telemetryDataMessage.maxMessageCount");
            if (size > maxMessageCount) {
                throw new TooMuchDataException();
            }
            for (NotifyHistory notifyHistory : notifyHistoryCol) {
                if (notifyHistory == null) continue;
                try {
                    boolean sendData;
                    if (notifyHistory == null || !(sendData = UnitHelper.isSendData(notifyHistory.getUnitId()))) continue;
                    MaintServerMsg.NotifyMessage notifyMessage = MessageHelper.createNotifyMessage(notifyHistory);
                    List<MaintServerMsg.NotifyMessage> notifyMessageList = serverMsg.getNotifyMessage();
                    notifyMessageList.add(notifyMessage);
                }
                catch (Exception e) {
                    log.error((Object)"runs into", (Throwable)e);
                    if (this.isTimeoutException(e)) {
                        throw new TOWhileSyncException("Transaction timed out while synchronization. Synchronization aborted.");
                    }
                    log.error((Object)"runs into", (Throwable)e);
                }
            }
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return serverMsg;
    }

    public void sendTextMessage(String text) {
        try {
            log.debug((Object)("send message to out queue: " + text));
            TextMessage msg = this.queueSession.createTextMessage(text);
            this.queueSender.send((Message)msg);
        }
        catch (JMSException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
    }

    public boolean isDiscardOldMessages() {
        return this.discardOldMessages;
    }

    public void setDiscardOldMessages(boolean discardOldMessages) {
        this.discardOldMessages = discardOldMessages;
    }

    public boolean isSynchronizing() {
        return this.synchronizing;
    }

    public void setSynchronizing(boolean synchronizing) {
        this.synchronizing = synchronizing;
    }

    public long getLastSentMessageId() {
        return this.lastSentMessageId;
    }

    public void setLastSentMessageId(long lastSentMessageId) {
        this.lastSentMessageId = lastSentMessageId;
    }

    public static void undeploy() {
        if (notifyHandler != null) {
            notifyHandler.shutDownQueue();
            notifyHandler = null;
        }
    }

    public void shutDownQueue() {
        try {
            this.queueSender.close();
            this.queueConnection.setExceptionListener(null);
            this.queueConnection.close();
        }
        catch (JMSException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
    }

    private class ExceptionListenerImpl
    implements ExceptionListener {
        public static final int NUM_RETRIES = 3;

        private ExceptionListenerImpl() {
        }

        public void onException(JMSException e) {
            for (int i = 0; i < 3; ++i) {
                log.warn((Object)("Connection has problems, trying to re-create it, attempt " + (i + 1) + " ..."));
                try {
                    NotifyHandler.this.queueConnection.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                boolean setupOK = NotifyHandler.this.initializeQueue();
                if (setupOK) {
                    log.info((Object)"Connection re-established");
                    return;
                }
                log.warn((Object)"Re-creating connection failed, retrying ...");
            }
            log.error((Object)"Cannot re-establish connection, giving up ...");
        }
    }
}

