/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces.accessControl;

import de.proveo.wwt.datamodel.custom.CustomScript;
import de.proveo.wwt.logic.ejb.general.custom.CustomScriptFacadeLocal;
import de.proveo.wwt.logic.ejb.general.custom.ScriptLoader;
import de.proveo.wwt.logic.ejb.interfaces.ServiceLocator;
import de.proveo.wwt.logic.ejb.interfaces.accessControl.ACIMessageProcessor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ACIMessageService {
    private static final Log log = LogFactory.getLog(ACIMessageService.class);
    private static final String ACI_MESSAGE_SERVICE_ENTRY_POINT = "interfaces.accessControl.ACIMessageService";
    private static final ScriptLoader<ACIMessageProcessor> aciMessageProcessorScriptLoader = new ScriptLoader();
    private static ACIMessageService INSTANCE = new ACIMessageService();
    private CustomScriptFacadeLocal customScriptFacade = null;
    private List<ACIMessageProcessor> aciMessageProcessors;
    private boolean initialized = false;

    private ACIMessageService() {
    }

    public static ACIMessageService getINSTANCE() {
        return INSTANCE;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public void init() {
        log.info((Object)"init()");
        this.customScriptFacade = ServiceLocator.getCustomScriptFacade();
        List<CustomScript> customScripts = this.customScriptFacade.getActiveScriptsByEntryPointForAllUnits(ACI_MESSAGE_SERVICE_ENTRY_POINT);
        log.info((Object)("found " + customScripts.size() + " active scripts for entry point " + ACI_MESSAGE_SERVICE_ENTRY_POINT));
        this.aciMessageProcessors = new ArrayList<ACIMessageProcessor>();
        for (CustomScript customScript : customScripts) {
            try {
                ACIMessageProcessor aciMessageProcessor = aciMessageProcessorScriptLoader.loadScript(customScript);
                aciMessageProcessor.init();
                this.aciMessageProcessors.add(aciMessageProcessor);
            }
            catch (Exception e) {
                log.error((Object)"runs into ", (Throwable)e);
            }
        }
        this.setInitialized(true);
    }

    public String processMessage(String xml) {
        Iterator<ACIMessageProcessor> iterator;
        log.debug((Object)"processACIMessage(String xml)");
        long startTime = System.currentTimeMillis();
        if (!this.isInitialized()) {
            this.init();
        }
        if ((iterator = this.aciMessageProcessors.iterator()).hasNext()) {
            ACIMessageProcessor aciMessageProcessor = iterator.next();
            return aciMessageProcessor.processXML(xml);
        }
        long duration = System.currentTimeMillis() - startTime;
        log.debug((Object)("processMessage(String xml) - duration: " + duration + " ms"));
        return "";
    }
}

