/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces;

import de.proveo.wwt.logic.ejb.interfaces.InterfaceConfiguration;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InterfaceTimestamp {
    private static final Log log = LogFactory.getLog(InterfaceTimestamp.class);
    protected static InterfaceConfiguration config = null;
    protected long timestamp;

    protected InterfaceTimestamp(InterfaceConfiguration config) {
        InterfaceTimestamp.config = config;
    }

    public InterfaceTimestamp(InterfaceConfiguration config, long timestamp) {
        this(config);
        this.timestamp = timestamp;
    }

    public InterfaceTimestamp(InterfaceConfiguration config, String timeString) throws ParseException {
        this(config);
        this.timestamp = InterfaceTimestamp.parseDate(timeString);
    }

    protected static long parseDate(String dateString) throws ParseException {
        if (dateString == null || dateString.length() == 0) {
            return 0L;
        }
        if (InterfaceTimestamp.isFormatActive()) {
            String formatString = InterfaceTimestamp.getFormatString();
            SimpleDateFormat formatter = new SimpleDateFormat(formatString, Locale.ENGLISH);
            formatter.setTimeZone(InterfaceTimestamp.getTimezone());
            Date date = formatter.parse(dateString);
            long timestamp = date.getTime();
            return timestamp;
        }
        try {
            long timestamp = Long.parseLong(dateString);
            return timestamp;
        }
        catch (NumberFormatException e) {
            throw new ParseException(e.getMessage(), 0);
        }
    }

    protected static String formatDate(long timestamp) {
        if (timestamp == 0L || timestamp == -1L) {
            return "";
        }
        if (InterfaceTimestamp.isFormatActive()) {
            SimpleDateFormat formatter = new SimpleDateFormat(InterfaceTimestamp.getFormatString(), Locale.ENGLISH);
            formatter.setTimeZone(InterfaceTimestamp.getTimezone());
            String dateString = formatter.format(timestamp);
            return dateString;
        }
        return Long.toString(timestamp);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public String getTimeString() {
        return InterfaceTimestamp.formatDate(this.timestamp);
    }

    public String toString() {
        return InterfaceTimestamp.formatDate(this.timestamp);
    }

    protected static InterfaceConfiguration getConfig() {
        return config;
    }

    protected static void setConfig(InterfaceConfiguration config) {
        InterfaceTimestamp.config = config;
    }

    protected static TimeZone getTimezone() {
        if (config != null) {
            return TimeZone.getTimeZone(config.getString("timestamp.timezone").trim());
        }
        log.warn((Object)"Configuration for Timestamp is not set!");
        return TimeZone.getTimeZone("Europe/Berlin");
    }

    protected static String getFormatString() {
        if (config != null) {
            return config.getString("timestamp.format").trim();
        }
        log.warn((Object)"Configuration for Timestamp is not set!");
        return "yyyyMMddHHmmss";
    }

    protected static boolean isFormatActive() {
        if (config != null) {
            return config.getBoolean("timestamp.format.active");
        }
        log.warn((Object)"Configuration for Timestamp is not set!");
        return true;
    }
}

