/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.geo;

import de.proveo.wwt.datamodel.area.Area;
import java.io.Serializable;
import java.util.Properties;

public class GeoStruct
implements Serializable {
    private static final long serialVersionUID = 1432185806661080285L;
    private Integer areaId;
    private String area;
    private String areaDescription;
    private String ggaRec;
    private String rmcRec;
    private long beginTime;
    private long endTime;
    private long beginReceiveTime;
    private long unitId;
    private long endReceiveTime;
    private long historyId;
    private boolean trusted;
    private String reason;
    private int longMSEC = -1;
    private int latMSEC = -1;
    private Area areaValue;

    public GeoStruct(long ui, long begin, long beginReceive, long end, long endReceive, long historyId, String rmc, String gga, String areaName, String areaDescription, boolean proveoTrusted, String cause, Area value) {
        this.unitId = ui;
        this.beginTime = begin;
        this.beginReceiveTime = beginReceive;
        this.endTime = end;
        this.endReceiveTime = endReceive;
        this.historyId = historyId;
        this.rmcRec = rmc;
        this.ggaRec = gga;
        this.area = areaName;
        this.areaDescription = areaDescription;
        this.trusted = proveoTrusted;
        this.reason = cause;
        this.longMSEC = -1;
        this.latMSEC = -1;
    }

    public GeoStruct(long ui, long begin, long beginReceive, long end, long endReceive, long historyId, String rmc, String gga, String areaName, String areaDescription, boolean proveoTrusted, String cause, int longMSEC, int latMSEC, Area value) {
        this.unitId = ui;
        this.beginTime = begin;
        this.beginReceiveTime = beginReceive;
        this.endTime = end;
        this.endReceiveTime = endReceive;
        this.historyId = historyId;
        this.rmcRec = rmc;
        this.ggaRec = gga;
        this.area = areaName;
        this.areaDescription = areaDescription;
        this.trusted = proveoTrusted;
        this.reason = cause;
        this.longMSEC = longMSEC;
        this.latMSEC = latMSEC;
        this.areaValue = value;
    }

    public GeoStruct(long ui, long begin, long beginReceive, String rmc, String gga, boolean proveoTrusted, String cause) {
        this.unitId = ui;
        this.beginTime = begin;
        this.beginReceiveTime = beginReceive;
        this.endTime = 0L;
        this.endReceiveTime = 0L;
        this.historyId = 0L;
        this.rmcRec = rmc;
        this.ggaRec = gga;
        this.area = "";
        this.areaDescription = "";
        this.trusted = proveoTrusted;
        this.reason = cause;
        this.longMSEC = -1;
        this.latMSEC = -1;
    }

    public GeoStruct(long ui, long begin, long beginReceive, int latMSEC, int longMSEC, boolean proveoTrusted, String cause) {
        this.unitId = ui;
        this.beginTime = begin;
        this.beginReceiveTime = beginReceive;
        this.endTime = 0L;
        this.endReceiveTime = 0L;
        this.historyId = 0L;
        this.longMSEC = longMSEC;
        this.latMSEC = latMSEC;
        this.rmcRec = "";
        this.ggaRec = "";
        this.area = "";
        this.areaDescription = "";
        this.trusted = proveoTrusted;
        this.reason = cause;
    }

    public Properties generateEventProperties() {
        Properties properties = new Properties();
        properties.put("r", this.rmcRec);
        properties.put("g", this.ggaRec);
        properties.put("v", this.trusted ? "1" : "0");
        properties.put("t", String.valueOf(this.beginTime));
        properties.put("x", this.reason);
        properties.put("u", String.valueOf(this.unitId));
        return properties;
    }

    public Integer getAreaId() {
        if (this.areaValue != null) {
            return this.areaValue.getAreaId();
        }
        return null;
    }

    public void setAreaId(Integer areaId) {
        this.areaId = areaId;
    }

    public String getArea() {
        return this.area;
    }

    public String getAreaDescription() {
        return this.areaDescription;
    }

    public String getReason() {
        return this.reason;
    }

    public long getBeginTime() {
        return this.beginTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public long getBeginStamp() {
        return this.beginTime;
    }

    public long getEndStamp() {
        return this.endTime;
    }

    public long getBeginEventDelay() {
        return this.beginReceiveTime - this.beginTime;
    }

    public long getEndEventDelay() {
        return this.endReceiveTime - this.endTime;
    }

    public String getGgaRec() {
        return this.ggaRec;
    }

    public long getBeginReceiveTime() {
        return this.beginReceiveTime;
    }

    public String getRmcRec() {
        return this.rmcRec;
    }

    public void setGgaRec(String ggaRec) {
        this.ggaRec = ggaRec;
    }

    public void setRmcRec(String rmcRec) {
        this.rmcRec = rmcRec;
    }

    public long getUnitId() {
        return this.unitId;
    }

    public long getEndReceiveTime() {
        return this.endReceiveTime;
    }

    public long getHistoryId() {
        return this.historyId;
    }

    public void setPkGdataPrevious(long pkGdataPrevious) {
        this.historyId = pkGdataPrevious;
    }

    public boolean isTrusted() {
        return this.trusted;
    }

    public void setAreaValue(Area areaValue) {
        this.areaValue = areaValue;
    }

    public Area getAreaValue() {
        return this.areaValue;
    }

    public String toString() {
        StringBuilder dump = new StringBuilder("{");
        dump.append("unitId:'");
        dump.append(this.unitId);
        dump.append("' ");
        dump.append("beginTime:'");
        dump.append(this.beginTime);
        dump.append("' ");
        dump.append("beginReceiveTime:'");
        dump.append(this.beginReceiveTime);
        dump.append("' ");
        dump.append("endTime:'");
        dump.append(this.endTime);
        dump.append("' ");
        dump.append("endReceiveTime:'");
        dump.append(this.endReceiveTime);
        dump.append("' ");
        dump.append("pkGdataPrevious:'");
        dump.append(this.historyId);
        dump.append("' ");
        dump.append("rmcRec:'");
        dump.append(this.rmcRec);
        dump.append("' ");
        dump.append("ggaRec:'");
        dump.append(this.ggaRec);
        dump.append("' ");
        if (this.areaValue != null) {
            dump.append("areaId:'");
            dump.append(this.areaValue.getAreaId());
        } else {
            dump.append("areaId:'");
            dump.append(this.areaId);
        }
        dump.append("' ");
        dump.append("trusted:'");
        dump.append(this.trusted);
        dump.append("}");
        return dump.toString();
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public void setTrusted(boolean trusted) {
        this.trusted = trusted;
    }

    public void setBeginReceiveTime(long beginReceiveTime) {
        this.beginReceiveTime = beginReceiveTime;
    }

    public void setBeginTime(long beginTime) {
        this.beginTime = beginTime;
    }

    public int getLatMSEC() {
        return this.latMSEC;
    }

    public int getLongMSEC() {
        return this.longMSEC;
    }
}

