/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.scheduledReports.dto;

import de.proveo.wwt.datamodel.account.Account;
import de.proveo.wwt.logic.ejb.general.scheduledReports.dto.OutputFormat;
import de.proveo.wwt.logic.ejb.general.scheduledReports.dto.PageFormat;
import de.proveo.wwt.logic.ejb.general.scheduledReports.dto.ScheduledReportDTO;
import de.proveo.wwt.logic.ejb.general.scheduledReports.dto.TimeInterval;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ScheduledUnitReportDTO
extends ScheduledReportDTO {
    private static final Log log = LogFactory.getLog(ScheduledUnitReportDTO.class);

    public ScheduledUnitReportDTO(ScheduledReportDTO dto) {
        super(dto);
    }

    public ScheduledUnitReportDTO(String type, String reportName, String reportDesign, OutputFormat outputFormat, PageFormat pageFormat, Locale locale, TimeInterval interval, List<Account> accounts, String emails, long createTime) {
        super(type, reportName, reportDesign, outputFormat, pageFormat, locale, interval, accounts, emails, createTime);
    }

    public List<Long> getUnitIds() {
        ArrayList<Long> unitIds = new ArrayList<Long>();
        if (this.reportParameters.containsKey("unitId")) {
            String unitIdString = (String)this.reportParameters.get("unitId");
            if (!unitIdString.equals("null")) {
                try {
                    for (String unitId : unitIdString.split(",")) {
                        unitIds.add(Long.parseLong(unitId));
                    }
                }
                catch (NumberFormatException e) {
                    log.error((Object)"runs into: ", (Throwable)e);
                    return unitIds;
                }
            } else {
                unitIds.add(null);
            }
        }
        return unitIds;
    }

    public void setUnitIds(List<Long> unitIds) {
        String unitIdString = "";
        if (unitIds == null || unitIds.isEmpty() || unitIds.contains(null)) {
            unitIdString = "null,";
        } else {
            for (Long l : unitIds) {
                if (l == null) continue;
                unitIdString = unitIdString.concat(String.valueOf(l)).concat(",");
            }
        }
        this.reportParameters.put("unitId", unitIdString.substring(0, unitIdString.length() - 1));
    }

    public boolean isAllUnitsSelected() {
        return this.getUnitIds().get(0) == null;
    }
}

