/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.kml.area;

import de.micromata.opengis.kml.v_2_2_0.AltitudeMode;
import de.micromata.opengis.kml.v_2_2_0.Boundary;
import de.micromata.opengis.kml.v_2_2_0.Document;
import de.micromata.opengis.kml.v_2_2_0.Feature;
import de.micromata.opengis.kml.v_2_2_0.Folder;
import de.micromata.opengis.kml.v_2_2_0.Geometry;
import de.micromata.opengis.kml.v_2_2_0.Kml;
import de.micromata.opengis.kml.v_2_2_0.LineStyle;
import de.micromata.opengis.kml.v_2_2_0.Placemark;
import de.micromata.opengis.kml.v_2_2_0.PolyStyle;
import de.micromata.opengis.kml.v_2_2_0.Polygon;
import de.micromata.opengis.kml.v_2_2_0.Style;
import de.micromata.opengis.kml.v_2_2_0.StyleSelector;
import de.proveo.util.kml.KmlUtil;
import de.proveo.util.kml.structs.AreaInfo;
import de.proveo.util.kml.structs.GeoPoint;
import de.proveo.wwt.datamodel.area.Area;
import de.proveo.wwt.datamodel.area.AreaPoints;
import de.proveo.wwt.logic.ejb.general.area.AreaInFacadeLocal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AreaExport {
    private static final Log log = LogFactory.getLog(AreaExport.class);
    private static final String STYLE_PREFIX = "style_";
    private static final String FOLDER_NAME = "Level %d";
    private static final String DOCUMENT_NAME = "Areas";
    private Map<Integer, Folder> folderMap = new HashMap<Integer, Folder>();
    private List<Area> dataList;
    private static final String[] COLORS = new String[]{"5500FF55", "5500FF00", "55FF0000", "5500FFFF", "55E9FF00", "550000FF", "5513458B", "5513458B", "5513458B", "5513458B"};
    private Style[] styles = new Style[0];
    private AreaInFacadeLocal areaFacade;

    public AreaExport() {
        try {
            InitialContext context = new InitialContext();
            this.areaFacade = (AreaInFacadeLocal)context.lookup("rts/AreaInFacade/local");
        }
        catch (Exception e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
    }

    public byte[] export() {
        String[] colors = COLORS;
        this.generateStyles(colors);
        Kml kml = new Kml();
        Document doc = kml.createAndSetDocument();
        doc.setName(DOCUMENT_NAME);
        doc.setVisibility(Boolean.valueOf(true));
        for (AreaInfo areaInfo : this.getAreaInfo()) {
            doc.addToFeature((Feature)this.generatePlacemark(areaInfo));
        }
        for (AreaInfo areaInfo : this.styles) {
            doc.addToStyleSelector((StyleSelector)areaInfo);
        }
        return KmlUtil.serialize((Kml)kml);
    }

    public byte[] exportWithFolders() {
        String[] colors = COLORS;
        this.generateStyles(colors);
        Kml kml = new Kml();
        Document doc = kml.createAndSetDocument();
        doc.setName(DOCUMENT_NAME);
        doc.setVisibility(Boolean.valueOf(true));
        this.folderMap.clear();
        for (AreaInfo info : this.getAreaInfo()) {
            this.getFolder(info.priority).addToFeature((Feature)AreaExport.generatePolygonPlacemark(info));
        }
        ArrayList<Integer> priorityList = new ArrayList<Integer>(this.folderMap.keySet());
        Collections.sort(priorityList);
        int colorIdx = 0;
        Iterator i$ = priorityList.iterator();
        while (i$.hasNext()) {
            int key = (Integer)i$.next();
            Folder folder = this.folderMap.get(key);
            doc.addToFeature((Feature)folder);
            for (Feature feature : folder.getFeature()) {
                if (!(feature instanceof Placemark)) continue;
                feature.setStyleUrl("#" + this.styles[colorIdx].getId());
            }
            ++colorIdx;
            colorIdx %= priorityList.size();
        }
        for (Style style : this.styles) {
            doc.addToStyleSelector((StyleSelector)style);
        }
        return KmlUtil.serialize((Kml)kml);
    }

    private void generateStyles(String[] colors) {
        ArrayList<Style> styles = new ArrayList<Style>(colors.length);
        for (String colorString : colors) {
            PolyStyle polyStyle = new PolyStyle();
            polyStyle.setColor(colorString);
            polyStyle.setFill(Boolean.valueOf(true));
            polyStyle.setOutline(Boolean.valueOf(true));
            LineStyle lineStyle = new LineStyle();
            lineStyle.setColor("99000000");
            lineStyle.setWidth(1.0);
            Style style = new Style();
            style.setPolyStyle(polyStyle);
            style.setLineStyle(lineStyle);
            style.setId(STYLE_PREFIX + String.valueOf(Math.abs(style.hashCode())));
            styles.add(style);
        }
        this.styles = styles.toArray(new Style[styles.size()]);
    }

    private Folder getFolder(int priority) {
        Folder folder = this.folderMap.get(priority);
        if (folder == null) {
            folder = new Folder();
            folder.setName(String.format(FOLDER_NAME, priority));
            this.folderMap.put(priority, folder);
        }
        return folder;
    }

    private static Placemark generatePolygonPlacemark(AreaInfo areaInfo) {
        Boundary boundary = new Boundary();
        boundary.setLinearRing(KmlUtil.createLinearRing((GeoPoint[])areaInfo.points));
        Polygon polygon = new Polygon();
        polygon.setAltitudeMode(AltitudeMode.CLAMP_TO_GROUND);
        polygon.setOuterBoundaryIs(boundary);
        Placemark placemark = new Placemark();
        placemark.setName(areaInfo.id + ":" + areaInfo.name + ":" + areaInfo.priority);
        placemark.setDescription(areaInfo.description);
        placemark.setId(String.valueOf(areaInfo.id));
        placemark.setGeometry((Geometry)polygon);
        placemark.setTargetId(String.valueOf(areaInfo.priority));
        return placemark;
    }

    private Placemark generatePlacemark(AreaInfo areaInfo) {
        Boundary boundary = new Boundary();
        boundary.setLinearRing(KmlUtil.createLinearRing((GeoPoint[])areaInfo.points));
        Polygon polygon = new Polygon();
        polygon.setAltitudeMode(AltitudeMode.CLAMP_TO_GROUND);
        polygon.setOuterBoundaryIs(boundary);
        Placemark placemark = new Placemark();
        placemark.setName(areaInfo.id + ":" + areaInfo.name + ":" + areaInfo.priority);
        placemark.setDescription(areaInfo.description);
        placemark.setId(String.valueOf(areaInfo.id));
        placemark.setGeometry((Geometry)polygon);
        placemark.setTargetId(String.valueOf(areaInfo.priority));
        int colorIdx = areaInfo.priority % this.styles.length;
        placemark.setStyleUrl("#" + this.styles[colorIdx].getId());
        return placemark;
    }

    private AreaInfo[] getAreaInfo() {
        ArrayList<AreaInfo> areaInfoList = new ArrayList<AreaInfo>();
        ArrayList<GeoPoint> points = new ArrayList<GeoPoint>();
        this.dataList = this.areaFacade.findAllWithPoints();
        for (Area area : this.dataList) {
            AreaInfo areaInfo = new AreaInfo();
            areaInfo.priority = area.getPriority();
            areaInfo.id = area.getAreaId();
            areaInfo.name = area.getName();
            areaInfo.description = area.getDescription();
            for (AreaPoints point : area.getAreaPoints()) {
                points.add(new GeoPoint((long)point.getLatitude(), (long)point.getLongitude()));
            }
            if (points.size() == 0) continue;
            areaInfo.points = points.toArray(new GeoPoint[points.size()]);
            points.clear();
            areaInfoList.add(areaInfo);
        }
        Collections.sort(areaInfoList, new Comparator<AreaInfo>(){

            @Override
            public int compare(AreaInfo o1, AreaInfo o2) {
                if (o1 == null || o2 == null || o1.name == null || o2.name == null) {
                    return 0;
                }
                return o1.name.toLowerCase().compareTo(o2.name.toLowerCase());
            }
        });
        return areaInfoList.toArray(new AreaInfo[areaInfoList.size()]);
    }

    public List<Area> getDataList() {
        return this.dataList;
    }
}

