/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.jms;

import de.proveo.wwt.logic.ejb.dataIn.informant.InformantClient;
import de.proveo.wwt.logic.ejb.general.jms.JMSClient;
import de.proveo.wwt.logic.ejb.general.jms.JMSMessageListener;
import java.util.concurrent.locks.ReentrantLock;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class JMSConnectionUtil {
    private static final Log log = LogFactory.getLog(JMSConnectionUtil.class);
    private static JMSConnectionUtil instance = new JMSConnectionUtil();
    private static final ReentrantLock lock = new ReentrantLock();

    private JMSConnectionUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JMSConnectionUtil getInstance() {
        if (instance == null) {
            lock.lock();
            try {
                if (instance == null) {
                    instance = new JMSConnectionUtil();
                }
            }
            finally {
                lock.unlock();
            }
        }
        return instance;
    }

    public boolean establishJMSConnection(String subscriberId, JMSMessageListener listener, String selector, InformantClient informantClient) {
        boolean ret;
        block21: {
            String method = "establishJMSConnection(subscriberId=" + subscriberId + "): ";
            ret = false;
            try {
                InitialContext ctx = new InitialContext();
                TopicConnectionFactory connectionFactory = (TopicConnectionFactory)ctx.lookup("java:/ConnectionFactory");
                TopicConnection connection = connectionFactory.createTopicConnection();
                if (log.isDebugEnabled()) {
                    log.debug((Object)(method + "TopicConnection created."));
                }
                try {
                    JMSExceptionListener exceptionListener = new JMSExceptionListener(subscriberId, connection, selector, listener, informantClient);
                    connection.setExceptionListener((ExceptionListener)exceptionListener);
                    connection.start();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(method + "TopicConnection started."));
                    }
                    TopicSession session = connection.createTopicSession(false, 2);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(method + "TopicSession created."));
                    }
                    Topic topic = null;
                    try {
                        topic = (Topic)ctx.lookup("topic/proveoDataProviderTopic");
                    }
                    catch (NameNotFoundException ex) {
                        topic = session.createTopic("topic/proveoDataProviderTopic");
                        ctx.bind("topic/proveoDataProviderTopic", (Object)topic);
                    }
                    try {
                        session.commit();
                        log.debug((Object)(method + "Session commited."));
                    }
                    catch (JMSException ex) {
                        log.debug((Object)(method + "Could not commit session: " + ex.getMessage()));
                    }
                    TopicSubscriber subscriber = session.createSubscriber(topic, selector, true);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(method + "TopicSubscriber created."));
                    }
                    subscriber.setMessageListener((MessageListener)listener);
                    listener.setJMSClient(new JMSClient(subscriberId, connection, subscriber, session));
                    ret = true;
                }
                catch (Throwable ex) {
                    try {
                        connection.close();
                    }
                    catch (JMSException ignored) {
                        // empty catch block
                    }
                    throw ex;
                }
                finally {
                    ctx.close();
                }
            }
            catch (NamingException e) {
                ret = false;
                log.error((Object)(method + "runs into NamingException"), (Throwable)e);
                if (informantClient != null) {
                    informantClient.notify(method + "ends in NamingException: " + e.getMessage(), "ServerErrorEvent");
                }
            }
            catch (JMSException e) {
                ret = false;
                log.error((Object)(method + "runs into JMSException"), (Throwable)e);
                if (informantClient != null) {
                    informantClient.notify(method + "ends in JMSException: " + e.getMessage(), "ServerErrorEvent");
                }
            }
            catch (Throwable e) {
                ret = false;
                log.error((Object)(method + "runs into unexpected exception"), e);
                if (informantClient == null) break block21;
                informantClient.notify(method + "ends in unexpected exception: " + e.getMessage(), "ServerErrorEvent");
            }
        }
        return ret;
    }

    private class JMSExceptionListener
    implements ExceptionListener {
        private static final int NUM_RETRIES = 3;
        private boolean exceptionFlag = false;
        private String subscriberId;
        private TopicConnection connect;
        private String selector;
        private JMSMessageListener listener;
        private InformantClient informantClient;

        public JMSExceptionListener(String subscriberId, TopicConnection connect, String selector, JMSMessageListener listener, InformantClient informantClient) {
            this.subscriberId = subscriberId;
            this.connect = connect;
            this.selector = selector;
            this.listener = listener;
            this.informantClient = informantClient;
        }

        public synchronized void onException(JMSException ex) {
            String method = "onException(subscriberId=" + this.subscriberId + "): ";
            if (this.exceptionFlag) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(method + "Another exception was detected while trying to reconnect. Break"), (Throwable)ex);
                }
                return;
            }
            this.exceptionFlag = true;
            if (log.isDebugEnabled()) {
                log.debug((Object)(method + "JMS Exception caught trying to reconnect"), (Throwable)ex);
            }
            for (int i = 0; i < 3; ++i) {
                log.warn((Object)(method + "JMS connection has problems, trying to re-create it, attempt " + (i + 1) + " ..."), (Throwable)ex);
                try {
                    this.connect.close();
                }
                catch (Throwable e) {
                    // empty catch block
                }
                boolean connected = JMSConnectionUtil.this.establishJMSConnection(this.subscriberId, this.listener, this.selector, this.informantClient);
                if (connected) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(method + "JMS connection re-established."));
                    }
                    this.cleanUp();
                    return;
                }
                if (i + 1 < 3) {
                    log.warn((Object)(method + "Re-creating JMS connection failed, retrying ..."));
                    continue;
                }
                log.error((Object)(method + "Cannot re-establish JMS connection, giving up!"));
            }
            this.cleanUp();
        }

        private void cleanUp() {
            try {
                if (this.equals(this.connect.getExceptionListener())) {
                    this.connect.setExceptionListener(null);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.subscriberId = null;
            this.connect = null;
            this.selector = null;
            this.listener = null;
            this.informantClient = null;
        }
    }
}

