/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.custom;

import de.proveo.wwt.datamodel.custom.CustomScript;
import de.proveo.wwt.logic.ejb.general.jms.JMSClient;
import de.proveo.wwt.logic.ejb.general.jms.JMSConnectionUtil;
import de.proveo.wwt.logic.ejb.general.jms.JMSMessageListener;
import groovy.lang.GroovyClassLoader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScriptLoader<S> {
    private static final Log log = LogFactory.getLog(ScriptLoader.class);
    private final Map<Integer, Object> compiledScriptCache = new HashMap<Integer, Object>();
    private final GroovyClassLoader groovyClassLoader = new GroovyClassLoader();

    public ScriptLoader() {
        JMSReceiver receiver = new JMSReceiver(this.compiledScriptCache);
        JMSConnectionUtil.getInstance().establishJMSConnection(receiver.toString(), receiver, "TypeOfInterest='customScriptMessage'", null);
    }

    protected void checkLanguage(CustomScript customScript) {
        if (!customScript.getLanguage().equalsIgnoreCase("Groovy")) {
            throw new IllegalArgumentException("unsupported script language '" + customScript.getLanguage() + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadLib(CustomScript customScript) throws Exception {
        Integer scriptId = customScript.getScriptId();
        Map<Integer, Object> map = this.compiledScriptCache;
        synchronized (map) {
            if (!this.compiledScriptCache.containsKey(scriptId)) {
                Class groovyClass = this.parseClass(customScript);
                this.compiledScriptCache.put(scriptId, groovyClass);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S loadScript(CustomScript customScript) throws Exception {
        Object ret;
        Integer scriptId = customScript.getScriptId();
        Map<Integer, Object> map = this.compiledScriptCache;
        synchronized (map) {
            if (!this.compiledScriptCache.containsKey(scriptId)) {
                Class groovyClass = this.parseClass(customScript);
                ret = groovyClass.newInstance();
                this.compiledScriptCache.put(scriptId, ret);
            } else {
                ret = this.compiledScriptCache.get(scriptId);
            }
        }
        return (S)ret;
    }

    protected Class parseClass(CustomScript customScript) {
        this.checkLanguage(customScript);
        return this.groovyClassLoader.parseClass((InputStream)new ByteArrayInputStream(customScript.getSource()));
    }

    private static class JMSReceiver
    extends JMSMessageListener {
        private final Map<Integer, Object> compiledScriptCache;

        public JMSReceiver(Map<Integer, Object> compiledScriptCache) {
            this.compiledScriptCache = compiledScriptCache;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(Message message) {
            String method = "onMessage(): ";
            try {
                if (message instanceof ObjectMessage) {
                    ObjectMessage oMessage = (ObjectMessage)message;
                    Serializable _object = oMessage.getObject();
                    if (_object != null) {
                        String customScriptIdAsString = _object.toString();
                        try {
                            Integer customScriptId = Integer.parseInt(customScriptIdAsString);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)(method + "CustomScript with ID '" + customScriptIdAsString + "' got invalid, will force rebuild for next caller ..."));
                            }
                            Map<Integer, Object> map = this.compiledScriptCache;
                            synchronized (map) {
                                Object cachedObj = this.compiledScriptCache.remove(customScriptId);
                                if (cachedObj != null && cachedObj instanceof Class) {
                                    Class cachedClass = (Class)cachedObj;
                                    HashSet<Integer> keys = new HashSet<Integer>(this.compiledScriptCache.keySet());
                                    for (Integer scriptId : keys) {
                                        Object c = this.compiledScriptCache.get(scriptId);
                                        if (c == null || c instanceof Class || !cachedClass.isInstance(c)) continue;
                                        if (log.isDebugEnabled()) {
                                            log.debug((Object)(method + "CustomScript with ID '" + scriptId + "' got also invalid because it depends on CustomScript with ID '" + customScriptIdAsString + "', will force rebuild for next caller ..."));
                                        }
                                        this.compiledScriptCache.remove(scriptId);
                                    }
                                }
                            }
                        }
                        catch (NumberFormatException ex) {
                            log.error((Object)(method + "Could not handle message. Object of ObjectMessage isn't an Integer (CustomScript ID). Object=" + customScriptIdAsString));
                        }
                    } else {
                        log.error((Object)(method + "Could not handle message. Object of ObjectMessage is null. Object=" + _object));
                    }
                } else {
                    log.error((Object)(method + "Could not handle message. Message isn't an instance of ObjectMessage. Message=" + message));
                }
                message.acknowledge();
            }
            catch (JMSException e) {
                log.error((Object)(method + "runs into JMSException: "), (Throwable)e);
            }
            catch (Throwable ex) {
                log.error((Object)(method + "runs into unknown exception"), ex);
            }
        }

        @Override
        public void setJMSClient(JMSClient client) {
        }
    }
}

