/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.config;

import de.proveo.wwt.logic.ejb.general.config.ConfigurationLocal;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationParameterNotFoundException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.naming.InitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigurationClient {
    private static final Log log = LogFactory.getLog(ConfigurationClient.class);
    private static ConfigurationLocal configuration;
    private static final Object configSyncLock;

    public String getParameter(String key) throws ConfigurationParameterNotFoundException, RemoteException {
        this.init();
        return configuration.getParameter(key);
    }

    public String getParameter(String key, String defaultValue) throws RemoteException {
        this.init();
        return configuration.getParameter(key, defaultValue);
    }

    public boolean getBoolean(String key) throws ConfigurationParameterNotFoundException, RemoteException {
        this.init();
        return configuration.getBoolean(key);
    }

    public int getInteger(String key) throws ConfigurationParameterNotFoundException, RemoteException {
        this.init();
        return configuration.getInteger(key);
    }

    public InetAddress getInetAddress(String key) throws ConfigurationParameterNotFoundException, RemoteException, UnknownHostException {
        this.init();
        return configuration.getInetAddress(key);
    }

    public long[] getLongArray(String key) throws ConfigurationParameterNotFoundException, RemoteException {
        this.init();
        return configuration.getLongArray(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() throws RemoteException {
        if (configuration == null) {
            Object object = configSyncLock;
            synchronized (object) {
                try {
                    InitialContext context = new InitialContext();
                    configuration = (ConfigurationLocal)context.lookup("rts/Configuration/local");
                }
                catch (Exception ex) {
                    log.trace((Object)"no Configuration EJB Refernce found. Use physical lookup");
                }
                if (configuration == null) {
                    try {
                        InitialContext ctx = new InitialContext();
                        configuration = (ConfigurationLocal)ctx.lookup("rts/Configuration/local");
                    }
                    catch (Exception ex) {
                        throw new RemoteException(ex.getMessage());
                    }
                }
            }
        }
    }

    public boolean isConfigured(String key) throws RemoteException {
        this.init();
        return configuration.isConfigured(key);
    }

    public String[] getParameterArray(String key) throws ConfigurationParameterNotFoundException, RemoteException {
        this.init();
        return configuration.getParameterArray(key);
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        try {
            if (configuration == null) {
                this.init();
            }
            properties = configuration.getProperties();
        }
        catch (RemoteException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return properties;
    }

    public Properties getDefaultProperties() {
        return configuration.getDefaultProperties();
    }

    static {
        configSyncLock = new Object();
    }
}

