/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.entityListener;

import de.proveo.wwt.datamodel.module.ModuleType;
import de.proveo.wwt.datamodel.resourceString.ResourceString;
import de.proveo.wwt.datamodel.stateModel.State;
import de.proveo.wwt.datamodel.stateModel.StateModel;
import de.proveo.wwt.logic.web.admin.PermissionUpdateNotifyLocal;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StateModelListener {
    private static final Log log = LogFactory.getLog(StateModelListener.class);
    private PermissionUpdateNotifyLocal permissionUpdateNotify = null;
    private boolean initialized = false;

    @PostPersist
    public void postPersist(Object object) {
        if (this.isStateModelRelevant(object)) {
            log.debug((Object)("StateModelListener - postPersist: " + object.toString()));
            this.init();
            this.permissionUpdateNotify.sendStateModelChangedJMSMessage(object, "StateModelCreateMessage");
        }
    }

    @PostUpdate
    public void postUpdate(Object object) {
        if (this.isStateModelRelevant(object)) {
            log.debug((Object)("StateModelListener - postUpdate: " + object.toString()));
            this.init();
            this.permissionUpdateNotify.sendStateModelChangedJMSMessage(object, "StateModelUpdateMessage");
        }
    }

    @PostRemove
    public void postRemove(Object object) {
        if (this.isStateModelRelevant(object)) {
            log.debug((Object)("StateModelListener - postRemove: " + object.toString()));
            this.init();
            this.permissionUpdateNotify.sendStateModelChangedJMSMessage(object, "StateModelRemoveMessage");
        }
    }

    private synchronized void init() {
        if (!this.initialized) {
            try {
                InitialContext context = new InitialContext();
                this.permissionUpdateNotify = (PermissionUpdateNotifyLocal)context.lookup("rts/PermissionUpdateNotify/local");
                this.initialized = true;
            }
            catch (NamingException e) {
                log.error((Object)"StateModelListener.init() runs into NamingException", (Throwable)e);
            }
        }
    }

    private boolean isStateModelRelevant(Object object) {
        return object instanceof ResourceString && ((ResourceString)((Object)object)).getModuleId() == ModuleType.STATE_MODEL.getValue().intValue() || object instanceof StateModel || object instanceof State;
    }
}

