/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.entityListener;

import de.proveo.wwt.logic.web.admin.PermissionUpdateNotifyLocal;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MeasurementListener {
    private static final Log log = LogFactory.getLog(MeasurementListener.class);
    private PermissionUpdateNotifyLocal permissionUpdateNotify = null;
    private boolean initialized = false;

    @PostPersist
    public void postPersist(Object object) {
        if (this.isRelevant(object)) {
            log.debug((Object)("MeasurementListener - postPersist: " + object.toString()));
            this.init();
            this.permissionUpdateNotify.sendMeasurementChangedJMSMessage(object, "MeasurementCreateMessage");
        }
    }

    @PostUpdate
    public void postUpdate(Object object) {
        if (this.isRelevant(object)) {
            log.debug((Object)("MeasurementListener - postUpdate: " + object.toString()));
            this.init();
            this.permissionUpdateNotify.sendMeasurementChangedJMSMessage(object, "MeasurementUpdateMessage");
        }
    }

    @PostRemove
    public void postRemove(Object object) {
        if (this.isRelevant(object)) {
            log.debug((Object)("MeasurementListener - postRemove: " + object.toString()));
            this.init();
            this.permissionUpdateNotify.sendMeasurementChangedJMSMessage(object, "MeasurementRemoveMessage");
        }
    }

    private synchronized void init() {
        if (!this.initialized) {
            try {
                InitialContext context = new InitialContext();
                this.permissionUpdateNotify = (PermissionUpdateNotifyLocal)context.lookup("rts/PermissionUpdateNotify/local");
                this.initialized = true;
            }
            catch (NamingException e) {
                log.error((Object)"MeasurementListener.init() runs into NamingException", (Throwable)e);
            }
        }
    }

    private boolean isRelevant(Object object) {
        return true;
    }
}

