/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataOut.audit;

import de.proveo.util.jpa.entity.EntityBase;
import de.proveo.util.reflection.ReflectionUtil;
import de.proveo.wwt.logic.ejb.dataOut.audit.AuditAddOrRemoveInfo;
import de.proveo.wwt.logic.ejb.dataOut.audit.AuditInfo;
import de.proveo.wwt.logic.ejb.dataOut.audit.AuditRelevant;
import de.proveo.wwt.logic.ejb.dataOut.audit.AuditUpdateInfo;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;
import org.hibernate.proxy.HibernateProxy;

public class AuditUtil {
    private static final Log log = LogFactory.getLog(AuditUtil.class);

    public static <T extends EntityBase> AuditInfo generateAuditInfo(T oldObject, T newObject) {
        ArrayList<Field> relevantFields = new ArrayList<Field>();
        ArrayList<Field> relevantCollections = new ArrayList<Field>();
        T dataObject = oldObject != null ? oldObject : newObject;
        Field[] fields = ReflectionUtil.getAllDeclaredFields(dataObject.getClass());
        for (int i = 0; i != fields.length; ++i) {
            Field field = fields[i];
            if (field.getAnnotation(AuditRelevant.class) == null) continue;
            Object currentObject = ReflectionUtil.getFieldContent((Field)field, dataObject);
            if (currentObject instanceof Collection) {
                relevantCollections.add(field);
                continue;
            }
            relevantFields.add(field);
        }
        AuditInfo auditInfo = new AuditInfo();
        AuditUtil.compareFields(auditInfo, oldObject, newObject, relevantFields);
        AuditUtil.compareCollections(auditInfo, oldObject, newObject, relevantCollections);
        return auditInfo;
    }

    private static <T> void compareFields(AuditInfo auditInfo, T oldObject, T newObject, List<Field> relevantFields) {
        Map<String, AuditUpdateInfo> updated = auditInfo.updated;
        Map<String, String> direct = auditInfo.direct;
        for (Field field : relevantFields) {
            Object oldValue = ReflectionUtil.getFieldContent((Field)field, oldObject);
            Object newValue = ReflectionUtil.getFieldContent((Field)field, newObject);
            if (oldValue instanceof HibernateProxy) {
                oldValue = ((HibernateProxy)oldValue).getHibernateLazyInitializer().getImplementation();
            }
            if (newValue instanceof HibernateProxy) {
                newValue = ((HibernateProxy)newValue).getHibernateLazyInitializer().getImplementation();
            }
            if (oldValue != null && newValue != null && oldValue.equals(newValue) || oldValue == null && newValue == null) continue;
            AuditRelevant auditRelevant = field.getAnnotation(AuditRelevant.class);
            if (auditRelevant.hideValue()) {
                oldValue = null;
                newValue = null;
            }
            String fieldName = AuditUtil.generateFieldName(field);
            if (AuditUtil.isDeep(field)) {
                if (oldValue instanceof EntityBase || newValue instanceof EntityBase) {
                    AuditInfo info = AuditUtil.generateAuditInfo((EntityBase)oldValue, (EntityBase)newValue);
                    direct.put(fieldName, info.toString());
                    continue;
                }
                updated.put(fieldName, new AuditUpdateInfo(oldValue, newValue));
                continue;
            }
            if (oldValue instanceof EntityBase) {
                oldValue = ((EntityBase)oldValue).toAuditString();
            }
            if (newValue instanceof EntityBase) {
                newValue = ((EntityBase)newValue).toAuditString();
            }
            updated.put(fieldName, new AuditUpdateInfo(oldValue, newValue));
        }
    }

    private static <T extends EntityBase> void compareCollections(AuditInfo auditInfo, T oldObject, T newObject, List<Field> relevantCollections) {
        Map<String, AuditAddOrRemoveInfo> addedOrRemoved = auditInfo.addedOrRemoved;
        for (Field field : relevantCollections) {
            ArrayList added = new ArrayList();
            ArrayList removed = new ArrayList();
            AuditRelevant auditRelevant = field.getAnnotation(AuditRelevant.class);
            if (!auditRelevant.hideValue()) {
                ArrayList oldCollection = (ArrayList)ReflectionUtil.getFieldContent((Field)field, oldObject);
                ArrayList newCollection = (ArrayList)ReflectionUtil.getFieldContent((Field)field, newObject);
                if (oldCollection == null) {
                    oldCollection = new ArrayList();
                }
                if (newCollection == null) {
                    newCollection = new ArrayList();
                }
                if (oldCollection.size() == 0 && newCollection.size() == 0) continue;
                if (oldCollection.size() == 0 && newCollection.size() != 0) {
                    added.addAll(newCollection);
                } else if (oldCollection.size() != 0 && newCollection.size() == 0) {
                    removed.addAll(oldCollection);
                } else {
                    added.addAll(newCollection);
                    added.removeAll(oldCollection);
                    removed.addAll(oldCollection);
                    removed.removeAll(newCollection);
                }
            }
            if (added.size() == 0 && removed.size() == 0 && !auditRelevant.hideValue()) continue;
            addedOrRemoved.put(AuditUtil.generateFieldName(field), new AuditAddOrRemoveInfo(added, removed));
        }
    }

    private static boolean isDeep(Field field) {
        AuditRelevant auditRelevant = field.getAnnotation(AuditRelevant.class);
        return auditRelevant.deep();
    }

    private static String generateFieldName(Field field) {
        StringBuilder sb = new StringBuilder("${");
        sb.append(field.getName());
        sb.append("}");
        return sb.toString();
    }

    private static FetchType getFetchType(Field field) {
        FetchType fetchType = null;
        try {
            field = field.getDeclaringClass().getDeclaredField(field.getName());
            ManyToMany annotation = field.getAnnotation(ManyToMany.class);
            if (annotation != null) {
                fetchType = annotation.fetch();
            } else {
                annotation = field.getAnnotation(OneToMany.class);
                if (annotation != null) {
                    fetchType = ((OneToMany)annotation).fetch();
                } else {
                    annotation = field.getAnnotation(ManyToOne.class);
                    if (annotation != null) {
                        fetchType = ((ManyToOne)annotation).fetch();
                    } else {
                        annotation = field.getAnnotation(OneToOne.class);
                        if (annotation != null) {
                            fetchType = ((OneToOne)annotation).fetch();
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Runs into", (Throwable)e);
        }
        return fetchType;
    }

    public static <T extends EntityBase> void initialize(T object) {
        Hibernate.initialize(object);
        Field[] fields = object.getClass().getDeclaredFields();
        for (int i = 0; i != fields.length; ++i) {
            AuditRelevant auditRelevant = fields[i].getAnnotation(AuditRelevant.class);
            if (auditRelevant == null) continue;
            Object fieldContent = ReflectionUtil.getFieldContent((Field)fields[i], object);
            if (auditRelevant.deep() && fieldContent instanceof EntityBase) {
                AuditUtil.initialize((EntityBase)fieldContent);
                continue;
            }
            FetchType fetchType = AuditUtil.getFetchType(fields[i]);
            if (fetchType == null || fetchType != FetchType.LAZY) continue;
            Hibernate.initialize((Object)fieldContent);
        }
    }
}

