/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.event.handlers;

import de.proveo.eventbase.EventResponse;
import de.proveo.rts.configuration.infoman.InfomanEventServiceMBean;
import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.util.service.ServiceFactory;
import de.proveo.wwt.datamodel.image.ImageType;
import de.proveo.wwt.datamodel.unit.identity.UnitIdentity;
import de.proveo.wwt.datamodel.unit.model.UnitModel;
import de.proveo.wwt.datamodel.unit.typeIdentity.UnitTypeIdentity;
import de.proveo.wwt.logic.ejb.dataIn.event.EventInfo;
import de.proveo.wwt.logic.ejb.dataIn.event.EventResult;
import de.proveo.wwt.logic.ejb.dataIn.event.handlers.IEventHandler;
import de.proveo.wwt.logic.ejb.general.image.ImageTypeFacadeLocal;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeLocal;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.naming.InitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UnitValidationEventHandler
implements IEventHandler {
    private static final Log log = LogFactory.getLog(UnitValidationEventHandler.class);
    private InfomanEventServiceMBean infomanEventService;
    private UnitFacadeLocal unitFacade;
    private ImageTypeFacadeLocal imageTypeFacade;

    @Override
    public EventResult handleEvent(Properties event, EventResponse eventResponse, EventInfo eventInfo, ArrayList<SerializableEventWrapper> eventWrappers) {
        if (this.infomanEventService.isUnitIdBlocking(eventInfo.unitIds)) {
            eventResponse.setEventResponse(false);
            return EventResult.SUCCESS_BUT_STOP_HANDLER_CHAIN;
        }
        int numUnits = eventInfo.unitIds.length;
        eventInfo.unitModels = new UnitModel[numUnits];
        for (int i = 0; i != numUnits; ++i) {
            long unitId = eventInfo.unitIds[i];
            UnitModel unitModel = this.unitFacade.getUnitModel(unitId);
            if (unitModel == null) {
                if (this.infomanEventService.isLazyCreateOfMasterdataByEvents()) {
                    try {
                        UnitTypeIdentity type;
                        List<UnitTypeIdentity> unitTypes = this.unitFacade.findAllUnitTypeidentity();
                        if (unitTypes.isEmpty()) {
                            type = new UnitTypeIdentity();
                            type.setName("test");
                            List<ImageType> allTypes = this.imageTypeFacade.getImageTypes();
                            ImageType imageType = allTypes.get(2);
                            type.setImageName(imageType.getName());
                            type.setImageTypeId(imageType.getId());
                            long id = this.unitFacade.insertUnitTypeFlush(type);
                            type = this.unitFacade.getUnitTypeById(id);
                        } else {
                            type = unitTypes.get(0);
                        }
                        long id = this.unitFacade.insertUnitFlush(this.getUnitDTO(unitId, type), type.getId(), false);
                        unitModel = this.unitFacade.getUnitModel(id);
                    }
                    catch (Exception ex) {
                        log.error((Object)"Can't create unit", (Throwable)ex);
                    }
                } else {
                    log.warn((Object)("Unit not found: " + String.valueOf(unitId)));
                    return EventResult.ERROR;
                }
            }
            if (!unitModel.getBasic()) {
                throw new IllegalArgumentException("Cannot accept an event of a group unit");
            }
            if (unitModel.getDeleted()) {
                throw new IllegalArgumentException("Cannot accept an event of a deleted unit");
            }
            eventInfo.unitModels[i] = unitModel;
        }
        return EventResult.SUCCESS;
    }

    @Override
    public void initialize() {
        try {
            this.infomanEventService = (InfomanEventServiceMBean)ServiceFactory.getInstance().getService(InfomanEventServiceMBean.class);
            InitialContext context = new InitialContext();
            this.unitFacade = (UnitFacadeLocal)context.lookup("rts/UnitFacade/local");
            this.imageTypeFacade = (ImageTypeFacadeLocal)context.lookup("rts/ImageTypeFacade/local");
        }
        catch (Exception e) {
            log.error((Object)"Runs into", (Throwable)e);
        }
    }

    private UnitDTO getUnitDTO(long unitId, UnitTypeIdentity type) {
        UnitModel mod = new UnitModel(unitId, true);
        UnitIdentity ident = new UnitIdentity();
        String name = "Unit_" + Long.toString(unitId);
        ident.setUnitId(unitId);
        ident.setName(name);
        UnitDTO dto = new UnitDTO(mod, ident, type);
        return dto;
    }
}

