/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.event.handlers;

import de.proveo.eventbase.EventResponse;
import de.proveo.rts.configuration.monitor.MonitoringMBean;
import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.util.service.ServiceFactory;
import de.proveo.wwt.datamodel.state.StateHistory;
import de.proveo.wwt.datamodel.use.user.UseUser;
import de.proveo.wwt.logic.app.state.StateModel;
import de.proveo.wwt.logic.app.state.StateModelFactory;
import de.proveo.wwt.logic.app.state.event.StateEvent;
import de.proveo.wwt.logic.app.state.exception.ChangeNotAllowedException;
import de.proveo.wwt.logic.app.state.exception.InternalStateModelException;
import de.proveo.wwt.logic.app.state.exception.StateModelNotFoundException;
import de.proveo.wwt.logic.ejb.dataIn.event.EventInfo;
import de.proveo.wwt.logic.ejb.dataIn.event.EventResult;
import de.proveo.wwt.logic.ejb.dataIn.event.handlers.IEventHandler;
import de.proveo.wwt.logic.ejb.dataIn.event.handlers.UseEventHandler;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.useuser.UseUserAdminFacadeLocal;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationLocal;
import de.proveo.wwt.logic.ejb.state.CurrentStateFacadeLocal;
import de.proveo.wwt.logic.ejb.state.CurrentStateFacadeStruct;
import de.proveo.wwt.logic.ejb.transaction.ImplicitRollbackException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import javax.ejb.EJBException;
import javax.naming.InitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StateEventHandler
implements IEventHandler {
    private static final Log log = LogFactory.getLog(StateEventHandler.class);
    protected static final String CONFIG_GEN_USE = "events.use.serverside";
    protected static final String CONFIG_GEN_USE_STATEMODEL_ID = "events.use.serverside.triggerStateModelId";
    protected static final String CONFIG_GEN_USE_LOGIN_STATE_ID = "events.use.serverside.loginTriggerStateId";
    protected static final String CONFIG_GEN_USE_LOGOFF_STATE_ID = "events.use.serverside.logoffTriggerStateId";
    protected static final String CONFIG_GEN_USE_USER_ID = "events.use.serverside.defaultUserId";
    private boolean createUseEvents = false;
    private long triggerStateModelId;
    private long[] loginTriggerStateIds;
    private long[] logoffTriggerStateIds;
    private long defaultUserId;
    private MonitoringMBean stateEventCounter;
    private ConfigurationLocal configuration;
    private CurrentStateFacadeLocal currentStateFacade;
    private UseUserAdminFacadeLocal useUserFacade;

    @Override
    public EventResult handleEvent(Properties event, EventResponse eventResponse, EventInfo eventInfo, ArrayList<SerializableEventWrapper> eventWrappers) {
        EventResult result = EventResult.SUCCESS;
        if (event.containsKey("m")) {
            int numUnits = eventInfo.unitIds.length;
            for (int i = 0; i != numUnits; ++i) {
                if (this.handleStateEvent(event, eventInfo.unitIds[i], eventInfo, eventWrappers)) continue;
                result = EventResult.ERROR;
                break;
            }
        }
        return result;
    }

    private boolean handleStateEvent(Properties event, long unitId, EventInfo eventInfo, ArrayList<SerializableEventWrapper> eventWrappers) {
        boolean success = false;
        log.debug((Object)"handleStateEvent() new event of type 'unit state'...");
        this.stateEventCounter.increment();
        int stateModelId = Integer.parseInt(event.getProperty("m"));
        int stateId = Integer.parseInt(event.getProperty("s"));
        long timestamp = Long.parseLong(event.getProperty("t"));
        long receiveTime = eventInfo.receiveTime;
        String remark = event.getProperty("c");
        StateModelFactory stateModelFactory = new StateModelFactory();
        try {
            StateModel serviceStateModel;
            if (stateModelId == 2050 && (serviceStateModel = stateModelFactory.getStateModel(2090, unitId)).getCurrentStateId() != null && serviceStateModel.getCurrentStateId() != 2091) {
                log.debug((Object)"handleStateEvent() event discarded. (OperationState event not accepted while OutOfServiceState is not OPERATIVE or INITIAL)");
                return true;
            }
            StateModel stateModel = stateModelFactory.getStateModel(stateModelId, unitId);
            StateEvent stateEvent = new StateEvent(unitId, stateModelId, stateId, timestamp, receiveTime, remark);
            stateEvent.setAreaId(eventInfo.areaId);
            stateEvent.setGdataHistoryId(eventInfo.gdataHistoryId);
            if (eventInfo.areaId != null && eventInfo.areaId != 0) {
                stateEvent.setAreaTrusted(eventInfo.areaTrusted);
            }
            stateEvent.setUser(eventInfo.useUser);
            SerializableEventWrapper wrapper = stateModel.changeState(stateEvent);
            if (wrapper != null) {
                eventWrappers.add(wrapper);
                try {
                    this.updateDependendStateModels(stateEvent, (StateHistory)wrapper.get_historyValue(), eventWrappers);
                }
                catch (Exception ex) {
                    String msg = "changeState() runs into Exception " + ex.toString();
                    log.error((Object)msg, (Throwable)ex);
                    throw new ImplicitRollbackException(msg);
                }
            }
            success = true;
        }
        catch (Exception ex) {
            log.error((Object)"handleStateEvent() runs into ", (Throwable)ex);
        }
        if (this.createUseEvents) {
            if ((long)stateModelId == this.triggerStateModelId) {
                this.handleAutoGenUseEvent(event, receiveTime, unitId, eventInfo, eventWrappers);
            } else {
                log.debug((Object)"handleStateEvent() creating use event not necessary");
            }
        } else {
            log.debug((Object)"handleStateEvent() creating use event disabled");
        }
        return success;
    }

    protected boolean handleAutoGenUseEvent(Properties event, long receiveTime, long unitId, EventInfo eventInfo, ArrayList<SerializableEventWrapper> eventWrappers) {
        UseUser useUserValue;
        boolean logoff;
        long stateId = Long.parseLong(event.getProperty("s"));
        boolean login = Arrays.binarySearch(this.loginTriggerStateIds, stateId) >= 0;
        boolean bl = logoff = Arrays.binarySearch(this.logoffTriggerStateIds, stateId) >= 0;
        if (!login && !logoff) {
            return false;
        }
        if (login && logoff) {
            if (log.isErrorEnabled()) {
                log.error((Object)("handleAutoGenUseEvent() configuration problem get a event with stateId '" + stateId + "' and should trigger a login and a logoff at the same time?"));
            }
            return false;
        }
        try {
            useUserValue = this.useUserFacade.getUseUserById(this.defaultUserId);
            if (useUserValue == null) {
                log.warn((Object)("No UseUser with default ID: " + this.defaultUserId));
                return false;
            }
        }
        catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Cannot get default user '" + this.defaultUserId + "'"), (Throwable)ex);
            }
            return false;
        }
        log.debug((Object)"handleAutoGenUseEvent() process autogenerated UseEvent");
        try {
            Properties properties = new Properties();
            properties.put("t", String.valueOf(event.getProperty("t")));
            properties.put("uu", useUserValue.getKeyId());
            properties.put("ul", String.valueOf(login));
            UseEventHandler useEventHandler = new UseEventHandler();
            useEventHandler.initialize();
            useEventHandler.handleUseEvent(event, unitId, eventInfo, eventWrappers);
            return true;
        }
        catch (Exception ex) {
            log.error((Object)"Cannot process UseEvent", (Throwable)ex);
            return false;
        }
    }

    protected void updateDependendStateModels(StateEvent event, StateHistory previousState, ArrayList<SerializableEventWrapper> eventWrappers) throws StateModelNotFoundException, ChangeNotAllowedException, InternalStateModelException {
        StateModelFactory stateModelFactory = new StateModelFactory();
        if (event.getStateModelId() == 2090) {
            StateModel operationStateModel;
            int newGseAssignmentState;
            int stateId = event.getStateId();
            if (stateId == 2092 || stateId == 2094 || stateId == 2093 || stateId == 2095 || stateId == 2096) {
                log.debug((Object)"change GSE assignment state to unserviceable");
                newGseAssignmentState = 2124;
            } else {
                log.debug((Object)"change GSE assignment state to available");
                newGseAssignmentState = 2123;
            }
            StateModel stateModel = stateModelFactory.getStateModel(2120, event.getUnitId());
            CurrentStateFacadeStruct currentState = this.currentStateFacade.getCurrentState(event.getUnitId(), 2120);
            String currentRemark = currentState != null ? currentState.getRemark() : "";
            StateEvent depEvent = new StateEvent(event.getUnitId(), 2120, newGseAssignmentState, event.getTimestamp(), event.getReceiveTime(), currentRemark);
            SerializableEventWrapper wrapper = stateModel.changeState(depEvent);
            eventWrappers.add(wrapper);
            if (event.getStateId() != 2091) {
                depEvent = new StateEvent(event.getUnitId(), 2050, 2051, event.getTimestamp(), event.getReceiveTime(), "");
                operationStateModel = stateModelFactory.getStateModel(2050, event.getUnitId());
                wrapper = operationStateModel.changeState(depEvent);
                eventWrappers.add(wrapper);
            }
            if (event.getStateId() == 2091) {
                depEvent = new StateEvent(event.getUnitId(), 2050, 2054, event.getTimestamp(), event.getReceiveTime(), "");
                operationStateModel = stateModelFactory.getStateModel(2050, event.getUnitId());
                wrapper = operationStateModel.changeState(depEvent);
                eventWrappers.add(wrapper);
            }
        }
        if (event.getStateModelId() == 2050 && event.getStateId() != 2051 && previousState == null) {
            log.debug((Object)"operation state changed from UNKNOWN to other..., change also service state to OPERATIVE");
            StateEvent depEvent = new StateEvent(event.getUnitId(), 2090, 2091, event.getTimestamp(), event.getReceiveTime(), "");
            StateModel serviceStateModel = stateModelFactory.getStateModel(2090, event.getUnitId());
            SerializableEventWrapper wrapper = serviceStateModel.changeState(depEvent);
            eventWrappers.add(wrapper);
        }
        if (event.getStateModelId() == 2110 && (event.getStateId() == 2111 || event.getStateId() == 2113)) {
            StateEvent offlineEvent = new StateEvent(event.getUnitId(), 2140, 2142, event.getReceiveTime(), event.getReceiveTime(), "");
            StateModel infomanOnlineStateModel = stateModelFactory.getStateModel(2140, event.getUnitId());
            SerializableEventWrapper onlineWrapper = infomanOnlineStateModel.changeState(offlineEvent);
            eventWrappers.add(onlineWrapper);
        }
    }

    @Override
    public void initialize() {
        try {
            this.stateEventCounter = (MonitoringMBean)ServiceFactory.getInstance().getService(MonitoringMBean.class, "StateEvents");
            InitialContext context = new InitialContext();
            this.configuration = (ConfigurationLocal)context.lookup("rts/Configuration/local");
            this.currentStateFacade = (CurrentStateFacadeLocal)context.lookup("rts/CurrentStateFacade/local");
            this.useUserFacade = (UseUserAdminFacadeLocal)context.lookup("rts/UseUserAdminFacade/local");
        }
        catch (Exception e) {
            log.error((Object)"StateEventHandler() runs into", (Throwable)e);
            throw new EJBException("EJB reference problem", e);
        }
        try {
            this.createUseEvents = Boolean.parseBoolean(this.configuration.getParameter(CONFIG_GEN_USE));
            if (this.createUseEvents) {
                this.triggerStateModelId = Long.parseLong(this.configuration.getParameter(CONFIG_GEN_USE_STATEMODEL_ID));
                this.defaultUserId = Long.parseLong(this.configuration.getParameter(CONFIG_GEN_USE_USER_ID));
                this.loginTriggerStateIds = this.configuration.getLongArray(CONFIG_GEN_USE_LOGIN_STATE_ID);
                this.logoffTriggerStateIds = this.configuration.getLongArray(CONFIG_GEN_USE_LOGOFF_STATE_ID);
                Arrays.sort(this.loginTriggerStateIds);
                Arrays.sort(this.logoffTriggerStateIds);
            }
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Paramter events.use.serverside not found. Servers side use events are disabled", (Throwable)e);
            }
            this.createUseEvents = false;
        }
    }
}

