/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.event.handlers;

import de.proveo.eventbase.EventResponse;
import de.proveo.rts.configuration.infoman.InfomanEventServiceMBean;
import de.proveo.rts.configuration.monitor.MonitoringMBean;
import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.util.service.ServiceFactory;
import de.proveo.wwt.datamodel.measurement.MeasurementCache;
import de.proveo.wwt.datamodel.measurement.MeasurementDefinition;
import de.proveo.wwt.datamodel.measurement.MeasurementHistory;
import de.proveo.wwt.datamodel.measurement.MeasurementInterval;
import de.proveo.wwt.datamodel.measurement.MeasurementIntervalDefn;
import de.proveo.wwt.datamodel.measurement.MeasurementType;
import de.proveo.wwt.datamodel.measurement.MeasurementUnit;
import de.proveo.wwt.logic.ejb.dataIn.event.EventInfo;
import de.proveo.wwt.logic.ejb.dataIn.event.EventResult;
import de.proveo.wwt.logic.ejb.dataIn.event.handlers.IEventHandler;
import de.proveo.wwt.logic.ejb.dataIn.event.history.EventPersisterFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.event.history.EventPersisterResult;
import de.proveo.wwt.logic.ejb.dataIn.event.triggers.measurment.MeasurementTrigger;
import de.proveo.wwt.logic.ejb.general.measurement.MeasurementEvent;
import de.proveo.wwt.logic.ejb.general.measurement.MeasurementFacadeLocal;
import de.proveo.wwt.logic.ejb.general.measurement.NoMeasurementDefinitionException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.ejb.EJBException;
import javax.naming.InitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MeasurementEventHandler
implements IEventHandler {
    private static final Log log = LogFactory.getLog(MeasurementEventHandler.class);
    private MonitoringMBean measurementEventCounter;
    private MeasurementFacadeLocal measurementFacade;
    private InfomanEventServiceMBean infomanEventService;
    private EventPersisterFacadeLocal eventPersisterFacade = null;
    private MeasurementTrigger measurementTrigger = null;

    @Override
    public EventResult handleEvent(Properties event, EventResponse eventResponse, EventInfo eventInfo, ArrayList<SerializableEventWrapper> eventWrappers) {
        EventResult result = EventResult.SUCCESS;
        if (event.containsKey("mt")) {
            int numUnits = eventInfo.unitIds.length;
            for (int i = 0; i != numUnits; ++i) {
                if (this.handleMeasurementEvent(event, eventInfo.unitIds[i], eventInfo, eventWrappers)) continue;
                return EventResult.ERROR;
            }
        }
        return result;
    }

    private boolean handleMeasurementEvent(Properties event, long unitId, EventInfo eventInfo, ArrayList<SerializableEventWrapper> eventWrappers) {
        boolean success = false;
        log.debug((Object)"handleMeasurementEvent() new event of type 'measurement'");
        this.measurementEventCounter.increment();
        long timestamp = Long.parseLong(event.getProperty("t"));
        long receiveTime = eventInfo.receiveTime;
        int measurementTypeId = Integer.parseInt(event.getProperty("mt"));
        float measurementValue = Float.parseFloat(event.getProperty("mv"));
        List<MeasurementIntervalDefn> measurementIntervalDefns = this.measurementFacade.getMeasurementIntervalDefn(measurementTypeId);
        MeasurementIntervalDefn measurementIntervalDefn = this.getMaxThresholdInterval(measurementIntervalDefns);
        MeasurementCache cache = this.measurementFacade.getMeasurementCacheByUnitAndType(unitId, measurementTypeId);
        MeasurementEvent cacheEvent = null;
        log.debug((Object)("measurementTypeId " + measurementTypeId));
        log.debug((Object)("MeasurementCache " + cache));
        log.debug((Object)("MeasurementIntervalDefn " + (Object)((Object)measurementIntervalDefn)));
        if (measurementIntervalDefn != null && cache != null) {
            long thresholdMaxDuration = timestamp - (long)(measurementIntervalDefn.getThreshold_duration_max() * 1000);
            long thresholdMinDuration = timestamp - (long)(measurementIntervalDefn.getThreshold_duration_min() * 1000);
            log.debug((Object)("thresholdMaxDuration " + thresholdMaxDuration));
            log.debug((Object)("thresholdMinDuration " + thresholdMinDuration));
            log.debug((Object)("cache.getCreateTime() " + cache.getCreateTime()));
            if (thresholdMaxDuration < cache.getCreateTime() && cache.getCreateTime() < thresholdMinDuration) {
                cacheEvent = new MeasurementEvent(cache.getUnitId(), cache.getMeasurementDefinitionId(), cache.getCreateTime(), cache.getReceiveTime(), cache.getValue());
                cacheEvent.setAreaId(cache.getAreaId());
                cacheEvent.setGdataHistoryId(cache.getGdataHistoryId());
                cacheEvent.setUser(cache.getUseUser());
                cacheEvent.setMeasurementHistory(cache.getHistory());
                log.debug((Object)("Include last cache element maxduration < creatt" + cacheEvent));
            }
        }
        MeasurementEvent measurementEvent = new MeasurementEvent(unitId, measurementTypeId, timestamp, receiveTime, measurementValue);
        measurementEvent.setAreaId(eventInfo.areaId);
        measurementEvent.setGdataHistoryId(eventInfo.gdataHistoryId);
        measurementEvent.setUser(eventInfo.useUser);
        if (cacheEvent != null) {
            log.debug((Object)("Adding measurement cache to event. " + cacheEvent));
            measurementEvent.setCachedMeasurementEvent(cacheEvent);
        }
        try {
            SerializableEventWrapper wrapper = this.event(measurementEvent);
            if (wrapper != null) {
                wrapper.set_typeOfEvent("MeasurementHistoryAndCache");
                eventWrappers.add(wrapper);
                measurementEvent.setMeasurementHistory((MeasurementHistory)wrapper.get_historyValue());
                List<MeasurementInterval> intervals = this.measurementTrigger.feedTrigger(measurementEvent);
                for (MeasurementInterval interval : intervals) {
                    interval = this.measurementFacade.createMeasurementInterval(interval);
                    wrapper = new SerializableEventWrapper();
                    wrapper.set_typeOfEvent("MeasurementInterval");
                    wrapper.setMeasurementIntervalValue((Object)interval);
                    eventWrappers.add(wrapper);
                }
            }
            success = true;
        }
        catch (NoMeasurementDefinitionException ex) {
            log.debug((Object)"handleMeasurementEvent() runs into ", (Throwable)ex);
        }
        catch (Exception ex) {
            log.error((Object)"handleMeasurementEvent() runs into ", (Throwable)ex);
        }
        return success;
    }

    private SerializableEventWrapper event(MeasurementEvent mEvent) throws NoMeasurementDefinitionException {
        int measurementDefinitionId = mEvent.getMeasurementDefinitionId();
        MeasurementDefinition measurementDefinition = this.measurementFacade.getMeasurementDefinition(measurementDefinitionId);
        if (measurementDefinition == null) {
            if (this.infomanEventService.isLazyCreateOfMasterdataByEvents()) {
                try {
                    List<MeasurementType> allType = this.measurementFacade.getMeasurementTypes();
                    if (allType.isEmpty()) {
                        MeasurementType mType = new MeasurementType();
                        String name = "exapmleName";
                        mType.setName(name);
                        mType.setEnabled(true);
                        mType = this.measurementFacade.createMeasurementTypeFlush(mType);
                        MeasurementUnit unit = new MeasurementUnit();
                        unit.setMeasurementTypeId(mType.getId());
                        unit.setFormatPattern("##.###");
                        unit.setDescription("test");
                        unit.setName("test");
                        unit = this.measurementFacade.createMeasurementUnit(unit);
                        mType.getMeasurementUnits().add(unit);
                        allType = this.measurementFacade.getMeasurementTypes();
                    }
                    MeasurementType usedMeasuremantType = allType.get(0);
                    MeasurementDefinition current = new MeasurementDefinition();
                    current.setId(measurementDefinitionId);
                    current.setMeasurementUnitId(usedMeasuremantType.getId());
                    current.setName("Definition" + measurementDefinitionId);
                    this.measurementFacade.createMeasurementDefinitionFlush(current);
                    measurementDefinition = this.measurementFacade.getMeasurementDefinition(measurementDefinitionId);
                }
                catch (Exception ex) {
                    int i = 10;
                    ++i;
                    log.error((Object)"can't create measurement", (Throwable)ex);
                }
            } else {
                log.warn((Object)("No MeasurementDefinition with id: " + measurementDefinitionId));
                throw new NoMeasurementDefinitionException("No Measurement Definition with id: " + measurementDefinitionId);
            }
        }
        MeasurementHistory mHistory = new MeasurementHistory();
        mHistory.setUnitId(mEvent.getUnitId());
        mHistory.setCreateTime(mEvent.getCreateTime());
        mHistory.setReceiveTime(mEvent.getReceiveTime());
        mHistory.setMeasurementDefinitionId(mEvent.getMeasurementDefinitionId());
        mHistory.setValue(mEvent.getValue());
        mHistory.setAreaId(mEvent.getAreaId());
        if (mEvent.getUser() != null) {
            mHistory.setUseUserId(mEvent.getUser().getId());
        }
        mHistory.setGdataHistoryId(mEvent.getGdataHistoryId());
        EventPersisterResult result = this.eventPersisterFacade.persist(mHistory, measurementDefinition.isCacheOnly());
        if (result == null) {
            return null;
        }
        SerializableEventWrapper wrapper = new SerializableEventWrapper();
        wrapper.set_cacheValue(result.cache);
        wrapper.set_historyValue(result.history);
        return wrapper;
    }

    @Override
    public void initialize() {
        try {
            this.infomanEventService = (InfomanEventServiceMBean)ServiceFactory.getInstance().getService(InfomanEventServiceMBean.class);
            this.measurementEventCounter = (MonitoringMBean)ServiceFactory.getInstance().getService(MonitoringMBean.class, "MeasurementEvents");
            this.measurementTrigger = MeasurementTrigger.getMeasurementTrigger();
            InitialContext context = new InitialContext();
            this.measurementFacade = (MeasurementFacadeLocal)context.lookup("rts/MeasurementFacade/local");
            this.eventPersisterFacade = (EventPersisterFacadeLocal)context.lookup("rts/EventPersisterFacade/local");
        }
        catch (Exception e) {
            log.error((Object)"MeasurementEventHandler() runs into", (Throwable)e);
            throw new EJBException("EJB reference problem", e);
        }
    }

    private MeasurementIntervalDefn getMaxThresholdInterval(List<MeasurementIntervalDefn> defns) {
        MeasurementIntervalDefn maxDefn = null;
        int maxThreshold = 0;
        if (defns != null) {
            for (MeasurementIntervalDefn measurementIntervalDefn : defns) {
                if (maxThreshold != 0 && measurementIntervalDefn.getThreshold_duration_max() <= maxThreshold) continue;
                maxThreshold = measurementIntervalDefn.getThreshold_duration_max();
                maxDefn = measurementIntervalDefn;
            }
        }
        return maxDefn;
    }
}

