/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.event.handlers;

import de.proveo.eventbase.EventResponse;
import de.proveo.rts.configuration.monitor.MonitoringMBean;
import de.proveo.util.geo.GPSPosition;
import de.proveo.util.geo.GPSPositionParseException;
import de.proveo.util.math.Point;
import de.proveo.util.math.PointImpl;
import de.proveo.util.math.Polygon;
import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.util.service.ServiceFactory;
import de.proveo.util.string.StringUtil;
import de.proveo.wwt.datamodel.area.Area;
import de.proveo.wwt.datamodel.area.AreaPoints;
import de.proveo.wwt.datamodel.geo.GdataCache;
import de.proveo.wwt.datamodel.geo.GdataHistory;
import de.proveo.wwt.logic.ejb.dataIn.event.EventInfo;
import de.proveo.wwt.logic.ejb.dataIn.event.EventResult;
import de.proveo.wwt.logic.ejb.dataIn.event.handlers.IEventHandler;
import de.proveo.wwt.logic.ejb.dataIn.event.history.EventPersisterFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.event.history.EventPersisterResult;
import de.proveo.wwt.logic.ejb.general.area.AreaInFacadeLocal;
import de.proveo.wwt.logic.ejb.geo.GdataFacadeLocal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.ejb.EJBException;
import javax.naming.InitialContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GeoEventHandler
implements IEventHandler {
    private static final Log log = LogFactory.getLog(GeoEventHandler.class);
    private MonitoringMBean geoEventCounter;
    private GdataFacadeLocal gdataFacade = null;
    private EventPersisterFacadeLocal eventPersisterFacade = null;
    private AreaInFacadeLocal areaInFacade = null;
    private static final int DEFAULT_MAX_REASON_LENGTH = 20;
    private static final int DEFAULT_MAX_NMEA_RECORD_LENGTH = 254;
    private int maxReasonLength = 20;

    @Override
    public EventResult handleEvent(Properties event, EventResponse eventResponse, EventInfo eventInfo, ArrayList<SerializableEventWrapper> eventWrappers) {
        if (event.containsKey("r")) {
            int numUnits = eventInfo.unitIds.length;
            for (int i = 0; i != numUnits; ++i) {
                GdataHistory gdataHistory = null;
                try {
                    gdataHistory = this.handleGeoEvent(event, eventInfo, eventInfo.unitIds[i], eventWrappers);
                }
                catch (GPSPositionParseException ex) {
                    log.error((Object)"handleEvent() runs into", (Throwable)ex);
                    return EventResult.SUCCESS;
                }
                if (i != 0 || gdataHistory == null) continue;
                eventInfo.areaId = gdataHistory.getAreaId();
                eventInfo.areaTrusted = gdataHistory.getTrusted();
                eventInfo.gdataHistoryId = gdataHistory.getId();
            }
        }
        return EventResult.SUCCESS;
    }

    public GdataHistory handleGeoEvent(Properties event, EventInfo eventInfo, long unitId, ArrayList<SerializableEventWrapper> eventWrappers) throws GPSPositionParseException {
        log.debug((Object)"Handling GEO event...");
        this.geoEventCounter.increment();
        GdataHistory gdataHistory = this.createHistory(event, eventInfo, unitId);
        this.persistEvent(gdataHistory, eventWrappers);
        return gdataHistory;
    }

    private GdataHistory createHistory(Properties event, EventInfo eventInfo, long unitId) throws GPSPositionParseException {
        Integer areaId;
        int lonMsec;
        int latMsec;
        String rmc = event.getProperty("r");
        String gga = event.getProperty("g");
        boolean trusted = Integer.parseInt(event.getProperty("v")) == 1;
        GPSPosition position = new GPSPosition(rmc = StringUtils.substring((String)rmc, (int)0, (int)254), gga = StringUtils.substring((String)gga, (int)0, (int)254));
        if (position.isParseProblem()) {
            throw new GPSPositionParseException("[" + rmc + "] [" + gga + "]");
        }
        if (trusted && !position.isValid()) {
            trusted = false;
        }
        if (!trusted) {
            GdataCache cache = this.gdataFacade.findCacheByUnitId(unitId);
            if (cache != null) {
                rmc = cache.getRmcRec();
                gga = cache.getGgaRec();
                latMsec = cache.getLatMsec();
                lonMsec = cache.getLongMsec();
                areaId = cache.getAreaId();
            } else {
                rmc = "";
                gga = "";
                latMsec = 0;
                lonMsec = 0;
                areaId = null;
            }
        } else {
            latMsec = position.getLatitudeMSec();
            lonMsec = position.getLongitudeMSec();
            areaId = this.computeArea(latMsec, lonMsec);
        }
        long beginTime = Long.parseLong(event.getProperty("t"));
        String reason = this.processReason(event);
        GdataHistory gdataHistory = new GdataHistory();
        gdataHistory.setAreaId(areaId);
        gdataHistory.setBeginReceiveTime(eventInfo.receiveTime);
        gdataHistory.setBeginTime(beginTime);
        gdataHistory.setGgaRec(gga);
        gdataHistory.setLatMsec(latMsec);
        gdataHistory.setLongMsec(lonMsec);
        gdataHistory.setReason(reason);
        gdataHistory.setRmcRec(rmc);
        gdataHistory.setTrusted(trusted);
        gdataHistory.setUnitId(unitId);
        return gdataHistory;
    }

    private String processReason(Properties event) {
        String reason;
        String oldReason = event.getProperty("x");
        if (oldReason == null) {
            reason = null;
        } else {
            reason = StringUtil.truncate((String)oldReason, (int)20);
            if (oldReason != reason && log.isWarnEnabled()) {
                log.warn((Object)StringUtil.appendStrings((String[])new String[]{"event() reason exceeded maximumlength of ", String.valueOf(this.maxReasonLength), " cutted off. orignal: ", oldReason, " cutted to: ", reason}));
            }
        }
        return reason;
    }

    private void persistEvent(GdataHistory gdataHistory, ArrayList<SerializableEventWrapper> eventWrappers) {
        EventPersisterResult result = this.eventPersisterFacade.persist(gdataHistory);
        if (result != null) {
            try {
                SerializableEventWrapper wrapper = new SerializableEventWrapper();
                wrapper.set_cacheValue(result.cache);
                wrapper.set_historyValue(result.history);
                wrapper.set_typeOfEvent("GeoStructHistoryAndCache");
                eventWrappers.add(wrapper);
            }
            catch (Exception ex) {
                log.error((Object)"persistEvent() runs into Exception: ", (Throwable)ex);
            }
        } else {
            GdataCache cache = this.gdataFacade.findCacheByUnitId(gdataHistory.getUnitId());
            gdataHistory.setId(cache.getHistoryId());
        }
    }

    public Integer computeArea(int positionLatMsec, int positionLongMsec) {
        String sMethodName = "computeArea()";
        if (log.isDebugEnabled()) {
            log.debug((Object)("computeArea() try to find areas by extremal values for position " + positionLongMsec + "/" + positionLatMsec + " (longitude/latitude)."));
        }
        Integer areaId = null;
        List<Area> areas = this.areaInFacade.findAreaByVicinity(positionLongMsec, positionLatMsec);
        int suitableAreas = areas.size();
        if (suitableAreas == 0) {
            log.warn((Object)"computeArea()   found no suitable area for given position by extremal values!");
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("computeArea()   found " + suitableAreas + " suitable areas for given position."));
            }
            int i = 0;
            Iterator areaIterator = areas.iterator();
            String areaName = "";
            while (areaIterator.hasNext()) {
                List<AreaPoints> points;
                ++i;
                Area area = (Area)areaIterator.next();
                areaName = area.getArea();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("computeArea()   found, that area '" + areaName + "/" + area.getDescription() + "' is suitable for final AREA algorithm ..."));
                }
                if ((points = area.getAreaPoints()).size() < 3) {
                    log.error((Object)("computeArea()   this area has " + points.size() + " points only ! (or JDBC bug) Check it !!"));
                    continue;
                }
                Polygon p = new Polygon(points);
                if (p.isPointInside((Point)new PointImpl((double)positionLongMsec, (double)positionLatMsec))) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("computeArea()   area '" + areaName + "' has the point inside. Priority is " + area.getPriority() + ". Break."));
                    }
                    areaId = area.getAreaId();
                    break;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("computeArea()   area '" + areaName + "' doesn't have the point inside."));
            }
            if (areaName.equals("")) {
                log.warn((Object)("computeArea() END, " + i + " suitable areas found, but none of them has the point inside!"));
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("computeArea() END, " + i + " suitable areas found, position lies inside area '" + areaName + "'."));
            }
        }
        return areaId;
    }

    @Override
    public void initialize() {
        try {
            this.geoEventCounter = (MonitoringMBean)ServiceFactory.getInstance().getService(MonitoringMBean.class, "GeoEvents");
            InitialContext context = new InitialContext();
            this.gdataFacade = (GdataFacadeLocal)context.lookup("rts/GdataFacade/local");
            this.eventPersisterFacade = (EventPersisterFacadeLocal)context.lookup("rts/EventPersisterFacade/local");
            this.areaInFacade = (AreaInFacadeLocal)context.lookup("rts/AreaInFacade/local");
        }
        catch (Exception e) {
            log.error((Object)"GeoEventHandler() runs into", (Throwable)e);
            throw new EJBException("EJB reference problem", e);
        }
    }
}

