/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.event.handlers;

import de.proveo.datasync.ejb.TaskManagementFacadeLocal;
import de.proveo.domain.values.datasync.DatasyncStatusValue;
import de.proveo.eventbase.EventPayload;
import de.proveo.eventbase.EventResponse;
import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.wwt.logic.ejb.dataIn.event.EventInfo;
import de.proveo.wwt.logic.ejb.dataIn.event.EventResult;
import de.proveo.wwt.logic.ejb.dataIn.event.handlers.EventHandlerUtil;
import de.proveo.wwt.logic.ejb.dataIn.event.handlers.IEventHandler;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationLocal;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.ejb.EJBException;
import javax.naming.InitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DatasyncHandler
implements IEventHandler {
    private static final Log log = LogFactory.getLog(DatasyncHandler.class);
    private ConfigurationLocal config = null;
    private int announcementInterval = 300000;
    private int announcementIntervalMax = 5400000;
    private TaskManagementFacadeLocal taskManagementFacade;

    @Override
    public EventResult handleEvent(Properties event, EventResponse eventResponse, EventInfo eventInfo, ArrayList<SerializableEventWrapper> eventWrappers) {
        if (!EventHandlerUtil.isTestEvent(event)) {
            List<DatasyncStatusValue> statusValues = this.getTaskStatus(eventInfo);
            if (statusValues != null && statusValues.size() > 0) {
                int payloadIndex = 0;
                for (DatasyncStatusValue datasyncStatusValue : statusValues) {
                    if (datasyncStatusValue.getStatus() != 9001 && datasyncStatusValue.getLastRetryTime() >= System.currentTimeMillis() - (long)this.announcementIntervalMax) continue;
                    EventPayload payload = new EventPayload();
                    payload.setName("DSYNC" + payloadIndex);
                    Properties props = new Properties();
                    datasyncStatusValue.getResourceIds();
                    props.setProperty("tid", String.valueOf(datasyncStatusValue.getTaskId()));
                    props.setProperty("to", String.valueOf(datasyncStatusValue.getIdentifier()));
                    props.setProperty("ti", String.valueOf(datasyncStatusValue.getTaskInfo()));
                    if (datasyncStatusValue.getResourceIds() != null) {
                        props.setProperty("trid", String.valueOf(datasyncStatusValue.getResourceIds().get(0)));
                    }
                    payload.setPayload(this.getPayloadAsBytes(props));
                    eventResponse.addPayload(payload);
                    ++payloadIndex;
                }
                log.info(statusValues);
            } else if (log.isTraceEnabled()) {
                log.trace((Object)("No task found for Unit: " + (eventInfo.unitIds.length > 0 ? Long.valueOf(eventInfo.unitIds[0]) : eventInfo.serialNumber)));
            }
        }
        return EventResult.SUCCESS;
    }

    protected List<DatasyncStatusValue> getTaskStatus(EventInfo eventInfo) {
        if (eventInfo.unitIds.length > 0) {
            long unitId = eventInfo.unitIds[0];
            return this.taskManagementFacade.findTasksStatusForEventResponse(unitId, this.announcementInterval);
        }
        return this.taskManagementFacade.getTasksByClientSNForEventResponse(eventInfo.serialNumber, eventInfo.deviceType, this.announcementInterval);
    }

    private byte[] getPayloadAsBytes(Properties properties) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            properties.store(out, "");
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        return out.toByteArray();
    }

    @Override
    public void initialize() {
        try {
            InitialContext context = new InitialContext();
            Object obj = context.lookup("datasync/TaskManagementFacade/local");
            this.taskManagementFacade = (TaskManagementFacadeLocal)obj;
            Object confObj = context.lookup("rts/Configuration/local");
            this.config = (ConfigurationLocal)confObj;
            this.announcementInterval = this.config.getInteger("datasync.announcement.interval");
            this.announcementIntervalMax = this.config.getInteger("datasync.announcement.interval_max");
        }
        catch (Exception e) {
            log.error((Object)"DatasyncHandler() runs into", (Throwable)e);
            throw new EJBException("EJB reference problem", e);
        }
    }
}

