/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.event.handlers;

import de.proveo.eventbase.EventResponse;
import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.wwt.logic.app.unit.exception.UnitNotFoundException;
import de.proveo.wwt.logic.ejb.dataIn.event.EventInfo;
import de.proveo.wwt.logic.ejb.dataIn.event.EventResult;
import de.proveo.wwt.logic.ejb.dataIn.event.handlers.IEventHandler;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.useuser.unituser.UnitUserLocal;
import java.util.ArrayList;
import java.util.Properties;
import javax.ejb.EJBException;
import javax.naming.InitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ACLEventHandler
implements IEventHandler {
    private static final Log log = LogFactory.getLog(ACLEventHandler.class);
    private UnitUserLocal unitUserFacade;

    @Override
    public EventResult handleEvent(Properties event, EventResponse eventResponse, EventInfo eventInfo, ArrayList<SerializableEventWrapper> eventWrappers) {
        EventResult result = EventResult.SUCCESS;
        if (event.containsKey("req") && event.getProperty("req").equals("acl")) {
            int numUnits = eventInfo.unitIds.length;
            for (int i = 0; i != numUnits; ++i) {
                if (this.handleACLRequest(eventInfo.unitIds[i])) continue;
                result = EventResult.ERROR;
                break;
            }
        }
        return result;
    }

    protected boolean handleACLRequest(long unitId) {
        log.trace((Object)"handleACLRequest()");
        try {
            this.unitUserFacade.updateUnitModel(unitId, true);
        }
        catch (UnitNotFoundException ex) {
            log.error((Object)"handleACLRequest() runs into", (Throwable)ex);
        }
        catch (Exception ex) {
            log.error((Object)"handleACLRequest() runs into", (Throwable)ex);
        }
        return true;
    }

    @Override
    public void initialize() {
        try {
            InitialContext context = new InitialContext();
            this.unitUserFacade = (UnitUserLocal)context.lookup("rts/UnitUser/local");
        }
        catch (Exception e) {
            log.error((Object)"ACLEventHandler() runs into", (Throwable)e);
            throw new EJBException("EJB reference problem", e);
        }
    }
}

