/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.event;

import de.proveo.eventbase.EventResponse;
import de.proveo.eventbase.EventUtil;
import de.proveo.rts.configuration.infoman.InfomanEventServiceMBean;
import de.proveo.rts.configuration.monitor.MonitoringMBean;
import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.util.service.ServiceFactory;
import de.proveo.wwt.logic.ejb.dataIn.event.EventHandlerChain;
import de.proveo.wwt.logic.ejb.dataIn.event.EventInfo;
import de.proveo.wwt.logic.ejb.dataIn.event.EventResult;
import de.proveo.wwt.logic.ejb.dataIn.event.handlers.IEventHandler;
import de.proveo.wwt.logic.ejb.dataIn.informant.InformantFacadeLocal;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.naming.InitialContext;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EventManager {
    private static final Log log = LogFactory.getLog(EventManager.class);
    private final List<Class<? extends IEventHandler>> eventHandlers;
    private static final int EVENT_CHAIN_LIFETIME = 30;
    private static ConcurrentLinkedQueue<EventHandlerChain> eventHandlerChains = new ConcurrentLinkedQueue();
    private InfomanEventServiceMBean infomanEventService;
    private MonitoringMBean eventCounter;
    private InformantFacadeLocal informantFacade;
    private TransactionManager transactionManager;

    public EventManager(List<Class<? extends IEventHandler>> eventHandlers) {
        this.eventHandlers = eventHandlers;
        try {
            this.infomanEventService = (InfomanEventServiceMBean)ServiceFactory.getInstance().getService(InfomanEventServiceMBean.class);
            this.eventCounter = (MonitoringMBean)ServiceFactory.getInstance().getService(MonitoringMBean.class, "Events");
            InitialContext ctx = new InitialContext();
            this.informantFacade = (InformantFacadeLocal)ctx.lookup("rts/InformantFacade/local");
            this.transactionManager = (TransactionManager)ctx.lookup("java:/TransactionManager");
        }
        catch (Exception e) {
            log.error((Object)"Runs into", (Throwable)e);
        }
    }

    public void clearEventHandlerQueue() {
        eventHandlerChains.clear();
    }

    public EventResponse handleEvent(Properties event, EventInfo eventInfo) {
        EventResult result;
        EventResponse eventResponse;
        block9: {
            eventResponse = new EventResponse();
            if (eventInfo == null) {
                eventInfo = new EventInfo();
            }
            if (eventInfo.receiveTime == 0L) {
                eventInfo.receiveTime = System.currentTimeMillis();
            }
            ArrayList<SerializableEventWrapper> eventWrappers = new ArrayList<SerializableEventWrapper>();
            try {
                result = this.preTransaction(event, eventResponse, eventInfo, eventWrappers);
                if (result != EventResult.SUCCESS) break block9;
                Transaction firstTx = this.transactionManager.suspend();
                try {
                    result = this.doEventHandling(event, eventResponse, eventInfo, eventWrappers);
                }
                catch (Exception e) {
                    log.error((Object)("Error handling event " + event), (Throwable)e);
                    result = EventResult.ERROR;
                }
                this.transactionManager.resume(firstTx);
                if (result == EventResult.SUCCESS) {
                    result = this.postTransaction(event, eventResponse, eventInfo, eventWrappers);
                }
            }
            catch (Exception e) {
                log.error((Object)("Error handling event " + event), (Throwable)e);
                result = EventResult.ERROR;
            }
        }
        eventResponse.setEventResponse(result != EventResult.ERROR);
        if (result == EventResult.ERROR && this.infomanEventService.isAcceptErrorAndReset(eventInfo.unitIds)) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("accept error event " + event));
            }
            eventResponse.setEventResponse(true);
        }
        return eventResponse;
    }

    private EventResult processEvent(Properties event, EventResponse eventResponse, EventInfo eventInfo, ArrayList<SerializableEventWrapper> eventWrappers) throws InstantiationException, IllegalAccessException {
        EventHandlerChain eventHandlerChain = eventHandlerChains.poll();
        if (eventHandlerChain == null) {
            eventHandlerChain = new EventHandlerChain(this.eventHandlers, 30);
        }
        EventResult result = EventResult.SUCCESS;
        for (IEventHandler eventHandler : eventHandlerChain.getEventHandlers()) {
            if (result == EventResult.SUCCESS && (result = this.preProcessEvent(event, eventResponse, eventHandler, eventInfo)) == EventResult.SUCCESS && (result = eventHandler.handleEvent(event, eventResponse, eventInfo, eventWrappers)) == EventResult.SUCCESS) {
                result = this.postProcessEvent(event, eventResponse, eventHandler, eventInfo);
            }
            if (result == EventResult.SUCCESS) continue;
            break;
        }
        if (!eventHandlerChain.hasExpired()) {
            eventHandlerChains.add(eventHandlerChain);
        }
        return result;
    }

    protected EventResult preTransaction(Properties event, EventResponse eventResponse, EventInfo eventInfo, ArrayList<SerializableEventWrapper> eventWrappers) {
        return EventResult.SUCCESS;
    }

    protected EventResult postTransaction(Properties event, EventResponse eventResponse, EventInfo eventInfo, ArrayList<SerializableEventWrapper> eventWrappers) {
        try {
            this.sendEventWrappers(eventWrappers);
            return EventResult.SUCCESS;
        }
        catch (Exception ex) {
            log.error((Object)"sendEventWrappers() runs into", (Throwable)ex);
            return EventResult.ERROR;
        }
    }

    public void sendEventWrappers(ArrayList<SerializableEventWrapper> eventWrappers) {
        for (SerializableEventWrapper wrapper : eventWrappers) {
            if (wrapper == null) continue;
            this.informantFacade.notify(wrapper, wrapper.get_typeOfEvent());
        }
    }

    protected EventResult doEventHandling(Properties event, EventResponse eventResponse, EventInfo eventInfo, ArrayList<SerializableEventWrapper> eventWrappers) {
        try {
            this.transactionManager.begin();
            EventResult result = this.preEventHandling(event, eventResponse, eventInfo);
            if (result == EventResult.SUCCESS && (result = this.processEvent(event, eventResponse, eventInfo, eventWrappers)) == EventResult.SUCCESS) {
                result = this.postEventHandling(event, eventResponse, eventInfo);
            }
            if (this.transactionManager.getStatus() == 0) {
                if (result == EventResult.SUCCESS || result == EventResult.SUCCESS_BUT_STOP_HANDLER_CHAIN) {
                    this.transactionManager.commit();
                } else {
                    this.transactionManager.rollback();
                    log.warn((Object)"Eventhandling transaction returned not successful - transaction.rollback");
                }
            }
            return result;
        }
        catch (Exception e) {
            log.error((Object)"runs into", (Throwable)e);
            try {
                if (this.transactionManager.getStatus() == 0) {
                    this.transactionManager.rollback();
                }
            }
            catch (Exception e1) {
                log.error((Object)"runs into", (Throwable)e1);
            }
            return EventResult.ERROR;
        }
    }

    protected EventResult preEventHandling(Properties event, EventResponse eventResponse, EventInfo eventInfo) {
        String ping;
        if (event.size() == 0) {
            log.warn((Object)"handleEvent() event contains no data");
            return EventResult.SUCCESS_BUT_STOP_HANDLER_CHAIN;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("handleEvent() " + event));
        }
        if ((ping = event.getProperty("p")) != null && ping.equals("ejb")) {
            eventResponse.setEventResponse(true);
            return EventResult.SUCCESS_BUT_STOP_HANDLER_CHAIN;
        }
        eventInfo.unitIds = EventUtil.getUnitIds((Properties)event);
        if (event.getProperty("hwsn") != null) {
            eventInfo.serialNumber = event.getProperty("hwsn");
        }
        if (event.getProperty("hwType") == null) {
            if (eventInfo.deviceType == null) {
                event.setProperty("hwType", "infoman");
                eventInfo.deviceType = event.getProperty("hwType");
            } else {
                event.setProperty("hwType", eventInfo.deviceType);
            }
        } else {
            eventInfo.deviceType = event.getProperty("hwType");
        }
        this.eventCounter.increment(eventInfo.unitIds.length);
        return EventResult.SUCCESS;
    }

    protected EventResult postEventHandling(Properties event, EventResponse eventResponse, EventInfo eventInfo) {
        if (this.infomanEventService.getAdditionalEventSleepTime() != 0) {
            try {
                Thread.sleep(this.infomanEventService.getAdditionalEventSleepTime());
            }
            catch (InterruptedException ex) {
                log.error((Object)"Simulation of long event handling time. Runs into", (Throwable)ex);
            }
        }
        return EventResult.SUCCESS;
    }

    protected void handleError(Properties event, EventResponse eventResponse) {
    }

    protected EventResult preProcessEvent(Properties event, EventResponse eventResponse, IEventHandler handlerClass, EventInfo eventInfo) {
        return EventResult.SUCCESS;
    }

    protected EventResult postProcessEvent(Properties event, EventResponse eventResponse, IEventHandler handlerClass, EventInfo eventInfo) {
        return EventResult.SUCCESS;
    }
}

